/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataTextPosition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Standard;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MarkerObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

class JChart_2D_Scat
extends JChart_2D_Standard {
    static final int HORZ_QUAD_LINE = 500;
    static final int VERT_QUAD_LINE = 600;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Scat(perspective);
        }
    };

    protected JChart_2D_Scat(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        super.calc();
        if (!this.m_Perspective.getPDECalc()) {
            if (this.m_Perspective.getConnectScatterMarkers()) {
                this.drawLines(false);
            }
            this.drawTrendlines();
            this.drawQuadrantLines();
            this.drawMarkers();
            this.drawUserLines();
            this.drawDataLabels();
        }
    }

    protected void drawQuadrantLines() {
        IdentObj newID;
        int i;
        IdentObj id = Identity.QuadrantLine;
        boolean bDisplay = this.m_gt.isBubble() ? this.m_Perspective.getDisplay(id) : this.m_Perspective.getDisplay(Identity.ScatterQuadrantLine);
        if (!bDisplay) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        blackBox.setBorderColor(this.m_Perspective.getBorderColor(id));
        double fWidth = this.m_Perspective.getLineWidth(id);
        int nVert = this.m_Perspective.getQuadrantLineCountX();
        int nHorz = this.m_Perspective.getQuadrantLineCountY();
        Rectangle rFrame = this.m_Perspective.getFrameRect(true);
        int x0 = rFrame.x;
        int x1 = rFrame.x + rFrame.width;
        int y0 = rFrame.y;
        int y1 = rFrame.y + rFrame.height;
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        for (i = 0; i < nHorz; ++i) {
            double yValue = this.m_Perspective.getQuadrantLineValueY(i);
            int yQuad = yValue == 1.234567E301 ? y0 + (i + 1) * rFrame.height / (nHorz + 1) : y0 + (int)(this.getY1Axis().getValueRelCoord(yValue) * (double)rFrame.height);
            newID = id;
            newID = newID.changeMisc(i + 500);
            line2D.createLine(id, newID, x0, yQuad, x1, yQuad, blackBox, this.m_rClip, fWidth);
        }
        for (i = 0; i < nVert; ++i) {
            double xValue = this.m_Perspective.getQuadrantLineValueX(i);
            int xQuad = xValue == 1.234567E301 ? x0 + (i + 1) * rFrame.width / (nVert + 1) : x0 + (int)(this.getX1Axis().getValueRelCoord(xValue) * (double)rFrame.width);
            newID = id;
            newID = newID.changeMisc(i + 600);
            line2D.createLine(id, newID, xQuad, y0, xQuad, y1, blackBox, this.m_rClip, fWidth);
        }
    }

    protected Point getCoords(int s, int g) {
        Point center = !this.m_bHorz ? new Point(this.numericXCoord[s][g], this.numericYCoord[s][g]) : new Point(this.numericYCoord[s][g], this.numericXCoord[s][g]);
        return center;
    }

    public Point2D getDataValuesXY(int s, int g) {
        double x = this.getXValue(s, g);
        double y = this.getYValue(s, g);
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public int getMarkerSize(int s, int g) {
        int mSize = super.getMarkerSize(s, g);
        if (this.m_gt.isBubble()) {
            double fValueZ = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XYZ_Z).value;
            double fRelSize = this.m_Z1Axis.getValueRelCoord(fValueZ);
            double fraction = this.m_Perspective.getMinBubbleSize() / this.m_Perspective.getMaxBubbleSize();
            return (int)((fraction + (1.0 - fraction) * fRelSize) * this.m_Perspective.getMaxBubbleSize() * 2.5 * 1.6);
        }
        return mSize;
    }

    private double getXValue(int s, int g) {
        DataItem item = DataItem.DI_XY_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        return dObj.value;
    }

    private double getYValue(int s, int g) {
        DataItem item = DataItem.DI_XY_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        return dObj.value;
    }

    public boolean wantLegend() {
        boolean gtWantsLegend = this.m_Perspective.getJGraphType().hasLegend();
        return gtWantsLegend;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        boolean bBubble = this.m_gt.isBubble();
        String result = dataTextTemplate;
        result = TextUtil.ReplaceMacro(result, "[X]", dataItems[0]);
        result = TextUtil.ReplaceMacro(result, "[Y]", dataItems[1]);
        if (bBubble) {
            result = TextUtil.ReplaceMacro(result, "[SIZE]", dataItems[2]);
        }
        return result;
    }

    protected Rectangle calcDataValuePosition(int s, int g, int nDataTextPosition, int nDataTextPositionSecondary, Dimension dimLabel) {
        Rectangle rDataTextPos = null;
        int nValueCoord = this.numericYCoord[s][g];
        INumericAxis yAxisObj = this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
            int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
            int nPrevCoord = 0;
            boolean bPrevCoordValid = false;
            if (sPrev != -2) {
                bPrevCoordValid = true;
                nPrevCoord = this.numericYCoord[sPrev][g];
            }
            Point ptTwoHalfDOffset = this.getFrame().getDepthOffset(1.0);
            Dimension baseMarkerSize = this.getBaseMarkerSize(s, g);
            Dimension fullMarkerSize = MarkerObj.getMarkerSize(this.getMarkerTemplate(s), baseMarkerSize);
            Point ptCenterTop = this.getCoords(s, g);
            ptCenterTop.y += fullMarkerSize.height / 2;
            int nBaseCoord = ptCenterTop.y - fullMarkerSize.height;
            Point ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(s);
            double fDataValue = this.m_Perspective.getJGraphType().getIsNumericScaleAxis() ? this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XY_Y).value : this.getDataValue((int)s, (int)g).value;
            double fStackedCumVal = this.getStackedCumulativeValue(s, g);
            double fPercentCumVal = this.getPercentCumulativeValue(s, g);
            double fAngle = this.m_Perspective.getDataTextAngle(s, g);
            double fDist = this.m_Perspective.getDataTextRadius(s, g);
            boolean bIsDateScale = yAxisObj.isDateScale();
            DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nDataTextPositionSecondary, this.m_Perspective.getJGraphType(), ptTwoHalfDOffset, nBaseCoord, ptCenterTop, fullMarkerSize.width, dimLabel, ptFrontOffset, fDataValue, fStackedCumVal, fPercentCumVal, this.m_bHorz, this.isAxisAscending(s), fAngle, fDist, this.m_bIsComboWithNonBar, nPrevCoord, bPrevCoordValid, bIsDateScale);
            rDataTextPos = dataTextPos.calcPosition();
        }
        return rDataTextPos;
    }

    public int getXAxisMaxCoord() {
        IAxis2D xAxis = (IAxis2D)((Object)this.getX1Axis());
        return xAxis.getMaxVC();
    }

    public int getXAxisMinCoord() {
        IAxis2D xAxis = (IAxis2D)((Object)this.getX1Axis());
        return xAxis.getMinVC();
    }

    public int getXAxisCoord(int seriesId, double value) {
        INumericAxis xAxis = this.getX1Axis();
        return (int)xAxis.getValueCoord(value);
    }

    public double getXAxisValue(int coord) {
        INumericAxis xAxis = this.getX1Axis();
        return xAxis.getValueFromCoord(coord);
    }
}

