/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.CircularFrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.FrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Standard;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

abstract class JChart_2D_Circular
extends JChart_2D_Standard {
    protected JChart_2D_Circular(Perspective perspective) {
        super(perspective);
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        double fValue = 0.0;
        DataFormat df = this.getDataView().getDataFormat();
        int nItems = df.getNumDataItems();
        Point ptCoord = new Point(0, 0);
        double fRadius = 0.0;
        double fAngle = 0.0;
        String[] dataItemStringArray = new String[nItems];
        boolean bPolar = this.m_gt.isPolar();
        this.numericYCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.numericXCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                this.m_dataOK[s][g] = true;
                boolean bGotAngle = false;
                for (int i = 0; i < nItems; ++i) {
                    DataItem item = df.getDataItem(i);
                    INumericAxis axisObj = this.whichAxisForSeries(s, item);
                    if (axisObj == null) continue;
                    DatumObj dObj = this.getDataValue(s, g, item);
                    fValue = dObj.value;
                    if (!dObj.m_bOK) {
                        this.m_dataOK[s][g] = dObj.m_bOK;
                    }
                    if (this.m_DataLabels.wantDataLabel(s, g)) {
                        this.m_DataLabels.setDataValue(fValue, s, g);
                        if (bPolar) {
                            dataItemStringArray[i] = axisObj.getDataTextFormat().format(fValue);
                            this.m_DataLabels.setDataText(this.processDataTextTemplate(dataItemStringArray, this.m_Perspective.getDataTextTemplateScatter()), s, g);
                        } else {
                            this.m_DataLabels.setDataText(axisObj.getDataTextFormat().format(fValue), s, g);
                        }
                    }
                    if (this.isBadValueInLogscale(axisObj, fValue)) {
                        this.m_dataOK[s][g] = false;
                    }
                    if (this.isIgnoredOffScale(axisObj, fValue)) {
                        this.m_dataOK[s][g] = false;
                    }
                    if (item.isLabel()) continue;
                    if (item.getAssocAxis() == 0 || item.getAssocAxis() == 1) {
                        fRadius = axisObj.getValueCoord(fValue);
                        continue;
                    }
                    fAngle = axisObj.getValueCoord(fValue);
                }
                if (!bGotAngle && nItems == 1) {
                    fAngle = this.getO1Axis().getCenterCoord(g);
                }
                Rectangle rFrame = this.m_Perspective.getFrameRect(true);
                Dimension frameDim = new Dimension(rFrame.width, rFrame.height);
                Point frameCenter = new Point(rFrame.x + rFrame.width / 2, rFrame.y + rFrame.height / 2);
                if (!this.m_dataOK[s][g] && this.m_gt.equals(68)) {
                    fRadius = 0.0;
                }
                AxisUtils.polarToCartesian(ptCoord, fAngle, fRadius, frameDim, frameCenter, this.m_Perspective.getVC());
                this.numericXCoord[s][g] = ptCoord.x;
                this.numericYCoord[s][g] = ptCoord.y;
            }
        }
    }

    FrameObj createFrame() {
        return new CircularFrameObj(this.m_Perspective);
    }

    protected IOrdinalAxis createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        return AxisFactory.createCircularOrdinalAxis(this.m_Perspective, this.getDataView(), AxisTemplate.O1_AXIS, bAscending, 0, 100, false);
    }

    protected INumericAxis createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero();
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.createCircularNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.X1_AXIS, x1MinMaxObj, bAscending, false, 0, 100, false);
    }

    protected INumericAxis createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.createCircularNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y1_AXIS, y1MinMaxObj, bAscending, false, nOffset, nSize, true);
    }

    protected INumericAxis createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.createCircularNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y2_AXIS, y2MinMaxObj, bAscending, true, nOffset, nSize, true);
    }

    public Point dataToVirtualCoords(IdentObj id, double x, double y) {
        throw new UnsupportedOperationException("dataToVirtualCoords not supported by chart type " + this.m_gt);
    }

    protected void drawRisers() {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        int x0 = 0;
        int y0 = 0;
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            Polygon polygon = new Polygon();
            boolean bFirst = true;
            gEnum.reset();
            if (!gEnum.hasNext()) continue;
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                int x = this.numericXCoord[s][g];
                int y = this.numericYCoord[s][g];
                polygon.addPoint(x, y);
                if (!bFirst) continue;
                x0 = x;
                y0 = y;
                bFirst = false;
            }
            polygon.addPoint(x0, y0);
            IBlackBox blackBox = this.assignSeriesColor(s, 0);
            DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(500, s), polygon, blackBox, this.m_rClip);
        }
    }

    protected Point getCoords(int s, int g) {
        return new Point(this.numericXCoord[s][g], this.numericYCoord[s][g]);
    }
}

