/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextUtil {
    public static int getFontSizeHeightVC(Perspective persp, IdentObj idLabel) {
        int nFontSizeVC;
        boolean bLabelFontSizeAbsolute = persp.getFontSizeAbsolute(idLabel);
        if (bLabelFontSizeAbsolute) {
            VC theVC = persp.getVC();
            nFontSizeVC = theVC.destToVirtHeight(persp.getFontSize(idLabel));
        } else {
            nFontSizeVC = persp.getFontSizeVC(idLabel);
        }
        return nFontSizeVC;
    }

    public static double getFontSizeHeightDC(Perspective persp, IdentObj idLabel) {
        double nFontSizeHeightDC;
        boolean bLabelFontSizeAbsolute = persp.getFontSizeAbsolute(idLabel);
        if (bLabelFontSizeAbsolute) {
            nFontSizeHeightDC = persp.getFontSize(idLabel);
        } else {
            int nFontSizeHeightVC = persp.getFontSizeVC(idLabel);
            VC theVC = persp.getVC();
            nFontSizeHeightDC = theVC.virtToDestHeight(nFontSizeHeightVC);
        }
        return nFontSizeHeightDC;
    }

    public static Dimension getTextDimensionDC(Perspective persp, IdentObj idObj, String strText, Dimension dimMaxVC) {
        Dimension dimMaxDC = persp.getVC().virtToDest(dimMaxVC);
        double nFontSizeHeightDC = TextUtil.getFontSizeHeightDC(persp, idObj);
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(persp, idObj);
        boolean bWordWrap = persp.getTextWrap(idObj);
        Dimension dimTextDC = textStyle.getTextSizeDC(strText, nFontSizeHeightDC, dimMaxDC, null, bWordWrap);
        return dimTextDC;
    }

    public static List<String> getWrappedTextList(Perspective p, ITextStyle textStyle, String text, Dimension dimMaxVC) {
        return textStyle.getWrappedTextList(p, text, dimMaxVC);
    }

    public static Dimension getTextDimensionDC(Perspective persp, IdentObj idObj, String strText) {
        return TextUtil.getTextDimensionDC(persp, idObj, strText, new Dimension(16000, 16000));
    }

    public static Dimension getTextDimensionVC(Perspective persp, IdentObj id, String strText) {
        Dimension dimTextDC = TextUtil.getTextDimensionDC(persp, id, strText);
        Dimension dimTextVC = persp.getVC().destToVirt(dimTextDC);
        return dimTextVC;
    }

    public static Dimension getDimLargestWidthLabelDC(VC vc, Collection<String> labels, ITextStyle textStyle) {
        Dimension dimLabelMaxDC = new Dimension(20000, 20000);
        int nLargestWidth = 0;
        double nFontSizeDC = textStyle.getFontSizeDC(vc);
        for (String strLabel : labels) {
            boolean bTextWrap = textStyle.getWordWrap();
            Dimension dimLabelDC = textStyle.getTextSizeDC(strLabel, nFontSizeDC, dimLabelMaxDC, null, bTextWrap);
            if (dimLabelDC.width <= nLargestWidth) continue;
            nLargestWidth = dimLabelDC.width;
            dimLabelMaxDC = dimLabelDC;
        }
        return dimLabelMaxDC;
    }

    public static Dimension getDimLargestWidthLabelDC(VC vc, List<String> vectStrLabels, Dimension dimLabelMaxDC, ITextStyle textStyle) {
        int width = 0;
        int height = 0;
        double nFontSizeDC = textStyle.getFontSizeDC(vc);
        Rectangle rTextSaveDC = textStyle.getRectDC();
        Rectangle rTextDC = new Rectangle(rTextSaveDC.x, rTextSaveDC.y, dimLabelMaxDC.width, dimLabelMaxDC.height);
        textStyle.setRectDC(rTextDC);
        boolean oldAccuracy = textStyle.useAccurateTextSizeCalculation(true);
        for (int i = 0; i < vectStrLabels.size(); ++i) {
            String strLabel = vectStrLabels.get(i);
            boolean bTextWrap = textStyle.getWordWrap();
            Dimension dimLabelDC = textStyle.getTextSizeDC(strLabel, nFontSizeDC, dimLabelMaxDC, null, bTextWrap);
            if (dimLabelDC.width > width) {
                width = dimLabelDC.width;
            }
            if (dimLabelDC.height <= height) continue;
            height = dimLabelDC.height;
        }
        textStyle.useAccurateTextSizeCalculation(oldAccuracy);
        textStyle.setRectDC(rTextSaveDC);
        return new Dimension(width, height);
    }

    public static Dimension getSmallestLabelVC(List<Rectangle> rVectLabelsVC) {
        Dimension dimSmallestLabelVC = new Dimension(1000000, 1000000);
        for (int i = 0; i < rVectLabelsVC.size(); ++i) {
            Rectangle r = rVectLabelsVC.get(i);
            dimSmallestLabelVC.width = Math.min(dimSmallestLabelVC.width, r.width);
            dimSmallestLabelVC.height = Math.min(dimSmallestLabelVC.height, r.height);
        }
        return dimSmallestLabelVC;
    }

    public static Dimension getLargestLabelVC(List<Rectangle> rVectLabelsVC) {
        Dimension dimLargestLabelVC = new Dimension(0, 0);
        for (int i = 0; i < rVectLabelsVC.size(); ++i) {
            Rectangle r = rVectLabelsVC.get(i);
            dimLargestLabelVC.width = Math.max(dimLargestLabelVC.width, r.width);
            dimLargestLabelVC.height = Math.max(dimLargestLabelVC.height, r.height);
        }
        return dimLargestLabelVC;
    }

    public static String ReplaceMacro(String SourceString, String aMacro, String Replacement) {
        int aPosition;
        String aProcessedString = "";
        aProcessedString = SourceString;
        while ((aPosition = aProcessedString.indexOf(aMacro)) != -1) {
            String testString = aProcessedString.substring(0, aPosition);
            testString = testString + Replacement;
            aProcessedString = testString = testString + aProcessedString.substring(aPosition += aMacro.length(), aProcessedString.length());
        }
        return aProcessedString;
    }
}

