/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.PatternTable;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BorderObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillColorObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillTextureObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackBoxObj
implements IBlackBox {
    private static final int SCALE_FACTOR = 50;
    private Perspective m_Perspective;
    private FillObj m_FillObj;
    private BorderObj m_BorderObj;
    private Color m_DropShadowColor;
    private Dimension m_DropShadowOffsetDC;
    private boolean m_bTransparentBorderColor;
    private boolean isFillColorTransparent;
    Color m_ChartBackgroundColor;
    String m_szTextureURL = null;
    private boolean m_isSpecular = false;
    private Color m_defaultFill;
    private IdentObj m_id = Identity.ID_GLOBAL;

    private BlackBoxObj() {
        this.m_BorderObj = new BorderObj(Color.black);
        this.m_FillObj = new FillColorObj(Color.white);
        this.m_DropShadowColor = Color.black;
        this.m_DropShadowOffsetDC = null;
    }

    public BlackBoxObj(BlackBoxObj bb) {
        this();
        this.copy(bb);
    }

    public BlackBoxObj(FillGradientObj fillGradObj, boolean bTransparentBorderColor, boolean bTransparentFillColor, Perspective p, IdentObj idObj) {
        this.m_Perspective = p;
        this.m_FillObj = fillGradObj;
        this.m_BorderObj = new BorderObj(Color.black);
        this.m_bTransparentBorderColor = bTransparentBorderColor;
        this.isFillColorTransparent = bTransparentFillColor;
        this.m_ChartBackgroundColor = null;
        this.m_DropShadowColor = null;
        this.m_DropShadowOffsetDC = null;
        this.m_defaultFill = p.getFillColor(idObj);
        this.m_id = idObj;
    }

    public BlackBoxObj(Perspective p, IdentObj id) {
        this.m_Perspective = p;
        this.m_isSpecular = this.m_Perspective.getSpecularLight();
        this.m_BorderObj = new BorderObj(p, id);
        this.m_defaultFill = p.getFillColor(id);
        this.m_id = id;
        switch (p.getFillType(id)) {
            case 1: {
                this.m_FillObj = new FillColorObj(p.getNPatternFill(id) > 0 ? p.getPaintObject(id) : p.getFillColor(id));
                break;
            }
            case 2: {
                FillGradientObj fillGradient = new FillGradientObj(p.getGradientDirection(id));
                int nPins = p.getGradientNumPins(id);
                for (int i = 0; i < nPins; ++i) {
                    fillGradient.insertPin(p.getGradientPinPosition(id, i), p.getGradientPinLeftColor(id, i), p.getGradientPinRightColor(id, i));
                }
                this.m_FillObj = fillGradient;
                break;
            }
            case 3: {
                this.m_szTextureURL = p.getTexture(id);
                Image img = p.getTexture(this.m_szTextureURL);
                int nFlipMode = p.getTextureFlipMode(id);
                byte[] metafileData = p.getMetafileData(this.m_szTextureURL);
                Color aColor = p.getTextureBGColor(id);
                if (metafileData != null) {
                    this.m_FillObj = new FillTextureObj(metafileData, nFlipMode);
                    break;
                }
                if (img != null) {
                    int nDisplayMode = p.getTextureDisplayMode(id);
                    this.m_FillObj = new FillTextureObj(img, nDisplayMode, nFlipMode, 0, aColor);
                    break;
                }
                this.m_FillObj = new FillColorObj(p.getFillColor(id));
                p.setFillType(id, 1);
            }
        }
        this.m_bTransparentBorderColor = this.m_Perspective.getTransparentBorderColor(id);
        this.isFillColorTransparent = this.m_Perspective.getTransparentFillColor(id);
        this.m_ChartBackgroundColor = p.getFillColor(Identity.ChartBackground);
        this.m_DropShadowColor = p.getShadowColor(id);
        this.m_DropShadowOffsetDC = p.getShadowDisplay(id) && !this.isFillColorTransparent ? new Dimension(p.getVC().virtToDestWidth(p.getShadowXOffset(id) * 50), p.getVC().virtToDestHeight(p.getShadowYOffset(id) * 50)) : null;
    }

    @Override
    public Object clone(Object obj) {
        if (!(obj instanceof BlackBoxObj)) {
            return null;
        }
        return new BlackBoxObj((BlackBoxObj)obj);
    }

    public void copy(BlackBoxObj bb) {
        this.m_FillObj = bb.m_FillObj instanceof FillGradientObj ? new FillGradientObj(3) : (bb.m_FillObj instanceof FillTextureObj ? new FillTextureObj() : new FillColorObj());
        this.m_FillObj.copy(bb.m_FillObj);
        this.m_BorderObj = bb.m_BorderObj;
        this.m_Perspective = bb.m_Perspective;
        this.m_DropShadowColor = bb.m_DropShadowColor;
        this.m_DropShadowOffsetDC = bb.m_DropShadowOffsetDC;
        this.m_bTransparentBorderColor = bb.m_bTransparentBorderColor;
        this.isFillColorTransparent = bb.isFillColorTransparent;
        this.m_isSpecular = bb.m_isSpecular;
        this.m_defaultFill = bb.m_defaultFill;
        this.m_id = bb.m_id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlackBoxObj)) {
            return false;
        }
        BlackBoxObj bb2 = (BlackBoxObj)obj;
        boolean bEqual = this.m_FillObj.equals(bb2.m_FillObj) && this.m_defaultFill.equals(bb2.m_defaultFill);
        return bEqual &= this.m_id.equals(bb2.m_id);
    }

    @Override
    public void setBorderProperties(IdentObj objectID) {
        this.m_BorderObj = new BorderObj(this.m_Perspective, objectID);
        this.m_bTransparentBorderColor = this.m_Perspective.getTransparentBorderColor(objectID);
    }

    @Override
    public Color getBorderColor() {
        return this.m_BorderObj.getColor();
    }

    @Override
    public Color getFillColor() {
        Paint paint;
        if (this.m_FillObj instanceof FillColorObj && (paint = ((FillColorObj)this.m_FillObj).getPaint()) instanceof Color) {
            return (Color)paint;
        }
        return this.m_defaultFill;
    }

    @Override
    public boolean isSpecularLight() {
        return this.m_isSpecular;
    }

    @Override
    public final boolean copyGradientColors(List<ColorPinObj> list) {
        boolean isOK = this.m_FillObj != null && this.m_FillObj instanceof FillGradientObj;
        isOK = isOK && ((FillGradientObj)this.m_FillObj).copyGradientColors(list);
        return isOK;
    }

    @Override
    public int getFillType() {
        if (this.m_FillObj instanceof FillGradientObj) {
            return 2;
        }
        if (this.m_FillObj instanceof FillTextureObj) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    @Override
    public boolean getTransparentFillColor() {
        return this.isFillColorTransparent;
    }

    @Override
    public void setTransparentFillColor(boolean bTransparent) {
        this.isFillColorTransparent = bTransparent;
    }

    @Override
    public void setTransparentBorderColor(boolean bTransparent) {
        this.m_bTransparentBorderColor = bTransparent;
    }

    public void setDropShadowOffsetDC(Dimension dimDropShadowDC) {
        this.m_DropShadowOffsetDC = dimDropShadowDC;
    }

    @Override
    public void paintLine(Graphics2D g, Point pt1, Point pt2, Stroke penStroke) {
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paintLine(g, pt1, pt2, penStroke);
        }
    }

    @Override
    public void paintPolygon(Graphics2D g, Polygon p) {
        if (this.m_DropShadowOffsetDC != null) {
            Polygon pDropShadow = new Polygon();
            for (int i = 0; i < p.npoints; ++i) {
                pDropShadow.addPoint(p.xpoints[i] + this.m_DropShadowOffsetDC.width, p.ypoints[i] + this.m_DropShadowOffsetDC.height);
            }
            g.setColor(this.m_DropShadowColor);
            g.fillPolygon(pDropShadow);
        }
        if (!this.isFillColorTransparent) {
            this.m_FillObj.fillPolygon(g, p);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, p);
        }
    }

    @Override
    public void paintRect(Graphics2D g, Rectangle r) {
        this.paintRect(g, r, false);
    }

    @Override
    public void paintRect(Graphics2D g, Rectangle r, boolean bNoFill) {
        this.paintRectDotted(g, r, bNoFill, false);
    }

    @Override
    public void paintOval(Graphics2D g, Rectangle r, boolean bNoFill) {
        this.paintOvalDropShadow(g, r);
        if (!this.isFillColorTransparent && !bNoFill) {
            this.m_FillObj.fillOval(g, r);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paintOval(g, r);
        }
    }

    private void paintOvalDropShadow(Graphics2D g, Rectangle r) {
        if (this.m_DropShadowOffsetDC != null) {
            Rectangle rDropShadow = new Rectangle(r.x + this.m_DropShadowOffsetDC.width, r.y + this.m_DropShadowOffsetDC.height, r.width, r.height);
            g.setColor(this.m_DropShadowColor);
            g.fillOval(rDropShadow.x, rDropShadow.y, rDropShadow.width, rDropShadow.height);
        }
    }

    @Override
    public void paintRectDotted(Graphics2D g, Rectangle r, boolean bNoFill, boolean bDotted) {
        this.paintDropShadow(g, r);
        if (!this.isFillColorTransparent && !bNoFill) {
            String strVersion;
            Double ver;
            this.m_FillObj.fillRect(g, r);
            if (this.m_id.getObjectID() == 1 && Double.compare(ver = Double.valueOf((strVersion = System.getProperty("java.version")).substring(0, 3)), 1.6) < 0) {
                BorderObj tempObj = new BorderObj(this.getFillColor());
                tempObj.paintNoAntialias(g, r);
            }
        }
        if (!this.m_bTransparentBorderColor) {
            if (bDotted) {
                this.m_BorderObj.paint(g, r, bDotted);
            } else {
                this.m_BorderObj.paint(g, r);
            }
        }
    }

    private void paintDropShadow(Graphics2D g, Rectangle r) {
        if (this.m_DropShadowOffsetDC != null) {
            Rectangle rDropShadow = new Rectangle(r.x + this.m_DropShadowOffsetDC.width, r.y + this.m_DropShadowOffsetDC.height, r.width, r.height);
            g.setColor(this.m_DropShadowColor);
            g.fillRect(rDropShadow.x, rDropShadow.y, rDropShadow.width, rDropShadow.height);
        }
    }

    @Override
    public void paintArc2D(Graphics2D g2D, Arc2D arc2D) {
        if (!this.isFillColorTransparent) {
            this.m_FillObj.fillArc(g2D, arc2D);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g2D, arc2D);
        }
    }

    @Override
    public void setBorderColor(Color color) {
        this.m_BorderObj.setColor(color);
    }

    @Override
    public void setFillColor(Color color) {
        if (this.m_FillObj == null || !(this.m_FillObj instanceof FillColorObj)) {
            this.m_FillObj = new FillColorObj();
        }
        ((FillColorObj)this.m_FillObj).setPaint(color);
        this.m_defaultFill = color;
    }

    @Override
    public Color getGradientColorAt(double relValue) {
        if (this.m_FillObj instanceof FillGradientObj) {
            return ((FillGradientObj)this.m_FillObj).getColorAt(relValue);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public FillGradientObj getFillGradientObj() {
        FillGradientObj obj = null;
        if (this.m_FillObj != null && this.m_FillObj instanceof FillGradientObj) {
            obj = new FillGradientObj(3);
            obj.copy(this.m_FillObj);
        }
        return obj;
    }

    @Override
    public Image getTexture() {
        if (this.m_FillObj instanceof FillTextureObj) {
            return ((FillTextureObj)this.m_FillObj).getTexture();
        }
        return null;
    }

    @Override
    public Dimension getDropShadowOffset() {
        return this.m_DropShadowOffsetDC;
    }

    @Override
    public Color getDropShadowColor() {
        return this.m_DropShadowColor;
    }

    @Override
    public int getGradientDirection() {
        return this.m_FillObj.getGradientDirection();
    }

    @Override
    public void paintShape(Graphics2D g2D, Shape shapeDC) {
        if (!this.isFillColorTransparent) {
            this.m_FillObj.fillShape(g2D, shapeDC);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paintShape(g2D, shapeDC);
        }
    }

    @Override
    public void setRenderingTweaks(IdentObj id) {
        switch (id.getObjectID()) {
            case 500: 
            case 521: 
            case 542: 
            case 543: 
            case 544: 
            case 1005: {
                this.m_FillObj.setInternalFillBorder(0.75);
                break;
            }
            default: {
                this.m_FillObj.setInternalFillBorder(0.0);
            }
        }
        this.m_BorderObj.suppressAntiAliasingOnHorizontalAndVerticalLines(true);
    }

    @Override
    public Stroke getPenStroke() {
        return this.m_BorderObj.getPenStroke();
    }

    @Override
    public void setIntensity(double intensity) {
        this.m_FillObj.setIntensity(intensity);
    }

    @Override
    public double getIntensity() {
        return this.m_FillObj.getIntensity();
    }

    @Override
    public void setAnchorRect(Rectangle2D anchor) {
        if (this.m_FillObj instanceof FillGradientObj) {
            FillGradientObj gradient = (FillGradientObj)this.m_FillObj;
            gradient.setAnchorRect(anchor);
        }
    }

    @Override
    public void setHighlightColor(Color highlight) {
        int nPattern = this.m_Perspective.getNPatternFill(this.m_id);
        if (nPattern > 0) {
            Color bg = this.m_Perspective.getPatternBackground(this.m_id);
            this.m_FillObj = new FillColorObj(PatternTable.getTexturePattern(nPattern, bg, highlight));
        } else {
            this.setFillColor(highlight);
        }
    }
}

