/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.IAdvFormatStructExporter;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatOptions;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class PFJDecimalFormat
extends DecimalFormat
implements IAdvFormatStructExporter {
    public PFJDecimalFormat() {
    }

    public PFJDecimalFormat(String pattern) {
        super(pattern);
    }

    public PFJDecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        super(pattern, symbols);
    }

    public StringBuffer format(double number_, StringBuffer result, FieldPosition fieldPosition) {
        double number = number_;
        if (this.absRemainder(number * (double)this.getMultiplier()) == 0.5) {
            number += Math.signum(number) * 0.1 / (this.roundFactor() * (double)this.getMultiplier());
        }
        return super.format(number, result, fieldPosition);
    }

    private final double absRemainder(double inval) {
        double value = Math.abs(inval) * this.roundFactor();
        return value - Math.floor(value);
    }

    private final double roundFactor() {
        return Math.pow(10.0, this.getMaximumFractionDigits());
    }

    public AdvFormatStruct toAdvFormatStruct() {
        AdvFormatStruct fmt = new AdvFormatStruct();
        DecimalFormatSymbols fmtSymbols = this.getDecimalFormatSymbols();
        String posFmt = this.getPositiveFormat();
        String negFmt = this.getNegativeFormat();
        fmt.szCurrency = fmtSymbols.getCurrencySymbol().toCharArray();
        fmt.szDecimal[0] = fmtSymbols.getDecimalSeparator();
        fmt.szThousand[0] = this.isGroupingUsed() ? fmtSymbols.getGroupingSeparator() : (char)'\u0000';
        fmt.iLZero = this.getMinimumIntegerDigits();
        fmt.iGrouping = this.getGroupingSize();
        fmt.iDigits = this.getMinimumFractionDigits();
        fmt.iNegNumber = 1;
        if (posFmt.contains("\u00a4")) {
            fmt.formatType = NumberFormatOptions.CurrencyFormat.ordinal();
            fmt.szMonDecimalSep[0] = fmtSymbols.getMonetaryDecimalSeparator();
            fmt.szMonThousandSep[0] = fmtSymbols.getGroupingSeparator();
            fmt.iPosCurr = this.decodePosCurr(posFmt);
            fmt.iNegCurr = this.decodeNegCurr(posFmt, negFmt);
            fmt.iMonGrouping = this.getGroupingSize();
            fmt.iCurrDigits = this.getMinimumFractionDigits();
        } else if (posFmt.contains("%")) {
            fmt.formatType = NumberFormatOptions.PercentFormat.ordinal();
            fmt.bPrefixPercentSymbol = posFmt.startsWith("%") ? (short)1 : 0;
        } else if (posFmt.contains("E")) {
            fmt.formatType = NumberFormatOptions.ScientificFormat.ordinal();
            fmt.szScientificSymbol[0] = 101;
        } else {
            fmt.formatType = NumberFormatOptions.NumberFormat.ordinal();
        }
        return fmt;
    }

    private int decodePosCurr(String posFmt) {
        if (posFmt.startsWith("\u00a4 ")) {
            return 2;
        }
        if (posFmt.startsWith("\u00a4")) {
            return 0;
        }
        if (posFmt.endsWith(" \u00a4")) {
            return 3;
        }
        if (posFmt.endsWith("\u00a4")) {
            return 1;
        }
        assert (false);
        return 0;
    }

    private int decodeNegCurr(String posFmt, String negFmt) {
        String basePattern = posFmt.replace("\u00a4", "").trim();
        String simple = negFmt.replace(basePattern, "X");
        if ("($X)".equals(simple = simple.replace('\u00a4', '$'))) {
            return 0;
        }
        if ("-$X".equals(simple)) {
            return 1;
        }
        if ("$-X".equals(simple)) {
            return 2;
        }
        if ("$X-".equals(simple)) {
            return 3;
        }
        if ("(X$)".equals(simple)) {
            return 4;
        }
        if ("-X$".equals(simple)) {
            return 5;
        }
        if ("X-$".equals(simple)) {
            return 6;
        }
        if ("X$-".equals(simple)) {
            return 7;
        }
        if ("-X $".equals(simple)) {
            return 8;
        }
        if ("-$ X".equals(simple)) {
            return 9;
        }
        if ("X $-".equals(simple)) {
            return 10;
        }
        if ("$ X-".equals(simple)) {
            return 11;
        }
        if ("$ -X".equals(simple)) {
            return 12;
        }
        if ("X- $".equals(simple)) {
            return 13;
        }
        if ("($ X)".equals(simple)) {
            return 14;
        }
        if ("(X $)".equals(simple)) {
            return 15;
        }
        assert (false);
        return 2;
    }

    String getPositiveFormat() {
        String string = this.toPattern();
        int indexof = string.indexOf(59);
        if (indexof < 0) {
            return string;
        }
        return string.substring(0, indexof);
    }

    String getNegativeFormat() {
        String string = this.toPattern();
        int indexof = string.indexOf(59);
        if (indexof < 0) {
            return "-" + string;
        }
        return string.substring(indexof + 1);
    }
}

