/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

public class DataRange {
    private int m_rowStart;
    private int m_rowStop;
    private int m_colStart;
    private int m_colStop;

    public DataRange() {
        this.m_rowStart = 0;
        this.m_rowStop = -1;
        this.m_colStart = 0;
        this.m_colStop = -1;
    }

    public DataRange(DataRange src) {
        this.copy(src);
    }

    public DataRange(int rowStop, int colStop) {
        this.m_rowStart = 0;
        this.m_rowStop = rowStop;
        this.m_colStart = 0;
        this.m_colStop = colStop;
    }

    public DataRange(int rowStart, int colStart, int rowStop, int colStop) {
        this.m_rowStart = rowStart;
        this.m_rowStop = rowStop;
        this.m_colStart = colStart;
        this.m_colStop = colStop;
    }

    public void copy(DataRange src) {
        this.m_rowStart = src.getRowStart();
        this.m_colStart = src.getColStart();
        this.m_rowStop = src.getRowStop();
        this.m_colStop = src.getColStop();
    }

    public boolean equals(Object x) {
        if (!(x instanceof DataRange)) {
            return false;
        }
        DataRange xDR = (DataRange)x;
        return this.m_rowStart == xDR.m_rowStart && this.m_colStart == xDR.m_colStart && this.m_rowStop == xDR.m_rowStop && this.m_colStop == xDR.m_colStop;
    }

    public void extendTo(int row, int col) {
        if (row > this.m_rowStop) {
            this.m_rowStop = row;
        }
        if (col > this.m_colStop) {
            this.m_colStop = col;
        }
        if (row < this.m_rowStart) {
            this.m_rowStart = row;
        }
        if (col < this.m_colStart) {
            this.m_colStart = col;
        }
    }

    public void shrinkTo(int startRow, int startCol, int endRow, int endCol) {
        if (endRow < this.m_rowStop) {
            this.m_rowStop = endRow;
        }
        if (endCol < this.m_colStop) {
            this.m_colStop = endCol;
        }
        if (startRow > this.m_rowStart) {
            this.m_rowStart = startRow;
        }
        if (startCol > this.m_colStart) {
            this.m_colStart = startCol;
        }
    }

    public int getColStart() {
        return this.m_colStart;
    }

    public int getColStop() {
        return this.m_colStop;
    }

    public int getNumCols() {
        return this.m_colStop - this.m_colStart + 1;
    }

    public int getNumRows() {
        return this.m_rowStop - this.m_rowStart + 1;
    }

    public int getRowStart() {
        return this.m_rowStart;
    }

    public int getRowStop() {
        return this.m_rowStop;
    }

    public boolean isCellValid(int row, int col) {
        boolean bValid = row >= this.m_rowStart && row <= this.m_rowStop && col >= this.m_colStart && col <= this.m_colStop;
        return bValid;
    }

    public int hashCode() {
        return this.m_rowStart + this.m_colStart + this.m_rowStop + this.m_colStop;
    }

    public String toString() {
        return "(rStart=" + this.m_rowStart + ", cStart=" + this.m_colStart + ", rStop=" + this.m_rowStop + ", cStop=" + this.m_colStop + ")";
    }
}

