/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.converter;

import com.businessobjects.visualization.pfjgraphics.rendering.common.ChartNotSupportedException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Graph;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphConverter;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphLoader;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TTFLoadException;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

class LoadPerspective {
    String m_filename;
    Perspective m_perspective;

    public LoadPerspective(String filename) {
        this.m_filename = filename;
        this.m_perspective = new Perspective();
    }

    public LoadPerspective(String filename, Perspective perspective) {
        this.m_filename = filename;
        this.m_perspective = perspective;
    }

    public Perspective getPerspective() {
        try {
            GraphLoader loader = new GraphLoader(new DataInputStream(new FileInputStream(this.m_filename)));
            loader.loadChart();
            Graph graph = loader.pGraph;
            GraphConverter gc = new GraphConverter(graph, this.m_perspective);
            gc.convertToPerspective();
        }
        catch (ChartNotSupportedException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TTFLoadException e) {
            e.printStackTrace();
        }
        return this.m_perspective;
    }
}

