/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.internal.Base64Coder;
import com.businessobjects.visualization.dataexchange.DataContext;
import com.businessobjects.visualization.dataexchange.DimensionLabelsContext;
import com.businessobjects.visualization.dataexchange.MeasureValuesContext;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.RegionCoordinates;
import com.businessobjects.visualization.graphic.RegionShape;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.map.GraphicMap;
import com.businessobjects.visualization.map.GraphicMapElement;
import com.businessobjects.visualization.map.IGraphicMap;
import com.businessobjects.visualization.pfjgraphics.EMFRecorder;
import com.businessobjects.visualization.pfjgraphics.PFJChartType;
import com.businessobjects.visualization.pfjgraphics.PFJDataEngine;
import com.businessobjects.visualization.pfjgraphics.PFJRenderEngine;
import com.businessobjects.visualization.pfjgraphics.PFJSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.common.ChartNotSupportedException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphConverter;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TTFLoadException;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Export3TF;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMSettings;
import com.businessobjects.visualization.rendering.RenderEngine;
import com.pietjonas.wmfwriter2d.WMFGraphics2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFJEngine {
    private static final int PATH_FLATNESS = 10;
    private PFJDataEngine dataEngine;
    private Perspective pfj;
    private CVOMHelper cvom;
    public static final String PROVIDER_ID = "PFJ";
    public static final String DEFAULT_ERROR_CODE = "0";

    PFJEngine(CVOMHelper cvom, Perspective pfj, PFJChartType chartType) {
        this.pfj = pfj;
        this.cvom = cvom;
        this.dataEngine = new PFJDataEngine(cvom, pfj, chartType);
    }

    public static PFJEngine createPFJEngine(GraphicInstance context) {
        CVOMHelper cvom = new CVOMHelper(context);
        VisuString ttfRecords = (VisuString)cvom.getProperty("root", "3tf");
        if (ttfRecords.getXmlValue().length() == 0 || ttfRecords.getXmlValue().length() == 28) {
            throw new VisualizationInternalException("We must have a root/3tf property value");
        }
        Perspective pfj = new Perspective(null);
        PFJSettings pfjSettings = new PFJSettings(cvom, pfj);
        pfjSettings.setPFJSizes();
        pfjSettings.setLocale();
        pfjSettings.setAutoArrange();
        PFJChartType pfjChartType = PFJChartType.create(cvom);
        PFJEngine.load3TFRecords(pfj, ttfRecords);
        pfjChartType.exhalePFJChartTypeSettings(pfj);
        pfj.setCvomSettings(new CVOMSettings(cvom));
        pfjSettings.initCVOMDefaults();
        return new PFJEngine(cvom, pfj, pfjChartType);
    }

    public static void import3tf(GraphicInstance graphicInstance, InputStream is) throws IOException, TTFLoadException, ChartNotSupportedException {
        CVOMHelper cvom = new CVOMHelper(graphicInstance);
        boolean useDefault3tf = is == null;
        byte[] tiff = useDefault3tf ? PFJEngine.loadDefault3tf(cvom) : PFJEngine.get3TFBytes(is);
        PFJEngine.importCVOMSettings(graphicInstance, new ByteArrayInputStream(tiff), useDefault3tf);
        if (tiff != null) {
            cvom.setProperty("root", "3tf", (VisuObject)new VisuString(Base64Coder.encode((byte[])tiff)));
        }
    }

    public static void export3tf(GraphicInstance graphicInstance, OutputStream os, boolean swapped) throws IOException {
        PFJEngine engine = PFJEngine.createPFJEngine(graphicInstance);
        engine.pfj.setSeriesAreRows(!swapped);
        Export3TF.saveTo3TF(engine.pfj, 0, false, new DataOutputStream(os), true);
    }

    public static void export3tf(GraphicInstance graphicInstance, OutputStream os) throws IOException {
        PFJEngine engine = PFJEngine.createPFJEngine(graphicInstance);
        Export3TF.saveTo3TF(engine.pfj, 0, false, new DataOutputStream(os), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadDefault3tf(CVOMHelper cvom) {
        PFJChartType chartType = PFJChartType.create(cvom);
        InputStream chartTemplateStream = null;
        byte[] tiff = null;
        try {
            URL chartTemplateURL = chartType.getDefaultChartURL();
            if (chartTemplateURL == null) {
                assert (false);
                byte[] byArray = null;
                return byArray;
            }
            chartTemplateStream = chartTemplateURL.openStream();
            tiff = PFJEngine.get3TFBytes(chartTemplateStream);
        }
        catch (Exception e) {
            assert (false);
        }
        finally {
            try {
                if (chartTemplateStream != null) {
                    chartTemplateStream.close();
                }
            }
            catch (IOException e) {}
        }
        return tiff;
    }

    private static void importCVOMSettings(GraphicInstance graphicInstance, InputStream is, boolean useDefault) throws TTFLoadException, ChartNotSupportedException {
        CVOMHelper cvom = new CVOMHelper(graphicInstance);
        CVOMSettings cvomSettings = new CVOMSettings(cvom);
        Perspective pfj = new Perspective(cvomSettings);
        pfj.setLocale(cvom.context.getLocalizedEngine().getLocale());
        PFJSettings pfjSettings = new PFJSettings(cvom, pfj);
        PFJChartType pfjChartType = null;
        if (useDefault) {
            pfj.setDocumentHeightInTwips(4320);
            pfj.setDocumentWidthInTwips(7200);
            GraphConverter.LoadChart(new DataInputStream(is), pfj);
            cvom.setProperty("root", "autoarrange", (VisuObject)VisuBool.TRUE);
            pfjChartType = PFJChartType.create(cvom);
        } else {
            GraphConverter.LoadChart(new DataInputStream(is), pfj);
            pfjChartType = PFJChartType.create(pfj);
        }
        pfjSettings.initCVOMPalette();
        pfjChartType.exhaleCVOMChartTypeSettings(cvom);
    }

    private static void displayAll(IGraphicNode rootNode, int level) {
        IGraphicNode[] nodes = rootNode.getChildren();
        if (nodes == null) {
            return;
        }
        for (IGraphicNode node : nodes) {
            for (int i = 0; i < level; ++i) {
                System.out.print("  ");
            }
            if (node.getDef().getNodeType().value() == 2) {
                System.out.println("(" + node.getId() + ")");
            } else {
                System.out.println(node.getId());
            }
            PFJEngine.displayAll(node, level + 1);
        }
    }

    private static byte[] get3TFBytes(InputStream is) throws IOException {
        int r;
        if (is == null) {
            return null;
        }
        byte[] buffer = new byte[4000];
        ByteArrayOutputStream ttfRecords = new ByteArrayOutputStream();
        while ((r = is.read(buffer, 0, buffer.length)) != -1) {
            ttfRecords.write(buffer, 0, r);
        }
        return ttfRecords.toByteArray();
    }

    private static void load3TFRecords(Perspective pfj, VisuString skippedRecords) {
        try {
            GraphConverter.LoadSkippedRecords(new DataInputStream(new ByteArrayInputStream(Base64Coder.decode((String)skippedRecords.getXmlValue()))), pfj);
        }
        catch (TTFLoadException e) {
            throw new VisualizationInternalException((Throwable)e);
        }
        catch (ChartNotSupportedException e) {
            throw new VisualizationInternalException((Throwable)e);
        }
    }

    public RenderEngine process(int outputType, int retrieveMap) {
        this.dataEngine.sendData();
        this.dataEngine.setHighlights();
        int width = this.getWidthDC();
        int height = this.getHeidthDC();
        int twipwidth = this.getWidthTwips();
        int twipheight = this.getHeightTwips();
        Detectiv d = this.pfj.generateDetectiv(width, height, twipwidth, twipheight);
        return new PFJRenderEngine(this, d, outputType);
    }

    public byte[] render(Detectiv d, int width, int height, int twipwidth, int twipheight, int outputType) {
        if (outputType == 0) {
            return null;
        }
        try {
            switch (outputType) {
                case 1: 
                case 4: {
                    return this.getRaserImageBytes(d, width, height, outputType);
                }
                case 8: {
                    return this.getEMFBytes(d, width, height, twipwidth, twipheight);
                }
            }
            throw new UnsupportedOperationException("PFJ cannot render to this outputType (" + outputType + ")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void render(Detectiv d, Graphics2D g2) {
        this.pfj.drawDetectiv(g2, d);
    }

    private byte[] getEMFBytes(Detectiv d, int width, int height, int twipwidth, int twipheight) {
        int DPI_X = width * 1440 / twipwidth;
        int DPI_Y = height * 1440 / twipheight;
        Rectangle rclFrame = new Rectangle(0, 0, width, height);
        EMFRecorder emfRecorder = EMFRecorder.CreateEMFRecorder(rclFrame, width, height, DPI_X, DPI_Y);
        WMFGraphics2D g = new WMFGraphics2D(emfRecorder, width, height);
        g.setGDIFontDrawing(true);
        this.pfj.drawDetectiv(g, d);
        emfRecorder.finalizeEMF();
        return emfRecorder.getMetafileData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getRaserImageBytes(Detectiv d, int width, int height, int outputType) throws IOException {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        String outputTypeString = "";
        if (outputType == 4) {
            outputTypeString = "png";
        } else if (outputType == 1) {
            outputTypeString = "bmp";
        } else {
            assert (false);
            return null;
        }
        Color clearColor = new Color(255, 255, 255, 0);
        g.setBackground(clearColor);
        g.clearRect(0, 0, width, height);
        this.pfj.drawDetectiv(g, d);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        ImageOutputStream outStream = ImageIO.createImageOutputStream(outBytes);
        try {
            ImageIO.write((RenderedImage)img, outputTypeString, outStream);
            byte[] byArray = outBytes.toByteArray();
            return byArray;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    IGraphicMap generateGraphicMap(Detectiv detectiv, int twipWidth, int twipHeight) {
        VC vc = new VC(twipWidth, twipHeight);
        GraphicMap map = new GraphicMap();
        ArrayList<IdentObj> keys = new ArrayList<IdentObj>();
        HashMap regionLookup = new HashMap();
        for (DetObj detObj : detectiv.getDetList()) {
            Shape shape;
            IdentObj identID = detObj.getIdentID();
            if (identID.isSERIES_NA() && identID.isGROUP_NA() || !this.isObjectDrillable(identID) || (shape = detObj.getShape()) == null) continue;
            IdentObj key = new IdentObj(this.getObjectID(identID.getObjectID()), identID.getSeriesID(), identID.getGroupID());
            Polygon points = this.getDestCoords(shape, vc);
            if (points.npoints == 0) continue;
            if (regionLookup.containsKey(key)) {
                assert (key.getObjectID() != 542);
                ((List)regionLookup.get(key)).add(points);
                continue;
            }
            keys.add(key);
            ArrayList<Polygon> polyArray = new ArrayList<Polygon>();
            polyArray.add(points);
            regionLookup.put(key, polyArray);
        }
        for (IdentObj key : keys) {
            int group;
            List polygons = (List)regionLookup.get(key);
            if (polygons.size() > 1) {
                Polygon poly;
                if (key.getObjectID() == 14) {
                    poly = this.convexRect(polygons);
                } else {
                    List<Point2D> pts = this.getPoints(polygons);
                    poly = PFJEngine.getPolygon(this.convexHull(pts));
                }
                polygons.clear();
                polygons.add(poly);
            }
            assert (polygons.size() == 1);
            RegionCoordinates regionCoords = this.createCoordinates((Polygon)polygons.get(0));
            assert (regionCoords != null);
            int series = this.getSeriesGroupID(key, true);
            DataContext dataContext = this.getDataContext(series, group = this.getSeriesGroupID(key, false));
            if (dataContext == null) continue;
            GraphicMapElement graphicElement = new GraphicMapElement(regionCoords, dataContext);
            map.add(graphicElement);
        }
        return map;
    }

    private List<Point2D> getPoints(List<Polygon> polygons) {
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        for (Polygon polygon : polygons) {
            for (int i = 0; i < polygon.npoints; ++i) {
                pts.add(new Point(polygon.xpoints[i], polygon.ypoints[i]));
            }
        }
        return pts;
    }

    private static final Polygon getPolygon(List<Point2D> points) {
        Polygon result = new Polygon();
        result.npoints = points.size();
        result.xpoints = new int[result.npoints];
        result.ypoints = new int[result.npoints];
        int i = 0;
        for (Point2D point2D : points) {
            result.xpoints[i] = (int)point2D.getX();
            result.ypoints[i] = (int)point2D.getY();
            ++i;
        }
        return result;
    }

    private int getSeriesGroupID(IdentObj identObj, boolean isSeries) {
        switch (identObj.getObjectID()) {
            case 13: 
            case 14: {
                if (this.pfj.isColorByGroup()) {
                    return isSeries ? identObj.getGroupID() : identObj.getSeriesID();
                }
            }
            case 514: {
                if (!this.pfj.getJGraphType().is3DType()) break;
                if (isSeries && identObj.getSeriesID() != -3) {
                    return this.pfj.getNumSeries() - identObj.getSeriesID() - 1;
                }
                if (isSeries || identObj.getGroupID() == -3) break;
                return this.pfj.getNumGroups() - identObj.getGroupID() - 1;
            }
        }
        return isSeries ? identObj.getSeriesID() : identObj.getGroupID();
    }

    private Polygon getDestCoords(Shape shape, VC vc) {
        if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            Polygon destPoly = vc.virtToDest(polygon);
            return destPoly;
        }
        PathIterator pathIterator = shape.getPathIterator(null, 10.0);
        return this.createPolygonPath(pathIterator, vc);
    }

    private int getObjectID(int objectID) {
        switch (objectID) {
            case 521: 
            case 556: 
            case 557: {
                return 521;
            }
            case 542: 
            case 543: {
                return 542;
            }
            case 13: 
            case 14: {
                return 14;
            }
        }
        return objectID;
    }

    private RegionCoordinates createCoordinates(Polygon polygon) {
        int[] coords = PFJEngine.getPolyCoords(polygon);
        return new RegionCoordinates(RegionShape.POLYGON, coords);
    }

    private Polygon createPolygonPath(PathIterator pathIterator, VC vc) {
        ArrayList<Integer> xyPts = new ArrayList<Integer>(10);
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            int segType = pathIterator.currentSegment(coords);
            switch (segType) {
                case 0: {
                    assert (xyPts.size() == 0);
                }
                case 1: {
                    xyPts.add((int)vc.virtToDestX(coords[0]));
                    xyPts.add((int)vc.virtToDestY(coords[1]));
                    break;
                }
            }
            pathIterator.next();
        }
        Polygon result = new Polygon();
        for (int i = 0; i < xyPts.size(); i += 2) {
            result.addPoint((Integer)xyPts.get(i), (Integer)xyPts.get(i + 1));
        }
        return result;
    }

    private DataContext getDataContext(int series, int group) {
        if (this.pfj.isChartHistogram()) {
            return null;
        }
        MeasureValuesContext[] measureValuesContexts = this.dataEngine.getMeasureValuesContexts(series, group);
        DimensionLabelsContext[] dimensionLabelsContexts = this.dataEngine.getDimensionLabelsContexts(series, group);
        int[] axisIndexes = this.dataEngine.getAxisIndexes(series, group);
        return new DataContext(measureValuesContexts, dimensionLabelsContexts, axisIndexes);
    }

    private boolean isObjectDrillable(IdentObj identID) {
        int objID = identID.getObjectID();
        switch (objID) {
            case 14: 
            case 503: 
            case 514: 
            case 521: 
            case 539: 
            case 540: 
            case 542: 
            case 547: 
            case 556: 
            case 557: 
            case 821: 
            case 823: 
            case 1005: {
                return true;
            }
            case 518: {
                return true;
            }
            case 504: {
                return identID.getMiscID() != 1;
            }
            case 783: 
            case 784: {
                return true;
            }
            case 2505: {
                return true;
            }
        }
        return false;
    }

    private static int[] getPolyCoords(Polygon bounds) {
        assert (bounds.npoints > 0);
        int[] coords = new int[bounds.npoints * 2];
        for (int i = 0; i < bounds.npoints; ++i) {
            coords[i * 2] = bounds.xpoints[i];
            coords[i * 2 + 1] = bounds.ypoints[i];
        }
        return coords;
    }

    private Polygon convexRect(List<Polygon> polygons) {
        assert (polygons.size() > 0);
        Area area = new Area();
        for (Polygon polygon : polygons) {
            area.add(new Area(polygon));
        }
        Rectangle bounds = area.getBounds();
        Polygon result = new Polygon();
        int right = bounds.x + bounds.width;
        int bottom = bounds.y + bounds.height;
        result.addPoint(bounds.x, bounds.y);
        result.addPoint(bounds.x, bottom);
        result.addPoint(right, bottom);
        result.addPoint(right, bounds.y);
        return result;
    }

    private List<Point2D> convexHull(List<Point2D> pts) {
        if (pts.size() <= 3) {
            return pts;
        }
        Point2D minPt = pts.get(0);
        for (int i = 1; i < pts.size(); ++i) {
            Point2D pt = pts.get(i);
            if (pt.getY() > minPt.getY() || !(pt.getY() < minPt.getY()) && !(pt.getX() < minPt.getX())) continue;
            minPt = pt;
        }
        Collections.sort(pts, new TangentSort(minPt));
        Stack<Point2D> result = new Stack<Point2D>();
        result.push(pts.get(0));
        result.push(pts.get(1));
        result.push(pts.get(2));
        for (int i = 3; i < pts.size(); ++i) {
            Point2D currPt = pts.get(i);
            while (result.size() > 2 && this.crossProduct((Point2D)result.get(result.size() - 2), result.peek(), currPt) <= 0) {
                result.pop();
            }
            result.push(currPt);
        }
        return result;
    }

    private int crossProduct(Point2D p1, Point2D p2, Point2D p3) {
        return (int)((p2.getX() - p1.getX()) * (p3.getY() - p1.getY()) - (p3.getX() - p1.getX()) * (p2.getY() - p1.getY()));
    }

    public int getWidthDC() {
        return ((VisuInteger)this.cvom.getProperty("root", "width")).intValue();
    }

    public int getWidthTwips() {
        return ((VisuInteger)this.cvom.getProperty("root", "twipwidth")).intValue();
    }

    public int getHeidthDC() {
        return ((VisuInteger)this.cvom.getProperty("root", "height")).intValue();
    }

    public int getHeightTwips() {
        return ((VisuInteger)this.cvom.getProperty("root", "twipheight")).intValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TangentSort
    implements Comparator<Point2D> {
        private Point2D pivot;

        public TangentSort(Point2D minPt) {
            this.pivot = minPt;
        }

        @Override
        public int compare(Point2D pt0, Point2D pt1) {
            int deltaX0 = (int)(pt0.getX() - this.pivot.getX());
            int deltaY0 = (int)(pt0.getY() - this.pivot.getY());
            int deltaX1 = (int)(pt1.getX() - this.pivot.getX());
            int deltaY1 = (int)(pt1.getY() - this.pivot.getY());
            assert (deltaY0 >= 0);
            assert (deltaY1 >= 0);
            if (deltaY0 == 0) {
                if (deltaY1 == 0) {
                    return deltaX0 - deltaX1;
                }
                return -1;
            }
            if (deltaY1 == 0) {
                return 1;
            }
            return deltaX1 * deltaY0 - deltaX0 * deltaY1;
        }
    }
}

