/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import java.util.ArrayList;

public abstract class DataHandler {
    private DataContainer dataContainer_;

    protected void setDataContainer(DataContainer dc) {
        this.dataContainer_ = dc;
    }

    DataContainer getDataContainer() {
        return this.dataContainer_;
    }

    private static DataRange getWindowRange(GraphicInstance gi, int aaIndex) {
        if (gi.getWindowManager().checkDataWindow() != null) {
            return gi.getWindowManager().checkDataWindow().getDataRangeByAxis()[aaIndex];
        }
        return null;
    }

    public static IDimensionLabelsIterator getDimensionLabelsCallBack(GraphicInstance gi, int iDatasetIndex, DataContainer dc) {
        DimensionLabels dl = (DimensionLabels)dc;
        int aaIndex = gi.getDataDescriptor().getDatasetDescriptor().getAxisIndex(dl);
        int dlIndex = gi.getDataDescriptor().getDatasetDescriptor().getAxisList()[aaIndex].getDimensionLabelsIndex(dl);
        return gi.getDataAdapter().getDataset().getLabelsIterator(aaIndex, dlIndex, DataHandler.getWindowRange(gi, aaIndex));
    }

    public static String[] getLabels(IDimensionLabelsIterator labelsIterator, String prefix) {
        if (labelsIterator == null) {
            return null;
        }
        labelsIterator.reset();
        ArrayList<String> tempLabels = new ArrayList<String>();
        Recurser recurser = new Recurser();
        recurser.recurse(labelsIterator, 0, "", tempLabels, prefix);
        return tempLabels.toArray(new String[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Recurser {
        private static final String DIM_SEPARATOR = " / ";
        private static final String PREFIX_SEPARATOR = " - ";

        private Recurser() {
        }

        public void recurse(IDimensionLabelsIterator iter, int dimIndex, String fatherLabel, ArrayList<String> tempLabels, String prefix) {
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                IMember colMember = iter.next();
                IDimensionLabelsIterator nextDimIterator = colMember.getNextStackedDimensionIterator();
                if (nextDimIterator == null) {
                    StringBuffer valBuffer = new StringBuffer();
                    if (prefix.length() != 0) {
                        valBuffer.append(prefix).append(PREFIX_SEPARATOR);
                    }
                    if (fatherLabel.length() != 0) {
                        valBuffer.append(fatherLabel).append(DIM_SEPARATOR).append(colMember.getValue());
                    } else {
                        valBuffer.append(colMember.getValue());
                    }
                    tempLabels.add(valBuffer.toString());
                    continue;
                }
                String newFatherLabel = fatherLabel;
                newFatherLabel = fatherLabel.length() != 0 ? newFatherLabel + DIM_SEPARATOR + (String)colMember.getValue() : (String)colMember.getValue();
                this.recurse(nextDimIterator, colMember.getDimensionIndex(), newFatherLabel, tempLabels, prefix);
            }
        }
    }
}

