/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.DataRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.filemanagement.RawData;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExtendedDataOutputStream
extends DataOutputStream
implements ExtendedDataOutput {
    public ExtendedDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeChar(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeChar(this, n, bl);
    }

    public void writeInt(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeInt(this, n, bl);
    }

    public void writeLong(long l, boolean bl) throws IOException {
        DataRandomAccessStorage.writeLong(this, l, bl);
    }

    public void writeLongUTF(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            this.writeInt(0);
            return;
        }
        int n2 = UTF8Codec.size(string);
        this.writeInt(n2);
        byte[] byArray = new byte[n2];
        UTF8Codec.encode(string, byArray, 0);
        this.write(byArray, 0, n2);
    }

    public void writeShort(int n, boolean bl) throws IOException {
        DataRandomAccessStorage.writeShort(this, n, bl);
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            this.writeInt(0);
            return;
        }
        this.writeInt(n);
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            RawData.charToData(string.charAt(i), byArray, i * 2);
        }
        this.write(byArray, 0, n * 2);
    }
}

