/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.spi;

import com.businessobjects.foundation.logging.spi.BootstrapLogger;
import com.businessobjects.foundation.logging.spi.ILoggingProvider;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public abstract class ConfigurableLoggingProvider
implements ILoggingProvider {
    protected abstract void configure(URL var1);

    protected void configureResources(String resourceName) {
        BootstrapLogger.debug("Configuring with all resources named " + resourceName + ".");
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException se1) {
            // empty catch block
        }
        if (cl == null) {
            try {
                cl = this.getClass().getClassLoader();
                BootstrapLogger.debug("Locating resources using the class context classloader.");
            }
            catch (SecurityException se) {
                try {
                    cl = ClassLoader.getSystemClassLoader();
                    BootstrapLogger.debug("Locating resources using the system classloader.");
                }
                catch (SecurityException se2) {
                    BootstrapLogger.warn("Unable to access any class loader; skipping configuration.");
                    return;
                }
            }
        } else {
            BootstrapLogger.debug("Locating resources using the thread context classloader.");
        }
        Enumeration<URL> e = null;
        try {
            e = cl.getResources(resourceName);
        }
        catch (IOException ioe) {
            BootstrapLogger.error("IOException occured while getting resources from the classloader.", ioe);
            return;
        }
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            BootstrapLogger.debug("Configuring from " + url + ".");
            this.configure(url);
        }
    }
}

