/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.proxy.remoteagent;

import com.crystaldecisions12.client.helper.SDKResourceManager;
import com.crystaldecisions12.proxy.remoteagent.ResultCode;
import com.crystaldecisions12.proxy.remoteagent.ResultInfo;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKEnterpriseLogonException;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKLogonException;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKServerError;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKServerException;
import java.util.Locale;
import java.util.MissingResourceException;

public final class ExceptionHelper {
    public static String loadResultCodeMsg(int n2, Locale locale) throws MissingResourceException {
        String string = null;
        switch (n2) {
            case -2147217392: {
                string = SDKResourceManager.getString("Error_FileExists", locale);
                break;
            }
            case 266247: {
                string = SDKResourceManager.getString("Error_ExceedLicenseLimit", locale);
                break;
            }
            case 266246: {
                string = SDKResourceManager.getString("Error_NewerVersion", locale);
                break;
            }
            case 266245: {
                string = SDKResourceManager.getString("Error_OlderVersion", locale);
                break;
            }
            case -2147217393: {
                string = SDKResourceManager.getString("Error_LogOnFailed", locale);
                break;
            }
            case 266242: {
                string = SDKResourceManager.getString("Error_LinkWarning", locale);
                break;
            }
            case 266241: {
                string = SDKResourceManager.getString("Error_Warning", locale);
                break;
            }
            case 0: {
                string = SDKResourceManager.getString("Error_Succeeded", locale);
                break;
            }
            case -2147467259: {
                string = SDKResourceManager.getString("Error_Failed", locale);
                break;
            }
            case -2147217407: {
                string = SDKResourceManager.getString("Error_ServerUnavailable", locale);
                break;
            }
            case -2147217406: {
                string = SDKResourceManager.getString("Error_Cancelled", locale);
                break;
            }
            case -2147217405: {
                string = SDKResourceManager.getString("Error_NullResultInfo", locale);
                break;
            }
            case -2147217404: {
                string = SDKResourceManager.getString("Error_ServerOutOfMemory", locale);
                break;
            }
            case -2147217403: {
                string = SDKResourceManager.getString("Error_ServerConfigError", locale);
                break;
            }
            case -2147217402: {
                string = SDKResourceManager.getString("Error_DirectoryItemLogOnFailed", locale);
                break;
            }
            case -2147217391: {
                string = SDKResourceManager.getString("Error_DirectoryItemLogOnFailed", locale);
                break;
            }
            case -2147217401: {
                string = SDKResourceManager.getString("Error_AgentTimeOut", locale);
                break;
            }
            case -2147217400: {
                string = SDKResourceManager.getString("Error_VersionTooNew", locale);
                break;
            }
            case -2147217399: {
                string = SDKResourceManager.getString("Error_VersionTooOld", locale);
                break;
            }
            case -2147217398: {
                string = SDKResourceManager.getString("Error_InvalidChartType", locale);
                break;
            }
            case -2147217397: {
                string = SDKResourceManager.getString("Error_VerifyLogonFailed", locale);
                break;
            }
            case -2147217395: {
                string = SDKResourceManager.getString("Error_ServerProgrammingError", locale);
                break;
            }
            case -2147217394: {
                string = SDKResourceManager.getString("Error_MissingParameterValueError", locale);
                break;
            }
            case -2147217386: {
                string = SDKResourceManager.getString("Error_ExceedAgentLimit", locale);
                break;
            }
            case -2147352565: {
                string = SDKResourceManager.getString("Error_InvalidIndex", locale);
                break;
            }
            case -2147467231: {
                string = SDKResourceManager.getString("Error_NotSupported", locale);
                break;
            }
            case -2147217385: {
                string = SDKResourceManager.getString("Error_RequestTimeout", locale);
                break;
            }
            case -2147217384: {
                string = SDKResourceManager.getString("Error_ExceedLicenceLimit", locale);
                break;
            }
            case -2147217383: {
                string = SDKResourceManager.getString("Error_FormulaParseError", locale);
                break;
            }
            case -2147217380: {
                string = SDKResourceManager.getString("Error_OldVersionReport", locale);
                break;
            }
            default: {
                if (ResultCode.FAILED(n2)) {
                    string = SDKResourceManager.getString("Error_Failed", locale);
                    break;
                }
                if (!ResultCode.SUCCEEDED(n2)) break;
                string = SDKResourceManager.getString("Error_Warning", locale);
            }
        }
        return string;
    }

    public static void throwResultInfoException(ResultInfo resultInfo, Locale locale) throws ReportSDKException {
        int n2 = resultInfo.getResultCode();
        ReportSDKException reportSDKException = resultInfo.getErrorException();
        if (reportSDKException != null) {
            throw reportSDKException;
        }
        try {
            String string = resultInfo.getErrorMsg(true);
            if (string.length() == 0) {
                string = ExceptionHelper.loadResultCodeMsg(n2, locale);
            }
            switch (n2) {
                case -2147217402: 
                case -2147217393: 
                case -2147217391: {
                    ReportSDKLogonException.throwReportSDKLogonException(n2, string);
                    break;
                }
                case -2147217397: {
                    ReportSDKEnterpriseLogonException.throwReportSDKEnterpriseLogonException(n2, string);
                    break;
                }
                default: {
                    ReportSDKServerException.throwReportSDKServerException(n2, string);
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n2 = ReportSDKServerError.failed.value();
            String string = resultInfo.getErrorMsg();
            ReportSDKServerException.throwReportSDKServerException(n2, string);
        }
    }
}

