/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.prompting.exceptions.PromptingException;
import com.businessobjects.prompting.internal.PropertyBag;
import com.businessobjects.prompting.objectmodel.common.ILOVNetwork;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.LOVNetwork;
import com.businessobjects.prompting.objectmodel.runtime.PromptingUnit;
import com.businessobjects.reports.crprompting.CRPromptingResources;
import com.businessobjects.reports.crprompting.IDBLogonPromptingUnit;
import com.businessobjects.reports.crprompting.Prompt;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBLogonPromptingUnit
extends PromptingUnit
implements IDBLogonPromptingUnit {
    private static final String XML_DBLOGONUNIT_BAG = "dbLogonUnitBag";
    PropertyBag<String, UUID> dbPromptBag = new PropertyBag();

    public static ILOVNetwork createDBLogonLOVNetwork(String connectionName, Locale locale) {
        LOVNetwork network;
        block2: {
            network = new LOVNetwork();
            network.setName(connectionName);
            Prompt server = new Prompt();
            server.setName(CRPromptingResources.loadString(locale, "server"));
            server.setAllowCustomValue(true);
            server.setValueRequired(true);
            server.setReadOnly(true);
            server.setMetadataProperty("PromptTypeKey", IDBLogonPromptingUnit.DBLogonPromptType.Server.name());
            Prompt database = new Prompt();
            database.setName(CRPromptingResources.loadString(locale, "database"));
            database.setAllowCustomValue(true);
            database.setValueRequired(true);
            database.setReadOnly(true);
            database.setMetadataProperty("PromptTypeKey", IDBLogonPromptingUnit.DBLogonPromptType.Database.name());
            Prompt userId = new Prompt();
            userId.setName(CRPromptingResources.loadString(locale, "userId"));
            userId.setAllowCustomValue(true);
            userId.setValueRequired(true);
            userId.setMetadataProperty("PromptTypeKey", IDBLogonPromptingUnit.DBLogonPromptType.UserId.name());
            Prompt pwd = new Prompt();
            pwd.setName(CRPromptingResources.loadString(locale, "password"));
            pwd.setAllowCustomValue(true);
            pwd.setValueRequired(true);
            pwd.setIsPassword(true);
            pwd.setMetadataProperty("PromptTypeKey", IDBLogonPromptingUnit.DBLogonPromptType.Password.name());
            ArrayList<IPrompt> dbprompts = new ArrayList<IPrompt>();
            dbprompts.add(server);
            dbprompts.add(database);
            dbprompts.add(userId);
            dbprompts.add(pwd);
            try {
                network.addPrompts(dbprompts);
            }
            catch (PromptingException.InvalidNetworkException e10) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"DB LOVNetworks don't have cycles and are never invalid");
            }
        }
        return network;
    }

    public DBLogonPromptingUnit() {
    }

    @Override
    public UUID getDBPromptUUID(IDBLogonPromptingUnit.DBLogonPromptType type) {
        return (UUID)this.dbPromptBag.get(type.name());
    }

    public DBLogonPromptingUnit(String connectionName, ILOVNetwork network) {
        super(connectionName, connectionName, network.getUUID());
        for (IPrompt prompt : network.getAllPrompts()) {
            this.dbPromptBag.put(prompt.getMetadataProperty("PromptTypeKey"), prompt.getUUID());
            this.addRequiredPromptID(prompt.getUUID());
        }
    }

    @Override
    public Object createMember(String eleName, Attributes attrs, XMLSerializationContext ctxt, Map<Object, Object> objState, boolean[] bLoaded) {
        Object newObject = super.createMember(eleName, attrs, ctxt, objState, bLoaded);
        if (eleName.equals(XML_DBLOGONUNIT_BAG)) {
            this.dbPromptBag = (PropertyBag)newObject;
        }
        return newObject;
    }

    @Override
    public void saveContents(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        super.saveContents(writer, ctxt);
        writer.writeObjectElement(this.dbPromptBag, XML_DBLOGONUNIT_BAG, ctxt);
    }
}

