/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleNClob;
import oracle.sql.CLOB;

public class NCLOB
extends CLOB
implements OracleNClob {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected NCLOB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB(OracleConnection conn) throws SQLException {
        block12: {
            this(conn, null);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    NCLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NCLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        block12: {
            super(conn, lob_descriptor, (short)2);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    NCLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob_descriptor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NCLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    public NCLOB(CLOB clob) throws SQLException {
        this(clob.getPhysicalConnection(), clob.getBytes());
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.NCLOB"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

