/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;

public class HostnameNamingAdapter
implements NamingAdapterInterface {
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_PROTOCOL = "TCP";
    String osuser;
    String programName;

    private HostnameNamingAdapter() {
    }

    public HostnameNamingAdapter(String _osuser, String _programName) {
        this.osuser = _osuser;
        this.programName = _programName;
    }

    public String resolve(String TNSdesc) throws NetException {
        String connStr;
        int colonOff = 0;
        int sSlashOff = 0;
        int hostOff = 0;
        int rightSqurBrktOff = 0;
        boolean secondFormat = false;
        if (TNSdesc.startsWith("//")) {
            TNSdesc = TNSdesc.substring(2);
        }
        if (TNSdesc.charAt(0) == '[') {
            secondFormat = true;
            rightSqurBrktOff = TNSdesc.indexOf(93);
            if (rightSqurBrktOff != -1) {
                colonOff = TNSdesc.indexOf(58, rightSqurBrktOff);
            }
            if (rightSqurBrktOff == -1 || colonOff != -1 && colonOff != rightSqurBrktOff + 1) {
                throw new NetException(117);
            }
            hostOff = 1;
            sSlashOff = TNSdesc.indexOf(47, rightSqurBrktOff);
        } else {
            hostOff = 0;
            colonOff = TNSdesc.indexOf(58);
            sSlashOff = TNSdesc.indexOf(47, hostOff);
        }
        if (sSlashOff != -1 && colonOff > sSlashOff || TNSdesc.endsWith("/") || TNSdesc.endsWith(":")) {
            throw new NetException(117);
        }
        try {
            String host = secondFormat ? TNSdesc.substring(hostOff, rightSqurBrktOff) : (colonOff != -1 ? TNSdesc.substring(hostOff, colonOff) : (sSlashOff != -1 ? TNSdesc.substring(hostOff, sSlashOff) : TNSdesc.substring(hostOff)));
            int port = colonOff != -1 ? (sSlashOff != -1 ? Integer.parseInt(TNSdesc.substring(colonOff + 1, sSlashOff)) : Integer.parseInt(TNSdesc.substring(colonOff + 1))) : 1521;
            String service_name = sSlashOff != -1 ? TNSdesc.substring(sSlashOff + 1) : "";
            InetAddress[] inetAdd = InetAddress.getAllByName(host);
            String addr = "";
            for (int i2 = 0; i2 < inetAdd.length; ++i2) {
                host = inetAdd[i2].getHostAddress();
                addr = addr + "(ADDRESS=" + "(PROTOCOL=" + DEFAULT_PROTOCOL + ")(HOST=" + host + ")(PORT=" + port + "))";
            }
            String connData = "(DESCRIPTION=(CONNECT_DATA=(SERVICE_NAME=" + service_name + ")(CID=(PROGRAM=" + this.programName + ")(HOST=__jdbc__)(USER=" + this.osuser + ")))";
            connStr = connData + addr + ")";
        }
        catch (NumberFormatException nfe) {
            throw new NetException(116);
        }
        catch (UnknownHostException uhe) {
            throw new NetException(118);
        }
        return connStr;
    }
}

