/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class CustomSSLSocketFactory {
    static final boolean DEBUG = false;
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    public static SSLSocketFactory defSSLFactory;
    public static String defPropString;
    public static boolean initDefFactory;

    private CustomSSLSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(Properties sslSocketProperties) throws IOException {
        String keyStoreType = null;
        String keyStorePassword = null;
        String keyStore = null;
        String trustStoreType = null;
        String trustStorePassword = null;
        String trustStore = null;
        String keyManagerFacAlgo = null;
        String trustManagerFacAlgo = null;
        String propConcatenation = null;
        String walletDirectory = null;
        String walletLocation = null;
        String walletPassword = null;
        SSLSocketFactory result = null;
        walletLocation = (String)sslSocketProperties.get(5);
        walletPassword = (String)sslSocketProperties.get(16);
        if (walletLocation == null) {
            keyStore = (String)sslSocketProperties.get(8);
            if (keyStore != null) {
                keyStoreType = (String)sslSocketProperties.get(9);
                if (keyStoreType == null) {
                    keyStoreType = KeyStore.getDefaultType();
                }
                if ((keyStorePassword = (String)sslSocketProperties.get(10)) == null) {
                    keyStorePassword = "";
                }
                if ((keyManagerFacAlgo = (String)sslSocketProperties.get(14)) == null) {
                    keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
                }
                if (keyManagerFacAlgo == null) {
                    keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
                }
            }
            if ((trustStore = (String)sslSocketProperties.get(11)) != null) {
                trustStoreType = (String)sslSocketProperties.get(12);
                if (trustStoreType == null) {
                    trustStoreType = KeyStore.getDefaultType();
                }
                if ((trustStorePassword = (String)sslSocketProperties.get(13)) == null) {
                    trustStorePassword = "";
                }
                if ((trustManagerFacAlgo = (String)sslSocketProperties.get(15)) == null) {
                    trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
                }
                if (trustManagerFacAlgo == null) {
                    trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
                }
            }
            propConcatenation = keyStore + "#" + keyStoreType + "#" + keyStorePassword + "#" + trustStore + "#" + trustStoreType + "#" + trustStorePassword + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
        } else {
            boolean walletFileSpecified = false;
            if (walletLocation.startsWith("(")) {
                walletDirectory = CustomSSLSocketFactory.processWalletLocation(walletLocation);
            } else if (walletLocation.startsWith("file:")) {
                walletDirectory = walletLocation.substring("file:".length());
                File walletFile = new File(walletDirectory);
                if (!walletFile.exists()) {
                    throw new NetException(407, "Couldn't find file at " + walletDirectory);
                }
                if (!walletFile.isDirectory()) {
                    walletFileSpecified = true;
                }
            } else {
                throw new NetException(412, "Location: " + walletLocation);
            }
            if (walletPassword == null) {
                keyStore = !walletFileSpecified ? walletDirectory + System.getProperty("file.separator") + DEFAULT_SSO_WALLET_FILE_NAME : walletDirectory;
                keyStoreType = SSO_WALLET_TYPE;
                keyStorePassword = "";
                keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
                trustStore = keyStore;
                trustStoreType = SSO_WALLET_TYPE;
                trustStorePassword = "";
                trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            } else {
                keyStore = !walletFileSpecified ? walletDirectory + System.getProperty("file.separator") + DEFAULT_PKCS12_WALLET_FILE_NAME : walletDirectory;
                keyStoreType = PKCS12_WALLET_TYPE;
                keyStorePassword = walletPassword;
                keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
                trustStore = keyStore;
                trustStoreType = PKCS12_WALLET_TYPE;
                trustStorePassword = walletPassword;
                trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            }
            propConcatenation = walletLocation + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
        }
        if (propConcatenation.equals(defPropString)) {
            if (initDefFactory) {
                return defSSLFactory;
            }
            Class<CustomSSLSocketFactory> walletFileSpecified = CustomSSLSocketFactory.class;
            synchronized (CustomSSLSocketFactory.class) {
                if (!initDefFactory) {
                    try {
                        KeyManager[] keyManagerArray = null;
                        TrustManager[] trustManagerArray = null;
                        if (keyStore != null) {
                            keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(keyStore, keyStorePassword, keyStoreType, keyManagerFacAlgo);
                        }
                        if (trustStore != null) {
                            trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(trustStore, trustStorePassword, trustStoreType, trustManagerFacAlgo);
                        }
                        SSLContext l_context = SSLContext.getInstance("SSL");
                        l_context.init(keyManagerArray, trustManagerArray, null);
                        defSSLFactory = l_context.getSocketFactory();
                        if (defSSLFactory != null) {
                            initDefFactory = true;
                        }
                    }
                    catch (Exception ex) {
                        throw (NetException)new NetException(410).initCause(ex);
                    }
                }
                // ** MonitorExit[walletFileSpecified] (shouldn't be in output)
                return defSSLFactory;
            }
        }
        try {
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (keyStore != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(keyStore, keyStorePassword, keyStoreType, keyManagerFacAlgo);
            }
            if (trustStore != null) {
                trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(trustStore, trustStorePassword, trustStoreType, trustManagerFacAlgo);
            }
            SSLContext l_context = SSLContext.getInstance("SSL");
            l_context.init(keyManagerArray, trustManagerArray, null);
            result = l_context.getSocketFactory();
            return result;
        }
        catch (Exception ex) {
            throw (NetException)new NetException(410).initCause(ex);
        }
    }

    public static KeyManager[] getKeyManagerArray(String keyStore, String keyStorePassword, String keyStoreType, String keyManagerFacAlgo) throws IOException {
        KeyManager[] keyManagerArray;
        block4: {
            FileInputStream inputKeyStream = null;
            try {
                KeyStore instKeyStore = KeyStore.getInstance(keyStoreType);
                inputKeyStream = new FileInputStream(keyStore);
                instKeyStore.load(inputKeyStream, keyStorePassword.toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFacAlgo);
                keyManagerFactory.init(instKeyStore, keyStorePassword.toCharArray());
                keyManagerArray = keyManagerFactory.getKeyManagers();
                Object var9_9 = null;
                if (inputKeyStream == null) break block4;
            }
            catch (Exception ex) {
                try {
                    throw (NetException)new NetException(408).initCause(ex);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var9_10 = null;
                        if (inputKeyStream == null) break block5;
                        inputKeyStream.close();
                    }
                    throw throwable;
                }
            }
            inputKeyStream.close();
        }
        return keyManagerArray;
    }

    public static TrustManager[] getTrustManagerArray(String trustStore, String trustStorePassword, String trustStoreType, String trustManagerFacAlgo) throws IOException {
        TrustManager[] trustManagerArray;
        block4: {
            FileInputStream inputTrustStream = null;
            try {
                KeyStore instTrustStore = KeyStore.getInstance(trustStoreType);
                inputTrustStream = new FileInputStream(trustStore);
                instTrustStore.load(inputTrustStream, trustStorePassword.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFacAlgo);
                trustManagerFactory.init(instTrustStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
                Object var9_9 = null;
                if (inputTrustStream == null) break block4;
            }
            catch (Exception ex) {
                try {
                    throw (NetException)new NetException(409).initCause(ex);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var9_10 = null;
                        if (inputTrustStream == null) break block5;
                        inputTrustStream.close();
                    }
                    throw throwable;
                }
            }
            inputTrustStream.close();
        }
        return trustManagerArray;
    }

    public static String processWalletLocation(String walletLocation) throws NetException {
        String method = null;
        try {
            NVNavigator nav = new NVNavigator();
            NVPair nvpWallet = new NVFactory().createNVPair(walletLocation);
            NVPair nvpMethod = nav.findNVPair(nvpWallet, "METHOD");
            NVPair nvpMethodData = nav.findNVPair(nvpWallet, "METHOD_DATA");
            NVPair nvpDirectory = nav.findNVPair(nvpMethodData, "DIRECTORY");
            method = nvpMethod.getAtom();
            if (method.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String directoryLoc = nvpDirectory.getAtom();
                return directoryLoc;
            }
            throw new NetException(412, method);
        }
        catch (Exception ex) {
            throw (NetException)new NetException(407).initCause(ex);
        }
    }

    public static String getDefaultPropertiesString() {
        String defaultPropString = null;
        String walletLocation = null;
        Object walletDirectory = null;
        String keyManagerFacAlgo = null;
        String trustManagerFacAlgo = null;
        walletLocation = System.getProperty("oracle.net.wallet_location");
        defaultPropString = walletLocation != null ? walletLocation : System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
        if (keyManagerFacAlgo == null) {
            keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (trustManagerFacAlgo == null) {
            trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        return defaultPropString + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
    }

    static {
        defPropString = CustomSSLSocketFactory.getDefaultPropertiesString();
    }
}

