/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final long serialVersionUID = -3565405169674271176L;
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSetReader() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(RowSetInternal rowsetInternal) throws SQLException {
        Connection connection;
        try {
            Connection rowsetConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowsetInternal));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Connection con = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(RowSetInternal)," + "con=" + con);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((rowsetConnection = rowsetInternal.getConnection()) != null && !rowsetConnection.isClosed()) {
                con = rowsetConnection;
            } else if (((RowSet)((Object)rowsetInternal)).getDataSourceName() != null) {
                try {
                    InitialContext initialcontext = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(), initialcontext=" + initialcontext);
                            Object var7_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    try {
                        Properties props = System.getProperties();
                        initialcontext = new InitialContext(props);
                    }
                    catch (SecurityException ea) {
                        // empty catch block
                    }
                    if (initialcontext == null) {
                        initialcontext = new InitialContext();
                    }
                    DataSource datasource = (DataSource)initialcontext.lookup(((RowSet)((Object)rowsetInternal)).getDataSourceName());
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(),datasource=" + datasource);
                            Object var9_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    String userName = ((RowSet)((Object)rowsetInternal)).getUsername();
                    String password = ((RowSet)((Object)rowsetInternal)).getPassword();
                    if (userName == null && password == null) {
                        con = datasource.getConnection();
                    }
                    con = datasource.getConnection(userName, password);
                }
                catch (NamingException ea) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 300 + ea.getMessage());
                            Object var11_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_22 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, ea.getMessage());
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else if (((RowSet)((Object)rowsetInternal)).getUrl() != null) {
                if (!driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    driverManagerInitialized = true;
                }
                String url = ((RowSet)((Object)rowsetInternal)).getUrl();
                String userName = ((RowSet)((Object)rowsetInternal)).getUsername();
                String password = ((RowSet)((Object)rowsetInternal)).getPassword();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(): url = " + url + ", userName = " + userName + ", password = " + password);
                        Object var13_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (url.equals("") || userName.equals("") || password.equals("")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                            Object var15_27 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_28 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                con = DriverManager.getConnection(url, userName, password);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + con);
                    Object var17_30 = null;
                }
                catch (Throwable throwable) {
                    Object var17_31 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            connection = con;
            Object var19_33 = null;
        }
        catch (Throwable throwable) {
            Object var19_34 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var21_37 = null;
                }
                catch (Throwable throwable2) {
                    Object var21_38 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_35 = null;
            }
            catch (Throwable throwable) {
                Object var21_36 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParams(Object[] paramObject, PreparedStatement preparedStatement) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(paramObject) + ", " + OracleLog.argument(preparedStatement));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            block33: for (int j2 = 0; j2 < paramObject.length; ++j2) {
                SQLException __ex__;
                int i2 = 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var6_11;
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.setParams(Object[], PreparedStatement)" + ", inside for-loop, i=" + i2);
                        var6_11 = null;
                    }
                    catch (Throwable throwable) {
                        var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (paramObject[j2] instanceof byte[]) {
                    preparedStatement.setObject(j2 + 1, paramObject[j2]);
                    continue;
                }
                try {
                    i2 = Array.getLength(paramObject[j2]);
                }
                catch (IllegalArgumentException ex) {
                    preparedStatement.setObject(j2 + 1, paramObject[j2]);
                    continue;
                }
                Object[] tmpParmObj = (Object[])paramObject[j2];
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var8_12;
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.setParams(Object[], PreparedStatement)" + ", inside for-loop, Object tmpParmObj=" + tmpParmObj);
                        var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        var8_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (i2 == 2) {
                    if (tmpParmObj[0] == null) {
                        preparedStatement.setNull(j2 + 1, (Integer)tmpParmObj[1]);
                        continue;
                    }
                    if (tmpParmObj[0] instanceof Date) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement.setDate(j2 + 1, (Date)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                Object var10_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_15 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (tmpParmObj[0] instanceof Time) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement.setTime(j2 + 1, (Time)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                Object var12_17 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_18 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (tmpParmObj[0] instanceof Timestamp) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement.setTimestamp(j2 + 1, (Timestamp)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                Object var14_20 = null;
                            }
                            catch (Throwable throwable) {
                                Object var14_21 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (!(tmpParmObj[1] instanceof Integer)) continue;
                    preparedStatement.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1]);
                    continue;
                }
                if (i2 != 3) continue;
                if (tmpParmObj[0] == null) {
                    preparedStatement.setNull(j2 + 1, (Integer)tmpParmObj[1], (String)tmpParmObj[2]);
                    continue;
                }
                if (tmpParmObj[0] instanceof Reader) {
                    switch ((Integer)tmpParmObj[2]) {
                        case 4: {
                            preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block33;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                    Object var16_23 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var16_24 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                }
                if (tmpParmObj[0] instanceof InputStream) {
                    switch ((Integer)tmpParmObj[2]) {
                        case 1: {
                            preparedStatement.setUnicodeStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block33;
                        }
                        case 2: {
                            preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block33;
                        }
                        case 3: {
                            preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block33;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                    Object var18_26 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var18_27 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                }
                if (tmpParmObj[1] instanceof Integer && tmpParmObj[2] instanceof Integer) {
                    preparedStatement.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1], (int)((Integer)tmpParmObj[2]));
                    continue;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                        Object var20_29 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var22_32 = null;
        }
        catch (Throwable throwable) {
            Object var22_33 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var24_36 = null;
                }
                catch (Throwable throwable2) {
                    Object var24_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var24_34 = null;
            }
            catch (Throwable throwable) {
                Object var24_35 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readData(RowSetInternal rowsetInternal) throws SQLException {
        try {
            Connection connection;
            OracleCachedRowSet rowset;
            block29: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowsetInternal));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                rowset = (OracleCachedRowSet)rowsetInternal;
                connection = this.getConnection(rowsetInternal);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.readData(), connection=" + connection);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (connection == null || rowset.getCommand() == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 342);
                            Object var7_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 342);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                try {
                    connection.setTransactionIsolation(rowset.getTransactionIsolation());
                }
                catch (Exception ex) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block29;
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.readData(), setTransactionIsolation() throws exception: " + ex);
                        Object var9_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            PreparedStatement preparedStatement = connection.prepareStatement(rowset.getCommand(), rowset.getType(), rowset.getConcurrency());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.readData(), preparedStatement=" + preparedStatement);
                    Object var11_20 = null;
                }
                catch (Throwable throwable) {
                    Object var11_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.setParams(rowsetInternal.getParams(), preparedStatement);
            try {
                preparedStatement.setMaxRows(rowset.getMaxRows());
                preparedStatement.setMaxFieldSize(rowset.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(rowset.getEscapeProcessing());
                preparedStatement.setQueryTimeout(rowset.getQueryTimeout());
            }
            catch (Exception ex) {
                // empty catch block
            }
            ResultSet resultset = preparedStatement.executeQuery();
            rowset.populate(resultset, rowset.getCurrentPage() * rowset.getPageSize());
            resultset.close();
            preparedStatement.close();
            try {
                connection.commit();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (!rowset.isConnectionStayingOpen()) {
                connection.close();
            }
            Object var13_23 = null;
        }
        catch (Throwable throwable) {
            Object var13_24 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_27 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_25 = null;
            }
            catch (Throwable throwable) {
                Object var15_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

