/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleSqlForRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    static final long serialVersionUID = -2066958142885801470L;
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag;
    private int updateRowPosition;
    private boolean updateRowFlag;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    private transient OracleSqlForRowSet osql = null;
    protected Vector rows;
    private Vector param;
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean executeCalled = false;
    private boolean driverManagerInitialized = false;
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private static final int MAX_BYTE_BUFFER_SIZE = 1024;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSet() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.insertRowFlag = false;
            this.updateRowFlag = false;
            this.presentRow = 0;
            this.previousColumnWasNull = false;
            this.param = new Vector();
            this.rows = new Vector();
            this.sqlWarning = new SQLWarning();
            try {
                this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
            }
            catch (SyncFactoryException exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 304);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 304);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.setReader(new OracleCachedRowSetReader());
            this.setWriter(new OracleCachedRowSetWriter());
            this.currentPage = 0;
            this.pageSize = 0;
            this.isPopulateDone = false;
            this.keyColumns = null;
            this.tableName = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    connection = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Connection __result__ = this.getConnectionInternal();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            connection = __result__;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Connection getConnectionInternal() throws SQLException {
        Connection connection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.connection == null || this.connection.isClosed()) {
                String userName = this.getUsername();
                String password = this.getPassword();
                if (this.getDataSourceName() != null) {
                    try {
                        InitialContext initialcontext = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getConnectionInternal(), " + "initialcontext=" + initialcontext);
                                Object var5_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_10 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        try {
                            Properties props = System.getProperties();
                            initialcontext = new InitialContext(props);
                        }
                        catch (SecurityException ea) {
                            // empty catch block
                        }
                        if (initialcontext == null) {
                            initialcontext = new InitialContext();
                        }
                        DataSource datasource = (DataSource)initialcontext.lookup(this.getDataSourceName());
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSe.getConnectionInternal(),datasource=" + datasource);
                                Object var7_16 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_17 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        if (this.username == null || password == null) {
                            this.connection = datasource.getConnection();
                        }
                        this.connection = datasource.getConnection(this.username, password);
                    }
                    catch (NamingException ea) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 300 + ea.getMessage());
                                Object var9_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_20 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, ea.getMessage());
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                } else if (this.getUrl() != null) {
                    if (!this.driverManagerInitialized) {
                        DriverManager.registerDriver(new OracleDriver());
                        this.driverManagerInitialized = true;
                    }
                    String url = this.getUrl();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getConnectionInternal(): url = " + url + ", userName = " + userName + ", password = " + password);
                            Object var11_22 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_23 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (url.equals("") || userName.equals("") || password.equals("")) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                                Object var13_25 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_26 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.connection = DriverManager.getConnection(url, userName, password);
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                            Object var15_28 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_29 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                    Object var17_31 = null;
                }
                catch (Throwable throwable) {
                    Object var17_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            connection = this.connection;
            Object var19_34 = null;
            if (!TRACE) return connection;
        }
        catch (Throwable throwable) {
            Object var19_35 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_38 = null;
            }
            catch (Throwable throwable2) {
                Object var21_39 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return connection;
        try {
            OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var21_36 = null;
        }
        catch (Throwable throwable) {
            Object var21_37 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        Statement statement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    statement = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getStatement(), " + "connenction=" + this.connection + ", " + "resultSet=" + this.resultSet);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.resultSet == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 305);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 305);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Statement __result__ = this.resultSet.getStatement();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            statement = __result__;
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetReader getReader() {
        RowSetReader rowSetReader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.reader);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rowSetReader = this.reader;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rowSetReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetWriter getWriter() {
        RowSetWriter rowSetWriter;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.writer);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rowSetWriter = this.writer;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rowSetWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(direction));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.setFetchDirection(), rowsetType=" + this.rowsetType);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.rowsetType == 1005) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 306);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 306);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            switch (direction) {
                case 1000: 
                case 1002: {
                    this.presentRow = 0;
                    break;
                }
                case 1001: {
                    if (this.rowsetType == 1003) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 307);
                                Object var9_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_15 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 307);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.presentRow = this.rowCount + 1;
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 308);
                            Object var11_17 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 308);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            super.setFetchDirection(direction);
            Object var13_20 = null;
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_22 = null;
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommand(String cmd) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cmd));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            super.setCommand(cmd);
            this.osql = cmd == null || cmd.equals("") ? null : new OracleSqlForRowSet(cmd);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReader(RowSetReader r2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(r2));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.reader = r2;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(RowSetWriter w) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(w));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.writer = w;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getColumnIndex(String columnName) throws SQLException {
        int n2;
        try {
            int columnIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (columnName == null || columnName.equals("")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + columnName);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, columnName);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            columnName = columnName.toUpperCase();
            for (columnIndex = 0; columnIndex < this.metaData.length && !columnName.equals(this.metaData[columnIndex]); ++columnIndex) {
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getColumnIndex(" + columnName + "),columnIndex=" + columnIndex + ", return " + (columnIndex + 1));
                    Object var7_12 = null;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (columnIndex >= this.metaData.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + columnName);
                        Object var9_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, columnName);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = columnIndex + 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var11_18 = null;
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var13_21 = null;
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_25 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_23 = null;
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkColumnIndex(int columnIndex) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.checkColumnIndex ( " + columnIndex + " ), readOnly = " + this.readOnly);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.readOnly) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (columnIndex < 1 || columnIndex > this.colCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + columnIndex);
                        Object var9_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + columnIndex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var11_16 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_20 = null;
            }
            catch (Throwable throwable2) {
                Object var13_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_18 = null;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isUpdated(int columnIndex) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.isUpdated ( " + columnIndex + " ), colCount=" + this.colCount);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (columnIndex < 1 || columnIndex > this.colCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + columnIndex);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + columnIndex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean __result__ = this.getCurrentRow().isColumnChanged(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var9_14 = null;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkParamIndex(int parameterIndex) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(parameterIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (parameterIndex < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 310 + "" + parameterIndex);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 310, "" + parameterIndex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void populateInit(ResultSet rs) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rs));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.resultSet = rs;
            Statement stmt = rs.getStatement();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populateInit (" + rs + "), stmt=" + stmt);
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.maxFieldSize = stmt.getMaxFieldSize();
            this.fetchSize = stmt.getFetchSize();
            this.queryTimeout = stmt.getQueryTimeout();
            this.connection = stmt.getConnection();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populateInit (" + rs + "), connection=" + this.connection);
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.transactionIsolation = this.connection.getTransactionIsolation();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populateInit (" + rs + "), connection=" + this.connection);
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.typeMap = this.connection.getTypeMap();
            DatabaseMetaData dbmd = this.connection.getMetaData();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populateInit (" + rs + "), typeMap=" + this.typeMap + ", dbmd=" + dbmd);
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.url = dbmd.getURL();
            this.username = dbmd.getUserName();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populateInit (" + rs + "),url=" + this.url + ",username=" + this.username);
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.presentRow = 0;
            Object var15_21 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_23 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized InputStream getStream(int columnIndex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[TRYBLOCK], 14[TRYBLOCK]], but top level block is 17[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Calendar getSessionCalendar(Connection conn) {
        Calendar cal;
        String localTimeZone = ((OracleConnection)conn).getSessionTimeZone();
        if (localTimeZone == null) {
            cal = Calendar.getInstance();
        } else {
            TimeZone tz = TimeZone.getDefault();
            tz.setID(localTimeZone);
            cal = Calendar.getInstance(tz);
        }
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStreamType(int type) {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = type == 2004 || type == 2005 || type == -4 || type == -1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void notifyCursorMoved() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.notifyCursorMoved(), " + "insertRowFlag= " + this.insertRowFlag + ", updateRowFlag=" + this.updateRowFlag);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.insertRowFlag) {
                this.insertRowFlag = false;
                this.insertRow.setRowUpdated(false);
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
            } else if (this.updateRowFlag) {
                try {
                    this.updateRowFlag = false;
                    int temp = this.presentRow;
                    this.presentRow = this.updateRowPosition;
                    this.getCurrentRow().setRowUpdated(false);
                    this.presentRow = temp;
                    this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            super.notifyCursorMoved();
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndFilterObject(int columnIndex, Object obj) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(obj));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleRow getCurrentRow() throws SQLException {
        OracleRow oracleRow;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int rowno = this.presentRow - 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getCurrentRow (), rowno = " + rowno + ", presentRow=" + this.presentRow + ",rowCount=" + this.rowCount);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.presentRow < 1 || this.presentRow > this.rowCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 313);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleRow __result__ = (OracleRow)this.rows.elementAt(this.presentRow - 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleRow = __result__;
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isExecuteCalled() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.executeCalled);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.executeCalled;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentPage() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentPage);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.currentPage;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isConnectionStayingOpen() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isConnectionStayingOpenForTxnControl);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.isConnectionStayingOpenForTxnControl;
            Object var6_8 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOriginal() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int rowPosition = 1;
            do {
                boolean _isRowDeleted;
                if (_isRowDeleted = this.setOriginalRowInternal(rowPosition)) continue;
                ++rowPosition;
            } while (rowPosition <= this.rowCount);
            this.notifyRowSetChanged();
            this.presentRow = 0;
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setOriginalRowInternal(int rowPosition) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowPosition));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (rowPosition < 1 || rowPosition > this.rowCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 313);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean _rowDeleted = false;
            OracleRow row = (OracleRow)this.rows.elementAt(rowPosition - 1);
            if (row.isRowDeleted()) {
                this.rows.remove(rowPosition - 1);
                --this.rowCount;
                _rowDeleted = true;
            } else {
                if (row.isRowInserted()) {
                    row.setInsertedFlag(false);
                }
                if (row.isRowUpdated()) {
                    row.makeUpdatesOriginal();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + _rowDeleted);
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = _rowDeleted;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        block66: {
            block67: {
                block68: {
                    block60: {
                        block61: {
                            block62: {
                                block58: {
                                    boolean bl;
                                    try {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                                                Object var2_1 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var2_2 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.next(), rowCount=" + this.rowCount + ", fetchDirection=" + this.fetchDirection + ", presentRow=" + this.presentRow);
                                                Object var4_14 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var4_15 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if (this.rowCount >= 0) break block58;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                                Object var6_17 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var6_18 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        bl = false;
                                        Object var22_20 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var22_28 = null;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                                Object var24_45 = null;
                                            }
                                            catch (Throwable throwable2) {
                                                Object var24_46 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable2;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        throw throwable;
                                    }
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var24_29 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var24_30 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    return bl;
                                }
                                if (this.fetchDirection != 1000 && this.fetchDirection != 1002) break block60;
                                if (this.presentRow + 1 > this.rowCount) break block61;
                                ++this.presentRow;
                                if (this.showDeleted || !this.getCurrentRow().isRowDeleted()) break block62;
                                boolean __result__ = this.next();
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                        Object var8_56 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_57 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                boolean bl = __result__;
                                Object var22_21 = null;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var24_31 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var24_32 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                return bl;
                            }
                            this.notifyCursorMoved();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    Object var10_59 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var10_60 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            boolean __result__ = true;
                            Object var22_22 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var24_33 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var24_34 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return __result__;
                        }
                        this.presentRow = this.rowCount + 1;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                Object var12_62 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_63 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        boolean __result__ = false;
                        Object var22_23 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var24_35 = null;
                            }
                            catch (Throwable throwable) {
                                Object var24_36 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return __result__;
                    }
                    if (this.fetchDirection != 1001) break block66;
                    if (this.presentRow - 1 <= 0) break block67;
                    --this.presentRow;
                    if (this.showDeleted || !this.getCurrentRow().isRowDeleted()) break block68;
                    boolean __result__ = this.next();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var14_65 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_66 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    boolean bl = __result__;
                    Object var22_24 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var24_37 = null;
                        }
                        catch (Throwable throwable) {
                            Object var24_38 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return bl;
                }
                this.notifyCursorMoved();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        Object var16_68 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_69 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl = true;
                Object var22_25 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var24_39 = null;
                    }
                    catch (Throwable throwable) {
                        Object var24_40 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl;
            }
            this.presentRow = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    Object var18_71 = null;
                }
                catch (Throwable throwable) {
                    Object var18_72 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl = false;
            Object var22_26 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var24_41 = null;
                }
                catch (Throwable throwable) {
                    Object var24_42 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                Object var20_74 = null;
            }
            catch (Throwable throwable) {
                Object var20_75 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var22_27 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var24_43 = null;
            }
            catch (Throwable throwable) {
                Object var24_44 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        block66: {
            block67: {
                block68: {
                    block60: {
                        block61: {
                            block62: {
                                block58: {
                                    boolean bl;
                                    try {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                                                Object var2_1 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var2_2 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.previous(), rowCount=" + this.rowCount + ", fetchDirection=" + this.fetchDirection + ", presentRow=" + this.presentRow);
                                                Object var4_14 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var4_15 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if (this.rowCount >= 0) break block58;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                                Object var6_17 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var6_18 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        bl = false;
                                        Object var22_20 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var22_28 = null;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                                Object var24_45 = null;
                                            }
                                            catch (Throwable throwable2) {
                                                Object var24_46 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable2;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        throw throwable;
                                    }
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var24_29 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var24_30 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    return bl;
                                }
                                if (this.fetchDirection != 1001) break block60;
                                if (this.presentRow + 1 > this.rowCount) break block61;
                                ++this.presentRow;
                                if (this.showDeleted || !this.getCurrentRow().isRowDeleted()) break block62;
                                boolean __result__ = this.previous();
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                        Object var8_56 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_57 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                boolean bl = __result__;
                                Object var22_21 = null;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var24_31 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var24_32 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                return bl;
                            }
                            this.notifyCursorMoved();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    Object var10_59 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var10_60 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            boolean __result__ = true;
                            Object var22_22 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var24_33 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var24_34 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return __result__;
                        }
                        this.presentRow = this.rowCount + 1;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                Object var12_62 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_63 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        boolean __result__ = false;
                        Object var22_23 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var24_35 = null;
                            }
                            catch (Throwable throwable) {
                                Object var24_36 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return __result__;
                    }
                    if (this.fetchDirection != 1000 && this.fetchDirection != 1002) break block66;
                    if (this.presentRow - 1 <= 0) break block67;
                    --this.presentRow;
                    if (this.showDeleted || !this.getCurrentRow().isRowDeleted()) break block68;
                    boolean __result__ = this.previous();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var14_65 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_66 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    boolean bl = __result__;
                    Object var22_24 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var24_37 = null;
                        }
                        catch (Throwable throwable) {
                            Object var24_38 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return bl;
                }
                this.notifyCursorMoved();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        Object var16_68 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_69 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl = true;
                Object var22_25 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var24_39 = null;
                    }
                    catch (Throwable throwable) {
                        Object var24_40 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl;
            }
            this.presentRow = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    Object var18_71 = null;
                }
                catch (Throwable throwable) {
                    Object var18_72 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl = false;
            Object var22_26 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var24_41 = null;
                }
                catch (Throwable throwable) {
                    Object var24_42 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                Object var20_74 = null;
            }
            catch (Throwable throwable) {
                Object var20_75 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var22_27 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var24_43 = null;
            }
            catch (Throwable throwable) {
                Object var24_44 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.isBeforeFirst(), rowCount=" + this.rowCount + ", presentRow=" + this.presentRow);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = this.rowCount > 0 && this.presentRow == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.isAfterLast(), rowCount=" + this.rowCount + ", presentRow=" + this.presentRow);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = this.rowCount > 0 && this.presentRow == this.rowCount + 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = this.presentRow == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.isLast(), presentRow=" + this.presentRow + ", rowCount=" + this.rowCount);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = this.presentRow == this.rowCount;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.presentRow = 0;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.presentRow = this.rowCount + 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.afterLast(), set presentRow to " + this.presentRow);
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.absolute(1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.absolute(-1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int row) throws SQLException {
        block26: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(row));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.absolute(" + row + "), rowsetType=" + this.rowsetType + ", presentRow=" + this.presentRow);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowsetType == 1003) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 314);
                            Object var7_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_12 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 314);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (row != 0 && Math.abs(row) <= this.rowCount) break block26;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var9_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bl = false;
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_24 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_20 = null;
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        this.presentRow = row < 0 ? this.rowCount + row + 1 : row;
        this.notifyCursorMoved();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                Object var11_29 = null;
            }
            catch (Throwable throwable) {
                Object var11_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = true;
        Object var13_18 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_22 = null;
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int rows) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.absolute(this.presentRow + rows);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void populate(ResultSet rs) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rs));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.rows == null) {
                this.rows = new Vector(50, 10);
            } else {
                this.rows.clear();
            }
            this.rowsetMetaData = new OracleRowSetMetaData(rs.getMetaData());
            this.colCount = this.rowsetMetaData.getColumnCount();
            this.metaData = new String[this.colCount];
            for (int i2 = 0; i2 < this.colCount; ++i2) {
                this.metaData[i2] = this.rowsetMetaData.getColumnName(i2 + 1);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populate(ResultSet), " + "metaData=" + this.metaData + ", process with populateInit(ResultSet)");
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!(rs instanceof OracleCachedRowSet)) {
                this.populateInit(rs);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populate(ResultSet), finished of populateInit(rs)");
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean isForwardFetch = this.fetchDirection == 1000 || this.fetchDirection == 1002;
            this.rowCount = 0;
            OracleRow or = null;
            int rowCountLimit = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
            if (rs.getType() != 1003 && this.rows.size() == 0 && !isForwardFetch) {
                rs.afterLast();
            }
            boolean readAll = false;
            while (this.rowCount < rowCountLimit) {
                if (isForwardFetch) {
                    if (!rs.next()) {
                        readAll = true;
                        break;
                    }
                } else if (!rs.previous()) {
                    readAll = true;
                    break;
                }
                or = new OracleRow(this.colCount);
                for (int i3 = 1; i3 <= this.colCount; ++i3) {
                    Object obj = null;
                    try {
                        obj = rs.getObject(i3, this.typeMap);
                    }
                    catch (Exception ex) {
                        obj = rs.getObject(i3);
                    }
                    catch (AbstractMethodError ex) {
                        obj = rs.getObject(i3);
                    }
                    if (obj instanceof Clob || obj instanceof CLOB) {
                        or.setColumnValue(i3, new OracleSerialClob((Clob)obj));
                    } else if (obj instanceof Blob || obj instanceof BLOB) {
                        or.setColumnValue(i3, new OracleSerialBlob((Blob)obj));
                    } else {
                        or.setColumnValue(i3, obj);
                    }
                    or.markOriginalNull(i3, rs.wasNull());
                }
                if (isForwardFetch) {
                    this.rows.add(or);
                } else {
                    this.rows.add(1, or);
                }
                ++this.rowCount;
            }
            if (readAll || isForwardFetch && rs.isAfterLast() || !isForwardFetch && rs.isBeforeFirst()) {
                this.isPopulateDone = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.populate(ResultSet) " + this.rowCount + " rows populated");
                    Object var10_18 = null;
                }
                catch (Throwable throwable) {
                    Object var10_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = null;
            this.notifyRowSetChanged();
            Object var12_21 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_25 = null;
            }
            catch (Throwable throwable2) {
                Object var14_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_23 = null;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCursorName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void clearParameters() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.param = null;
            this.param = new Vector();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.previousColumnWasNull);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.previousColumnWasNull;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.release();
            this.isClosed = true;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            sQLWarning = this.sqlWarning;
            Object var6_8 = null;
            if (!TRACE) return sQLWarning;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return sQLWarning;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return sQLWarning;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.sqlWarning = null;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsetMetaData);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            resultSetMetaData = this.rowsetMetaData;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = this.getColumnIndex(columnName);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getParams() throws SQLException {
        Object[] objectArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    objectArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object[] __result__ = this.param.toArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            objectArray = __result__;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(RowSetMetaData md) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(md));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.rowsetMetaData = md;
            if (md != null) {
                this.colCount = md.getColumnCount();
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void execute() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.isConnectionStayingOpenForTxnControl = false;
            this.getReader().readData(this);
            this.executeCalled = true;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptChanges() throws SyncProviderException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                this.getWriter().writeData(this);
            }
            catch (SQLException sqlexc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SyncProviderException: " + sqlexc.getMessage());
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new SyncProviderException(sqlexc.getMessage());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptChanges(Connection con) throws SyncProviderException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(con));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = con;
            this.isConnectionStayingOpenForTxnControl = true;
            this.acceptChanges();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Object clone() throws CloneNotSupportedException {
        try {
            CachedRowSet cachedRowSet;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    cachedRowSet = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                CachedRowSet __result__ = this.createCopy();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                cachedRowSet = __result__;
            }
            catch (SQLException ea) {
                if (!TRACE) throw new CloneNotSupportedException("SQL Error occured while cloning: " + ea.getMessage());
                if (!OracleLog.recursiveEnter()) throw new CloneNotSupportedException("SQL Error occured while cloning: " + ea.getMessage());
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing CloneNotSupportedException: " + "SQL Error occured while cloning: " + ea.getMessage());
                    Object var6_17 = null;
                    OracleLog.recursiveExit();
                    throw new CloneNotSupportedException("SQL Error occured while cloning: " + ea.getMessage());
                }
                catch (Throwable throwable) {
                    Object var6_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_9 = null;
            if (!TRACE) return cachedRowSet;
            if (!OracleLog.recursiveEnter()) return cachedRowSet;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_11 = null;
                OracleLog.recursiveExit();
                return cachedRowSet;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet ocrs = (OracleCachedRowSet)this.createShared();
            int size = this.rows.size();
            ocrs.rows = new Vector(size);
            for (int i2 = 0; i2 < size; ++i2) {
                ocrs.rows.add(((OracleRow)this.rows.elementAt(i2)).createCopy());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ocrs);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = ocrs;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet createShared() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet ocrs = new OracleCachedRowSet();
            ocrs.rows = this.rows;
            ocrs.setDataSource(this.getDataSource());
            ocrs.setDataSourceName(this.getDataSourceName());
            ocrs.setUsername(this.getUsername());
            ocrs.setPassword(this.getPassword());
            ocrs.setUrl(this.getUrl());
            ocrs.setTypeMap(this.getTypeMap());
            ocrs.setMaxFieldSize(this.getMaxFieldSize());
            ocrs.setMaxRows(this.getMaxRows());
            ocrs.setQueryTimeout(this.getQueryTimeout());
            ocrs.setFetchSize(this.getFetchSize());
            ocrs.setEscapeProcessing(this.getEscapeProcessing());
            ocrs.setConcurrency(this.getConcurrency());
            ocrs.setReadOnly(this.readOnly);
            this.rowsetType = this.getType();
            this.fetchDirection = this.getFetchDirection();
            ocrs.setCommand(this.getCommand());
            ocrs.setTransactionIsolation(this.getTransactionIsolation());
            ocrs.presentRow = this.presentRow;
            ocrs.colCount = this.colCount;
            ocrs.rowCount = this.rowCount;
            ocrs.showDeleted = this.showDeleted;
            ocrs.syncProvider = this.syncProvider;
            ocrs.currentPage = this.currentPage;
            ocrs.pageSize = this.pageSize;
            ocrs.tableName = this.tableName == null ? null : this.tableName;
            ocrs.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
            int size = this.listener.size();
            for (i2 = 0; i2 < size; ++i2) {
                ocrs.listener.add(this.listener.elementAt(i2));
            }
            ocrs.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
            size = this.param.size();
            for (i2 = 0; i2 < size; ++i2) {
                ocrs.param.add(this.param.elementAt(i2));
            }
            ocrs.metaData = new String[this.metaData.length];
            System.arraycopy(this.metaData, 0, ocrs.metaData, 0, this.metaData.length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.createShared(), rowsetType=" + this.rowsetType + ", size=" + size + ", fetchDirection=" + this.fetchDirection + ", return " + ocrs);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ocrs);
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = ocrs;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.rows = null;
            this.rows = new Vector();
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            this.rowCount = 0;
            this.presentRow = 0;
            this.notifyRowSetChanged();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreOriginal() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean rowsetChanged = false;
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                OracleRow row = (OracleRow)this.rows.elementAt(i2);
                if (row.isRowInserted()) {
                    this.rows.remove(i2);
                    --this.rowCount;
                    --i2;
                    rowsetChanged = true;
                    continue;
                }
                if (row.isRowUpdated()) {
                    row.setRowUpdated(false);
                    rowsetChanged = true;
                    continue;
                }
                if (!row.isRowDeleted()) continue;
                row.setRowDeleted(false);
                rowsetChanged = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.restoreOriginal(), rowsetChanged=" + rowsetChanged + ", presentRow=" + this.presentRow);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!rowsetChanged) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 315);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 315);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.notifyRowSetChanged();
            this.presentRow = 0;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection toCollection() throws SQLException {
        Collection collection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Map<Integer, Collection> collection2 = Collections.synchronizedMap(new TreeMap());
            try {
                for (int i2 = 0; i2 < this.rowCount; ++i2) {
                    collection2.put(i2, ((OracleRow)this.rows.elementAt(i2)).toCollection());
                }
            }
            catch (Exception exc) {
                collection2 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 316);
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 316);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Collection __result__ = collection2.values();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_13 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            collection = __result__;
            Object var8_16 = null;
            if (!TRACE) return collection;
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return collection;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_18 = null;
            OracleLog.recursiveExit();
            return collection;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection toCollection(int column) throws SQLException {
        Vector<Object> vector;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (column < 1 || column > this.colCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + column);
                        Object var5_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + column);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Vector<Object> collection = new Vector<Object>(this.rowCount);
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                OracleRow row = (OracleRow)this.rows.elementAt(i2);
                Object obj = row.isColumnChanged(column) ? row.getModifiedColumn(column) : row.getColumn(column);
                collection.add(obj);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + collection);
                    Object var7_14 = null;
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            vector = collection;
            Object var9_17 = null;
            if (!TRACE) return vector;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_21 = null;
            }
            catch (Throwable throwable2) {
                Object var11_22 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return vector;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_19 = null;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection(String columnName) throws SQLException {
        Collection collection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    collection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Collection __result__ = this.toCollection(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            collection = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        block22: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getRow(), presentRow=" + this.presentRow + ", rowCount=" + this.rowCount);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.presentRow <= this.rowCount) break block22;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowCount);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = this.rowCount;
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var12_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var12_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.presentRow);
                Object var8_24 = null;
            }
            catch (Throwable throwable) {
                Object var8_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = this.presentRow;
        Object var10_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowInsert() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.getCurrentRow().isRowInserted()) {
                this.rows.remove(--this.presentRow);
                --this.rowCount;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 317);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.notifyRowChanged();
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowDelete() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.getCurrentRow().isRowDeleted()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 318);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 318);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.getCurrentRow().setRowDeleted(false);
            this.notifyRowChanged();
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelRowUpdates() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.getCurrentRow().isRowUpdated()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 319);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.updateRowFlag = false;
            this.getCurrentRow().setRowUpdated(false);
            this.notifyRowChanged();
            Object var6_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.cancelRowUpdates(), insertRowFlag=" + this.insertRowFlag);
                    Object var4_7 = null;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 317);
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!this.insertRow.isRowFullyPopulated()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 320);
                        Object var10_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 320);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.insertRow.insertRow();
            this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
            this.insertRowFlag = false;
            ++this.rowCount;
            this.notifyRowChanged();
            Object var12_19 = null;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_23 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_21 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.updateRow(), updateRowFlag=" + this.updateRowFlag);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!this.updateRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 319);
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.updateRowFlag = false;
            this.getCurrentRow().setRowUpdated(true);
            this.notifyRowChanged();
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.getCurrentRow().setRowDeleted(true);
            this.notifyRowChanged();
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        try {
            OracleRow row;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((row = this.getCurrentRow()).isRowUpdated()) {
                row.cancelRowUpdates();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.refreshRow(), row=" + row);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveToInsertRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.insertRow = new OracleRow(this.colCount, true);
            this.insertRowFlag = true;
            this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.moveToInsertRow(), insertRowPosition=" + this.insertRowPosition + ", presentRow=" + this.presentRow);
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.insertRowFlag = false;
            this.updateRowFlag = false;
            this.absolute(this.presentRow);
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowUpdated() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.getCurrentRow().isRowUpdated();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowInserted() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.getCurrentRow().isRowInserted();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    public boolean rowDeleted() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet cachedrowset = new OracleCachedRowSet();
            cachedrowset.rowsetMetaData = this.rowsetMetaData;
            cachedrowset.rowCount = 1;
            cachedrowset.colCount = this.colCount;
            cachedrowset.presentRow = 0;
            cachedrowset.setReader(null);
            cachedrowset.setWriter(null);
            OracleRow row = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
            cachedrowset.rows.add(row);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cachedrowset);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = cachedrowset;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet cachedrowset = new OracleCachedRowSet();
            cachedrowset.rowsetMetaData = this.rowsetMetaData;
            cachedrowset.rowCount = this.rowCount;
            cachedrowset.colCount = this.colCount;
            cachedrowset.presentRow = 0;
            cachedrowset.setType(1004);
            cachedrowset.setConcurrency(1008);
            cachedrowset.setReader(null);
            cachedrowset.setWriter(null);
            int i2 = this.rowsetMetaData.getColumnCount();
            OracleRow row = null;
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                row = new OracleRow(i2, ((OracleRow)iterator.next()).getOriginalRow());
                cachedrowset.rows.add(row);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cachedrowset);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = cachedrowset;
            Object var8_11 = null;
            if (!TRACE) return oracleCachedRowSet;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_15 = null;
            }
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return oracleCachedRowSet;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(sqlType));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, null);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(typeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{sqlType, typeName};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, new Byte(x));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, Float.valueOf(x));
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{x, length, 2};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int i2, Time time, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(calendar));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(i2);
            Object[] obj = new Object[]{time, calendar};
            this.param.add(i2 - 1, obj);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int i2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(calendar));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(i2);
            Object[] obj = new Object[]{timestamp, calendar};
            this.param.add(i2 - 1, obj);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int i2, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2) + ", " + OracleLog.argument(timestamp));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(i2);
            this.param.add(i2 - 1, timestamp);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{x, length, 3};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{x, length, 1};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{reader, length, 4};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType) + ", " + OracleLog.argument(scale));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{x, targetSqlType, scale};
            this.param.add(parameterIndex - 1, obj);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{x, targetSqlType};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            Object[] obj = new Object[]{x, cal};
            this.param.add(parameterIndex - 1, obj);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(parameterIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(parameterIndex);
            this.param.add(parameterIndex - 1, x.toString());
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(int columnIndex) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int index = this.presentRow * this.colCount + columnIndex - 1;
            Object obj = null;
            obj = !this.isUpdated(columnIndex) ? this.getCurrentRow().getColumn(columnIndex) : this.getCurrentRow().getModifiedColumn(columnIndex);
            boolean bl = this.previousColumnWasNull = obj == null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + obj);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = obj;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Number getNumber(int columnIndex) throws SQLException {
        try {
            Number __result__;
            Object n2;
            Number number;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    number = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((n2 = this.getObject(columnIndex)) == null || n2 instanceof BigDecimal || n2 instanceof Number) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Number)n2);
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                number = (Number)n2;
                Object var15_13 = null;
                if (!TRACE) return number;
                if (!OracleLog.recursiveEnter()) return number;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_17 = null;
                    OracleLog.recursiveExit();
                    return number;
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (n2 instanceof Boolean) {
                __result__ = (Boolean)n2 != false ? 1 : 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var7_29 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Integer n3 = __result__;
                Object var15_14 = null;
                if (!TRACE) return n3;
                if (!OracleLog.recursiveEnter()) return n3;
                try {}
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_19 = null;
                OracleLog.recursiveExit();
                return n3;
            }
            if (n2 instanceof String) {
                Number number2;
                try {
                    __result__ = new BigDecimal((String)n2);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var9_32 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_33 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    number2 = __result__;
                }
                catch (NumberFormatException ea) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                            Object var11_35 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var11_36 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Object var15_15 = null;
                if (!TRACE) return number2;
                if (!OracleLog.recursiveEnter()) return number2;
                try {}
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_21 = null;
                OracleLog.recursiveExit();
                return number2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                    Object var13_38 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_24 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public Object getObject(int i, Map map) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int columnIndex) throws SQLException {
        block33: {
            boolean __result__;
            Object b2;
            block31: {
                block29: {
                    boolean bl;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                Object var3_2 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        if ((b2 = this.getObject(columnIndex)) != null) break block29;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                Object var5_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_10 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        bl = false;
                        Object var13_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var15_24 = null;
                            }
                            catch (Throwable throwable2) {
                                Object var15_25 = null;
                                OracleLog.recursiveExit();
                                throw throwable2;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        throw throwable;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var15_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return bl;
                }
                if (!(b2 instanceof Boolean)) break block31;
                boolean __result__2 = (Boolean)b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__2);
                        Object var7_30 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_31 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl = __result__2;
                Object var13_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl;
            }
            if (!(b2 instanceof Number)) break block33;
            boolean bl = __result__ = ((Number)b2).doubleValue() != 0.0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var9_33 = null;
                }
                catch (Throwable throwable) {
                    Object var9_34 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__;
            Object var13_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_22 = null;
                }
                catch (Throwable throwable) {
                    Object var15_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var11_36 = null;
            }
            catch (Throwable throwable) {
                Object var11_37 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int columnIndex) throws SQLException {
        block61: {
            Cloneable c2;
            Object b2;
            block59: {
                block57: {
                    block55: {
                        block53: {
                            block51: {
                                byte by;
                                try {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                            Object var3_2 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_3 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    if ((b2 = this.getObject(columnIndex)) != null) break block51;
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                                            Object var5_9 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_10 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    by = 0;
                                    Object var21_21 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var21_27 = null;
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var23_40 = null;
                                        }
                                        catch (Throwable throwable2) {
                                            Object var23_41 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable2;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    throw throwable;
                                }
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var23_28 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var23_29 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                return by;
                            }
                            if (!(b2 instanceof BigDecimal)) break block53;
                            BigDecimal bd = (BigDecimal)b2;
                            if (bd.compareTo(new BigDecimal(127)) == 1 || bd.compareTo(new BigDecimal(-128)) == -1) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26);
                                        Object var7_49 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_50 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26);
                                __ex__.fillInStackTrace();
                                throw __ex__;
                            }
                            byte __result__2 = bd.byteValue();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__2);
                                    Object var9_52 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_53 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            byte by = __result__2;
                            Object var21_22 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var23_30 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var23_31 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return by;
                        }
                        if (!(b2 instanceof Number)) break block55;
                        byte __result__ = ((Number)b2).byteValue();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var11_55 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_56 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        byte __result__2 = __result__;
                        Object var21_23 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var23_32 = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_33 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return __result__2;
                    }
                    if (!(b2 instanceof String)) break block57;
                    byte __result__ = ((String)b2).getBytes()[0];
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var13_58 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_59 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    byte __result__2 = __result__;
                    Object var21_24 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var23_34 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_35 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return __result__2;
                }
                if (!(b2 instanceof OracleSerialBlob)) break block59;
                c2 = (OracleSerialBlob)b2;
                byte __result__ = ((OracleSerialBlob)c2).getBytes(1L, 1)[0];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var15_61 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_62 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byte by = __result__;
                Object var21_25 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var23_36 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_37 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return by;
            }
            if (!(b2 instanceof OracleSerialClob)) break block61;
            c2 = (OracleSerialClob)b2;
            byte __result__ = ((OracleSerialClob)c2).getSubString(1L, 1).getBytes()[0];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var17_64 = null;
                }
                catch (Throwable throwable) {
                    Object var17_65 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte by = __result__;
            Object var21_26 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var23_38 = null;
                }
                catch (Throwable throwable) {
                    Object var23_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return by;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var19_67 = null;
            }
            catch (Throwable throwable) {
                Object var19_68 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int columnIndex) throws SQLException {
        short s2;
        try {
            Number b2;
            short __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short s3 = __result__ = (b2 = this.getNumber(columnIndex)) == null ? (short)0 : b2.shortValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = __result__;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(int columnIndex) throws SQLException {
        int n2;
        try {
            Number b2;
            int __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = __result__ = (b2 = this.getNumber(columnIndex)) == null ? 0 : b2.intValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_11 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_15 = null;
            }
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int columnIndex) throws SQLException {
        long l2;
        try {
            Number b2;
            long __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long l3 = __result__ = (b2 = this.getNumber(columnIndex)) == null ? 0L : b2.longValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getFloat(int columnIndex) throws SQLException {
        float f2;
        try {
            Number b2;
            float __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            float f3 = __result__ = (b2 = this.getNumber(columnIndex)) == null ? 0.0f : b2.floatValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            f2 = __result__;
            Object var7_11 = null;
            if (!TRACE) return f2;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return f2;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            return f2;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(int columnIndex) throws SQLException {
        double d2;
        try {
            Number b2;
            double __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            double d3 = __result__ = (b2 = this.getNumber(columnIndex)) == null ? 0.0 : b2.doubleValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            d2 = __result__;
            Object var8_11 = null;
            if (!TRACE) return d2;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_15 = null;
            }
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return d2;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Number b2;
        block19: {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        bigDecimal = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((b2 = this.getNumber(columnIndex)) != null && !(b2 instanceof BigDecimal)) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BigDecimal)b2);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bigDecimal = (BigDecimal)b2;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_17 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bigDecimal;
        }
        BigDecimal __result__ = new BigDecimal(b2.doubleValue());
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var7_22 = null;
            }
            catch (Throwable throwable) {
                Object var7_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        BigDecimal bigDecimal = __result__;
        Object var9_11 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(scale));
                    bigDecimal = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            BigDecimal __result__ = this.getBigDecimal(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bigDecimal = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bigDecimal;
    }

    /*
     * Exception decompiling
     */
    public Date getDate(int columnIndex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    date = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Date __result__ = this.getDate(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            date = __result__;
            Object var8_10 = null;
            if (!TRACE) return date;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return date;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            return date;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex) throws SQLException {
        block49: {
            Object d2;
            block47: {
                Time __result__;
                block45: {
                    block43: {
                        block41: {
                            Time time;
                            try {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                        time = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                if ((d2 = this.getObject(columnIndex)) != null) break block41;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Time)d2);
                                        Object var5_6 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_7 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                time = (Time)d2;
                                Object var17_15 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_20 = null;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var19_31 = null;
                                    }
                                    catch (Throwable throwable2) {
                                        Object var19_32 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable2;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                throw throwable;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var19_21 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var19_22 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return time;
                        }
                        if (!(d2 instanceof java.util.Date)) break block43;
                        java.util.Date t = (java.util.Date)d2;
                        Time __result__2 = new Time(t.getHours(), t.getMinutes(), t.getSeconds());
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__2);
                                Object var7_39 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_40 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        Time time = __result__2;
                        Object var17_16 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var19_23 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_24 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return time;
                    }
                    if (!(d2 instanceof TIMESTAMP)) break block45;
                    __result__ = ((TIMESTAMP)d2).timeValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var9_42 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_43 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    Time __result__2 = __result__;
                    Object var17_17 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var19_25 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_26 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return __result__2;
                }
                if (!(d2 instanceof TIMESTAMPTZ)) break block47;
                __result__ = ((TIMESTAMPTZ)d2).timeValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var11_45 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_46 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                Time __result__2 = __result__;
                Object var17_18 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_27 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return __result__2;
            }
            if (!(d2 instanceof TIMESTAMPLTZ)) break block49;
            Connection c2 = this.getConnectionInternal();
            Time __result__ = ((TIMESTAMPLTZ)d2).timeValue(c2, this.getSessionCalendar(c2));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var13_48 = null;
                }
                catch (Throwable throwable) {
                    Object var13_49 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time time = __result__;
            Object var17_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_29 = null;
                }
                catch (Throwable throwable) {
                    Object var19_30 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return time;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var15_51 = null;
            }
            catch (Throwable throwable) {
                Object var15_52 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    time = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time __result__ = this.getTime(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            time = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        block49: {
            Object d2;
            block47: {
                Timestamp __result__;
                block45: {
                    block43: {
                        block41: {
                            Timestamp timestamp;
                            try {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                        timestamp = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                if ((d2 = this.getObject(columnIndex)) != null && !(d2 instanceof Timestamp)) break block41;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Timestamp)d2);
                                        Object var5_6 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_7 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                timestamp = (Timestamp)d2;
                                Object var17_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_19 = null;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var19_30 = null;
                                    }
                                    catch (Throwable throwable2) {
                                        Object var19_31 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable2;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                throw throwable;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var19_20 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var19_21 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return timestamp;
                        }
                        if (!(d2 instanceof java.util.Date)) break block43;
                        __result__ = new Timestamp(((java.util.Date)d2).getTime());
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var7_38 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_39 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        Timestamp timestamp = __result__;
                        Object var17_15 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var19_22 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_23 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return timestamp;
                    }
                    if (!(d2 instanceof TIMESTAMP)) break block45;
                    __result__ = ((TIMESTAMP)d2).timestampValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var9_41 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_42 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    Timestamp timestamp = __result__;
                    Object var17_16 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var19_24 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_25 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return timestamp;
                }
                if (!(d2 instanceof TIMESTAMPTZ)) break block47;
                __result__ = ((TIMESTAMPTZ)d2).timestampValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var11_44 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_45 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                Timestamp timestamp = __result__;
                Object var17_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_26 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return timestamp;
            }
            if (!(d2 instanceof TIMESTAMPLTZ)) break block49;
            Connection c2 = this.getConnectionInternal();
            Timestamp __result__ = ((TIMESTAMPLTZ)d2).timestampValue(c2, this.getSessionCalendar(c2));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var13_47 = null;
                }
                catch (Throwable throwable) {
                    Object var13_48 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp timestamp = __result__;
            Object var17_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_28 = null;
                }
                catch (Throwable throwable) {
                    Object var19_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return timestamp;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var15_50 = null;
            }
            catch (Throwable throwable) {
                Object var15_51 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    timestamp = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp __result__ = this.getTimestamp(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            timestamp = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes(int columnIndex) throws SQLException {
        block51: {
            Cloneable c2;
            Object b2;
            block50: {
                block49: {
                    byte[] __result__;
                    block48: {
                        block47: {
                            block46: {
                                byte[] byArray;
                                block45: {
                                    try {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                                byArray = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var3_3 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if ((b2 = this.getObject(columnIndex)) != null) break block45;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (byte[])b2);
                                                Object var5_6 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var5_7 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        byArray = (byte[])b2;
                                        Object var21_16 = null;
                                        if (!TRACE) return byArray;
                                    }
                                    catch (Throwable throwable) {
                                        Object var21_23 = null;
                                        if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var23_38 = null;
                                        }
                                        catch (Throwable throwable2) {
                                            Object var23_39 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable2;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                            throw throwable;
                                        }
                                    }
                                    if (!OracleLog.recursiveEnter()) return byArray;
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var23_24 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var23_25 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    return byArray;
                                }
                                if (!(b2 instanceof byte[])) break block46;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (byte[])b2);
                                        Object var7_48 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_49 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                byArray = (byte[])b2;
                                Object var21_17 = null;
                                if (!TRACE) return byArray;
                                if (!OracleLog.recursiveEnter()) return byArray;
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var23_26 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var23_27 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                return byArray;
                            }
                            if (!(b2 instanceof String)) break block47;
                            __result__ = ((String)b2).getBytes();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                    Object var9_51 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_52 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            byte[] byArray = __result__;
                            Object var21_18 = null;
                            if (!TRACE) return byArray;
                            if (!OracleLog.recursiveEnter()) return byArray;
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var23_28 = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_29 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            return byArray;
                        }
                        if (!(b2 instanceof Number)) break block48;
                        __result__ = ((Number)b2).toString().getBytes();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var11_54 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_55 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        byte[] byArray = __result__;
                        Object var21_19 = null;
                        if (!TRACE) return byArray;
                        if (!OracleLog.recursiveEnter()) return byArray;
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var23_30 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_31 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        return byArray;
                    }
                    if (!(b2 instanceof BigDecimal)) break block49;
                    __result__ = ((BigDecimal)b2).toString().getBytes();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var13_57 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_58 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    byte[] byArray = __result__;
                    Object var21_20 = null;
                    if (!TRACE) return byArray;
                    if (!OracleLog.recursiveEnter()) return byArray;
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var23_32 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_33 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    return byArray;
                }
                if (!(b2 instanceof OracleSerialBlob)) break block50;
                c2 = (OracleSerialBlob)b2;
                byte[] __result__ = ((OracleSerialBlob)c2).getBytes(1L, (int)((OracleSerialBlob)c2).length());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var15_60 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_61 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byte[] byArray = __result__;
                Object var21_21 = null;
                if (!TRACE) return byArray;
                if (!OracleLog.recursiveEnter()) return byArray;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var23_34 = null;
                }
                catch (Throwable throwable) {
                    Object var23_35 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                return byArray;
            }
            if (!(b2 instanceof OracleSerialClob)) break block51;
            c2 = (OracleSerialClob)b2;
            byte[] __result__ = ((OracleSerialClob)c2).getSubString(1L, (int)((OracleSerialClob)c2).length()).getBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var17_63 = null;
                }
                catch (Throwable throwable) {
                    Object var17_64 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] byArray = __result__;
            Object var21_22 = null;
            if (!TRACE) return byArray;
            if (!OracleLog.recursiveEnter()) return byArray;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var23_36 = null;
            }
            catch (Throwable throwable) {
                Object var23_37 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return byArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var19_66 = null;
            }
            catch (Throwable throwable) {
                Object var19_67 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Ref getRef(int i2) throws SQLException {
        block15: {
            Ref ref;
            try {
                Object b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((b2 = this.getObject(i2)) != null && !(b2 instanceof Ref)) break block15;
                Ref __result__ = (Ref)b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                ref = __result__;
                Object var9_10 = null;
                if (!TRACE) return ref;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return ref;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return ref;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var7_18 = null;
            }
            catch (Throwable throwable) {
                Object var7_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int i2) throws SQLException {
        block17: {
            Blob blob;
            try {
                Object b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((b2 = this.getObject(i2)) != null && !(b2 instanceof OracleSerialBlob)) break block17;
                Blob __result__ = (Blob)b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                blob = __result__;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return blob;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var7_18 = null;
            }
            catch (Throwable throwable) {
                Object var7_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int i2) throws SQLException {
        block17: {
            Clob clob;
            try {
                Object b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((b2 = this.getObject(i2)) != null && !(b2 instanceof OracleSerialClob)) break block17;
                Clob __result__ = (Clob)b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                clob = __result__;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return clob;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var7_18 = null;
            }
            catch (Throwable throwable) {
                Object var7_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Array getArray(int i2) throws SQLException {
        try {
            Object b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(i2));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((b2 = this.getObject(i2)) == null || b2 instanceof Array) {
                Array __result__ = (Array)b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Array array = __result__;
                Object var9_10 = null;
                if (!TRACE) return array;
                if (!OracleLog.recursiveEnter()) return array;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_12 = null;
                    OracleLog.recursiveExit();
                    return array;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var7_18 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(int columnIndex) throws SQLException {
        try {
            block81: {
                block80: {
                    block79: {
                        block78: {
                            block77: {
                                block76: {
                                    block75: {
                                        block74: {
                                            block73: {
                                                block72: {
                                                    block71: {
                                                        if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                                            try {
                                                                OracleCachedRowSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                                                                var3_2 = null;
                                                            }
                                                            catch (Throwable var2_5) {
                                                                var3_3 = null;
                                                                OracleLog.recursiveExit();
                                                                throw var2_5;
                                                            }
                                                            OracleLog.recursiveExit();
                                                        }
                                                        if ((b = this.getObject(columnIndex)) != null) break block71;
                                                        if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                                            try {
                                                                OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)b);
                                                                var5_7 = null;
                                                            }
                                                            catch (Throwable var4_12) {
                                                                var5_8 = null;
                                                                OracleLog.recursiveExit();
                                                                throw var4_12;
                                                            }
                                                            OracleLog.recursiveExit();
                                                        }
                                                        var3_2 = (String)b;
                                                        var31_23 = null;
                                                        if (OracleCachedRowSet.TRACE == false) return var3_2;
                                                        ** GOTO lbl270
                                                    }
                                                    if (!(b instanceof String)) break block72;
                                                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                                        try {
                                                            OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)b);
                                                            var7_71 = null;
                                                        }
                                                        catch (Throwable var6_74) {
                                                            var7_72 = null;
                                                            OracleLog.recursiveExit();
                                                            throw var6_74;
                                                        }
                                                        OracleLog.recursiveExit();
                                                    }
                                                    var3_2 = (String)b;
                                                    ** GOTO lbl283
                                                }
                                                if (!(b instanceof Number) && !(b instanceof BigDecimal)) break block73;
                                                __result__ = b.toString();
                                                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                                    try {
                                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                                        var9_76 = null;
                                                    }
                                                    catch (Throwable var8_78) {
                                                        var9_77 = null;
                                                        OracleLog.recursiveExit();
                                                        throw var8_78;
                                                    }
                                                    OracleLog.recursiveExit();
                                                }
                                                var4_13 = __result__;
                                                ** GOTO lbl298
                                            }
                                            if (!(b instanceof Date)) break block74;
                                            __result__ = b.toString();
                                            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                                try {
                                                    OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                                    var11_80 = null;
                                                }
                                                catch (Throwable var10_82) {
                                                    var11_81 = null;
                                                    OracleLog.recursiveExit();
                                                    throw var10_82;
                                                }
                                                OracleLog.recursiveExit();
                                            }
                                            var4_14 = __result__;
                                            ** GOTO lbl313
                                        }
                                        if (!(b instanceof Timestamp)) break block75;
                                        __result__ = b.toString();
                                        if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                                var13_83 = null;
                                            }
                                            catch (Throwable var12_85) {
                                                var13_84 = null;
                                                OracleLog.recursiveExit();
                                                throw var12_85;
                                            }
                                            OracleLog.recursiveExit();
                                        }
                                        var4_15 = __result__;
                                        ** GOTO lbl328
                                    }
                                    if (!(b instanceof byte[])) break block76;
                                    __result__ = new String((byte[])b);
                                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                            var15_86 = null;
                                        }
                                        catch (Throwable var14_88) {
                                            var15_87 = null;
                                            OracleLog.recursiveExit();
                                            throw var14_88;
                                        }
                                        OracleLog.recursiveExit();
                                    }
                                    var4_16 = __result__;
                                    ** GOTO lbl343
                                }
                                if (!(b instanceof OracleSerialClob)) break block77;
                                c = (OracleSerialClob)b;
                                __result__ = c.getSubString(1L, (int)c.length());
                                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                        var17_89 = null;
                                    }
                                    catch (Throwable var16_91) {
                                        var17_90 = null;
                                        OracleLog.recursiveExit();
                                        throw var16_91;
                                    }
                                    OracleLog.recursiveExit();
                                }
                                var5_9 = __result__;
                                ** GOTO lbl358
                            }
                            if (!(b instanceof OracleSerialBlob)) break block78;
                            c = (OracleSerialBlob)b;
                            __result__ = new String(c.getBytes(1L, (int)c.length()));
                            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                    var19_92 = null;
                                }
                                catch (Throwable var18_94) {
                                    var19_93 = null;
                                    OracleLog.recursiveExit();
                                    throw var18_94;
                                }
                                OracleLog.recursiveExit();
                            }
                            var5_10 = __result__;
                            ** GOTO lbl373
                        }
                        if (!(b instanceof URL)) break block79;
                        __result__ = ((URL)b).toString();
                        if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                var21_95 = null;
                            }
                            catch (Throwable var20_97) {
                                var21_96 = null;
                                OracleLog.recursiveExit();
                                throw var20_97;
                            }
                            OracleLog.recursiveExit();
                        }
                        __result__ = __result__;
                        ** GOTO lbl388
                    }
                    if (!(b instanceof ROWID)) break block80;
                    __result__ = ((ROWID)b).stringValue();
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            var23_98 = null;
                        }
                        catch (Throwable var22_100) {
                            var23_99 = null;
                            OracleLog.recursiveExit();
                            throw var22_100;
                        }
                        OracleLog.recursiveExit();
                    }
                    __result__ = __result__;
                    ** GOTO lbl403
                }
                if (!(b instanceof Reader)) break block81;
                try {
                    reader = (Reader)b;
                    c = new char[1024];
                    bytesRead = 0;
                    sb = new StringBuffer(1024);
                    while ((bytesRead = reader.read(c)) > 0) {
                        sb.append(c, 0, bytesRead);
                    }
                    __result__ = sb.substring(0, sb.length());
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            var25_101 = null;
                        }
                        catch (Throwable var24_103) {
                            var25_102 = null;
                            OracleLog.recursiveExit();
                            throw var24_103;
                        }
                        OracleLog.recursiveExit();
                    }
                    var8_79 = __result__;
                    ** GOTO lbl418
                }
                catch (IOException ea) {
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 321 + ea.getMessage());
                            var27_104 = null;
                        }
                        catch (Throwable var26_106) {
                            var27_105 = null;
                            OracleLog.recursiveExit();
                            throw var26_106;
                        }
                        OracleLog.recursiveExit();
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 321, ea.getMessage());
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                    var29_107 = null;
                }
                catch (Throwable var28_109) {
                    var29_108 = null;
                    OracleLog.recursiveExit();
                    throw var28_109;
                }
                OracleLog.recursiveExit();
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable var30_110) {
            var31_34 = null;
            if (OracleCachedRowSet.TRACE == false) throw var30_110;
            if (OracleLog.recursiveEnter() == false) throw var30_110;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var33_57 = null;
            }
            catch (Throwable var32_70) {
                var33_58 = null;
                OracleLog.recursiveExit();
                throw var32_70;
            }
lbl270:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var3_2;
            try {}
            catch (Throwable var32_59) {
                var33_36 = null;
                OracleLog.recursiveExit();
                throw var32_59;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_35 = null;
            OracleLog.recursiveExit();
            return var3_2;
lbl283:
            // 1 sources

            var31_24 = null;
            if (OracleCachedRowSet.TRACE == false) return var3_2;
            if (OracleLog.recursiveEnter() == false) return var3_2;
            try {}
            catch (Throwable var32_60) {
                var33_38 = null;
                OracleLog.recursiveExit();
                throw var32_60;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_37 = null;
            OracleLog.recursiveExit();
            return var3_2;
lbl298:
            // 1 sources

            var31_25 = null;
            if (OracleCachedRowSet.TRACE == false) return var4_13;
            if (OracleLog.recursiveEnter() == false) return var4_13;
            try {}
            catch (Throwable var32_61) {
                var33_40 = null;
                OracleLog.recursiveExit();
                throw var32_61;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_39 = null;
            OracleLog.recursiveExit();
            return var4_13;
lbl313:
            // 1 sources

            var31_26 = null;
            if (OracleCachedRowSet.TRACE == false) return var4_14;
            if (OracleLog.recursiveEnter() == false) return var4_14;
            try {}
            catch (Throwable var32_62) {
                var33_42 = null;
                OracleLog.recursiveExit();
                throw var32_62;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_41 = null;
            OracleLog.recursiveExit();
            return var4_14;
lbl328:
            // 1 sources

            var31_27 = null;
            if (OracleCachedRowSet.TRACE == false) return var4_15;
            if (OracleLog.recursiveEnter() == false) return var4_15;
            try {}
            catch (Throwable var32_63) {
                var33_44 = null;
                OracleLog.recursiveExit();
                throw var32_63;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_43 = null;
            OracleLog.recursiveExit();
            return var4_15;
lbl343:
            // 1 sources

            var31_28 = null;
            if (OracleCachedRowSet.TRACE == false) return var4_16;
            if (OracleLog.recursiveEnter() == false) return var4_16;
            try {}
            catch (Throwable var32_64) {
                var33_46 = null;
                OracleLog.recursiveExit();
                throw var32_64;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_45 = null;
            OracleLog.recursiveExit();
            return var4_16;
lbl358:
            // 1 sources

            var31_29 = null;
            if (OracleCachedRowSet.TRACE == false) return var5_9;
            if (OracleLog.recursiveEnter() == false) return var5_9;
            try {}
            catch (Throwable var32_65) {
                var33_48 = null;
                OracleLog.recursiveExit();
                throw var32_65;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_47 = null;
            OracleLog.recursiveExit();
            return var5_9;
lbl373:
            // 1 sources

            var31_30 = null;
            if (OracleCachedRowSet.TRACE == false) return var5_10;
            if (OracleLog.recursiveEnter() == false) return var5_10;
            try {}
            catch (Throwable var32_66) {
                var33_50 = null;
                OracleLog.recursiveExit();
                throw var32_66;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_49 = null;
            OracleLog.recursiveExit();
            return var5_10;
lbl388:
            // 1 sources

            var31_31 = null;
            if (OracleCachedRowSet.TRACE == false) return __result__;
            if (OracleLog.recursiveEnter() == false) return __result__;
            try {}
            catch (Throwable var32_67) {
                var33_52 = null;
                OracleLog.recursiveExit();
                throw var32_67;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_51 = null;
            OracleLog.recursiveExit();
            return __result__;
lbl403:
            // 1 sources

            var31_32 = null;
            if (OracleCachedRowSet.TRACE == false) return __result__;
            if (OracleLog.recursiveEnter() == false) return __result__;
            try {}
            catch (Throwable var32_68) {
                var33_54 = null;
                OracleLog.recursiveExit();
                throw var32_68;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_53 = null;
            OracleLog.recursiveExit();
            return __result__;
lbl418:
            // 1 sources

            var31_33 = null;
            if (OracleCachedRowSet.TRACE == false) return var8_79;
            if (OracleLog.recursiveEnter() == false) return var8_79;
            try {}
            catch (Throwable var32_69) {
                var33_56 = null;
                OracleLog.recursiveExit();
                throw var32_69;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var33_55 = null;
            OracleLog.recursiveExit();
            return var8_79;
            OracleLog.recursiveExit();
            throw var30_110;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        InputStream inputStream;
        try {
            InputStream b2;
            InputStream __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream inputStream2 = __result__ = (b2 = this.getStream(columnIndex)) == null ? null : b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        block25: {
            Object b2;
            block23: {
                InputStream inputStream;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                            inputStream = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if ((b2 = this.getObject(columnIndex)) != null) break block23;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (InputStream)b2);
                            Object var5_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    inputStream = (InputStream)b2;
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var13_17 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var13_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var13_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return inputStream;
            }
            if (!(b2 instanceof String)) break block25;
            StringBufferInputStream __result__ = new StringBufferInputStream((String)b2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_22 = null;
                }
                catch (Throwable throwable) {
                    Object var7_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            StringBufferInputStream stringBufferInputStream = __result__;
            Object var11_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return stringBufferInputStream;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var9_25 = null;
            }
            catch (Throwable throwable) {
                Object var9_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream inputStream;
        try {
            InputStream b2;
            InputStream __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream inputStream2 = __result__ = (b2 = this.getStream(columnIndex)) == null ? null : b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            CharArrayReader charArrayReader;
            InputStream x;
            block25: {
                Object var3_2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                x = this.getAsciiStream(columnIndex);
                if (x != null) break block25;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                var3_2 = null;
                Object var13_12 = null;
                if (!TRACE) return var3_2;
                if (!OracleLog.recursiveEnter()) return var3_2;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_15 = null;
                    OracleLog.recursiveExit();
                    return var3_2;
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                StringBuffer sb = new StringBuffer();
                int i2 = 0;
                while ((i2 = x.read()) != -1) {
                    sb.append((char)i2);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.getCharacterStream(" + columnIndex + "), StringBuffer sb=" + sb);
                        charArrayReader = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                char[] c2 = new char[sb.length()];
                sb.getChars(0, sb.length(), c2, 0);
                CharArrayReader r2 = new CharArrayReader(c2);
                c2 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + r2);
                        Object var9_28 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_29 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                charArrayReader = r2;
            }
            catch (IOException ea) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 322);
                        Object var11_31 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_32 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 322);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var13_13 = null;
            if (!TRACE) return charArrayReader;
            if (!OracleLog.recursiveEnter()) return charArrayReader;
            try {}
            catch (Throwable throwable) {
                Object var15_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_17 = null;
            OracleLog.recursiveExit();
            return charArrayReader;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(String columnName) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object __result__ = this.getObject(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String columnName) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.getBoolean(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(String columnName) throws SQLException {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte __result__ = this.getByte(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            by = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(String columnName) throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short __result__ = this.getShort(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String columnName) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = this.getInt(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String columnName) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long __result__ = this.getLong(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public float getFloat(String columnName) throws SQLException {
        float f2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            float __result__ = this.getFloat(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            f2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String columnName) throws SQLException {
        double d2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            double __result__ = this.getDouble(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            d2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(scale));
                    bigDecimal = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            BigDecimal __result__ = this.getBigDecimal(this.getColumnIndex(columnName), scale);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bigDecimal = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String columnName) throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] __result__ = this.getBytes(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String columnName) throws SQLException {
        Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    date = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Date __result__ = this.getDate(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            date = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String columnName) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    time = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time __result__ = this.getTime(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            time = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(String columnName) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    timestamp = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp __result__ = this.getTimestamp(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            timestamp = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(cal));
                    time = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time __result__ = this.getTime(this.getColumnIndex(columnName), cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            time = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(cal));
                    date = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Date __result__ = this.getDate(this.getColumnIndex(columnName), cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            date = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(String columnName) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream __result__ = this.getAsciiStream(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    inputStream = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            InputStream __result__ = this.getUnicodeStream(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            inputStream = __result__;
            Object var7_9 = null;
            if (!TRACE) return inputStream;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return inputStream;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return inputStream;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String columnName) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String __result__ = this.getString(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(String columnName) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream __result__ = this.getBinaryStream(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(String columnName) throws SQLException {
        Reader reader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    reader = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Reader __result__ = this.getCharacterStream(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            reader = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    bigDecimal = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            BigDecimal __result__ = this.getBigDecimal(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bigDecimal = __result__;
            Object var7_9 = null;
            if (!TRACE) return bigDecimal;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bigDecimal;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(cal));
                    timestamp = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp __result__ = this.getTimestamp(this.getColumnIndex(columnName), cal);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            timestamp = __result__;
            Object var8_10 = null;
            if (!TRACE) return timestamp;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return timestamp;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String colName, Map map) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(colName) + ", " + OracleLog.argument(map));
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object __result__ = this.getObject(this.getColumnIndex(colName), map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(String colName) throws SQLException {
        Ref ref;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(colName));
                    ref = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Ref __result__ = this.getRef(this.getColumnIndex(colName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ref = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(String colName) throws SQLException {
        Blob blob;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(colName));
                    blob = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Blob __result__ = this.getBlob(this.getColumnIndex(colName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            blob = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(String colName) throws SQLException {
        Clob clob;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(colName));
                    clob = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Clob __result__ = this.getClob(this.getColumnIndex(colName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            clob = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return clob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(String colName) throws SQLException {
        Array array;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(colName));
                    array = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Array __result__ = this.getArray(this.getColumnIndex(colName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            array = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, x, (int[])null);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void updateObject(int columnIndex, Object x, int[] typeInfo) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.updateObject(" + columnIndex + ", " + x + "), and insertRowFlag=" + this.insertRowFlag);
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkColumnIndex(columnIndex);
            if (this.insertRowFlag) {
                this.checkAndFilterObject(columnIndex, x);
                this.insertRow.updateObject(columnIndex, x, typeInfo);
            } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSet.updateObject(" + columnIndex + ", " + x + "), isBeforeFirst()=false and isAfterLast()=false");
                        Object var9_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.updateRowFlag = true;
                this.updateRowPosition = this.presentRow;
                this.getCurrentRow().updateObject(columnIndex, x, typeInfo);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var13_17 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_22 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_19 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int columnIndex) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, null);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateCharacterStreamInternal(columnIndex, x, length, false);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateCharacterStreamInternal(int columnIndex, Reader x, int length, boolean isNChar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(isNChar));
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkColumnIndex(columnIndex);
            if (length < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var8_13 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int type = this.getMetaData().getColumnType(columnIndex);
            if (!this.isStreamType(type)) {
                StringBuilder inStr;
                block21: {
                    try {
                        int lengthRemaining;
                        int len = 0;
                        char[] charBuf = new char[1024];
                        inStr = new StringBuilder(1024);
                        for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(charBuf) : x.read(charBuf, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                            inStr.append(charBuf, 0, len);
                        }
                        x.close();
                        if (lengthRemaining != length) break block21;
                        this.updateNull(columnIndex);
                    }
                    catch (IOException e2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                                Object var11_33 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var11_34 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    Object var13_21 = null;
                    if (!TRACE) return;
                    if (!OracleLog.recursiveEnter()) return;
                    try {
                        OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_24 = null;
                        OracleLog.recursiveExit();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var15_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.updateString(columnIndex, inStr.toString());
            }
            int streamType = isNChar ? 4 : 3;
            int[] typeInfo = new int[]{length, streamType};
            this.updateObject(columnIndex, (Object)x, typeInfo);
            Object var13_22 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_29 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_28 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var15_27 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleCachedRowSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var15_26 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateCharacterStream(this.getColumnIndex(columnName), x, length);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateTimestamp(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBinaryStream(this.getColumnIndex(columnName), x, length);
            Object var7_7 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable2) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkColumnIndex(columnIndex);
            if (length < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var7_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int type = this.getMetaData().getColumnType(columnIndex);
            if (!this.isStreamType(type)) {
                ByteArrayOutputStream bstream;
                block21: {
                    try {
                        int lengthRemaining;
                        int len = 0;
                        byte[] rawBytes = new byte[1024];
                        bstream = new ByteArrayOutputStream(1024);
                        for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(rawBytes) : x.read(rawBytes, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                            bstream.write(rawBytes, 0, len);
                        }
                        x.close();
                        if (lengthRemaining != length) break block21;
                        this.updateNull(columnIndex);
                    }
                    catch (IOException e2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                                Object var10_30 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var10_31 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    Object var12_18 = null;
                    if (!TRACE) return;
                    if (!OracleLog.recursiveEnter()) return;
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_21 = null;
                        OracleLog.recursiveExit();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.updateBytes(columnIndex, bstream.toByteArray());
            }
            int[] typeInfo = new int[]{length, 2};
            this.updateObject(columnIndex, (Object)x, typeInfo);
            Object var12_19 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var14_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var14_23 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        block24: {
            block23: {
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                        var5_4 = null;
                    }
                    catch (Throwable var4_8) {
                        var5_5 = null;
                        OracleLog.recursiveExit();
                        throw var4_8;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.checkColumnIndex(columnIndex);
                if (length < 0) {
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            var7_11 = null;
                        }
                        catch (Throwable var6_14) {
                            var7_12 = null;
                            OracleLog.recursiveExit();
                            throw var6_14;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                type = this.getMetaData().getColumnType(columnIndex);
                if (this.isStreamType(type)) break block25;
                len = 0;
                asciiBytes = new byte[1024];
                charBuf = new char[1024];
                inStr = new StringBuilder(1024);
                for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(asciiBytes) : x.read(asciiBytes, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                    DBConversion.asciiBytesToJavaChars(asciiBytes, len, charBuf);
                    inStr.append(charBuf, 0, len);
                }
                x.close();
                if (lengthRemaining != length) break block22;
                this.updateNull(columnIndex);
                var13_19 = null;
                if (!OracleCachedRowSet.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl-1000
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var15_22 = null;
                }
                catch (Throwable var14_28) {
                    var15_23 = null;
                    OracleLog.recursiveExit();
                    throw var14_28;
                }
                OracleLog.recursiveExit();
                {
                }
lbl-1000:
                // 2 sources

                {
                    block25: {
                        block22: {
                            return;
                        }
                        try {
                            this.updateString(columnIndex, inStr.toString());
                            break block23;
                        }
                        catch (IOException e) {
                            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e);
                                    var11_31 = null;
                                }
                                catch (Throwable var10_33) {
                                    var11_32 = null;
                                    OracleLog.recursiveExit();
                                    throw var10_33;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    typeInfo = new int[]{length, 1};
                    this.updateObject(columnIndex, (Object)x, typeInfo);
                }
            }
            var13_20 = null;
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var15_24 = null;
                }
                catch (Throwable var14_29) {
                    var15_25 = null;
                    OracleLog.recursiveExit();
                    throw var14_29;
                }
                OracleLog.recursiveExit();
                {
                    break block24;
                }
            }
            break block24;
            catch (Throwable var12_34) {
                var13_21 = null;
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        var15_26 = null;
                    }
                    catch (Throwable var14_30) {
                        var15_27 = null;
                        OracleLog.recursiveExit();
                        throw var14_30;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw var12_34;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(columnIndex, (Object)new Byte(x));
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var5_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var7_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)Float.valueOf(x));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(columnIndex, (Object)new Timestamp(0, 0, 0, x.getHours(), x.getMinutes(), x.getSeconds(), 0));
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(scale));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!(x instanceof Number)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.updateObject(columnIndex, (Object)new BigDecimal(new BigInteger(((Number)x).toString()), scale));
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(String columnName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateNull(this.getColumnIndex(columnName));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateAsciiStream(this.getColumnIndex(columnName), x, length);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBoolean(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(String columnName, byte x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateByte(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(String columnName, short x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateShort(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(String columnName, int x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateInt(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(String columnName, long x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateLong(this.getColumnIndex(columnName), x);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(String columnName, float x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateFloat(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateDouble(String columnName, double x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateDouble(this.getColumnIndex(columnName), x);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateBigDecimal(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(String columnName, String x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateString(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBytes(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(String columnName, Date x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateDate(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(String columnName, Time x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateTime(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(String columnName, Object x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(scale));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(this.getColumnIndex(columnName), x, scale);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getURL(int columnIndex) throws SQLException {
        try {
            Object u;
            URL uRL;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    uRL = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((u = this.getObject(columnIndex)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (URL)u);
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                uRL = (URL)u;
                Object var15_11 = null;
                if (!TRACE) return uRL;
                if (!OracleLog.recursiveEnter()) return uRL;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_15 = null;
                    OracleLog.recursiveExit();
                    return uRL;
                }
                catch (Throwable throwable) {
                    Object var17_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (u instanceof URL) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (URL)u);
                        Object var7_27 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                uRL = (URL)u;
                Object var15_12 = null;
                if (!TRACE) return uRL;
                if (!OracleLog.recursiveEnter()) return uRL;
                try {}
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_17 = null;
                OracleLog.recursiveExit();
                return uRL;
            }
            if (u instanceof String) {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new URL((String)u));
                            Object var9_30 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_31 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    uRL = new URL((String)u);
                }
                catch (MalformedURLException exc) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 136);
                            Object var11_33 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var11_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Object var15_13 = null;
                if (!TRACE) return uRL;
                if (!OracleLog.recursiveEnter()) return uRL;
                try {}
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_19 = null;
                OracleLog.recursiveExit();
                return uRL;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var13_36 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_22 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public URL getURL(String columnName) throws SQLException {
        URL uRL;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    uRL = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            URL __result__ = this.getURL(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            uRL = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRef(String columnName, Ref x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateRef(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateBlob(String columnName, Blob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBlob(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(String columnName, Clob x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateClob(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(columnIndex, (Object)x);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateArray(String columnName, Array x) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(x));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateArray(this.getColumnIndex(columnName), x);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int[] getKeyColumns() throws SQLException {
        int[] nArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.keyColumns);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            nArray = this.keyColumns;
            Object var6_8 = null;
            if (!TRACE) return nArray;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return nArray;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return nArray;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void setKeyColumns(int[] keyCols) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int colNum = 0;
            if (this.rowsetMetaData != null) {
                colNum = this.rowsetMetaData.getColumnCount();
                if (keyCols == null || keyCols.length > colNum) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 324);
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 324);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            int keyColNum = keyCols.length;
            this.keyColumns = new int[keyColNum];
            for (int i2 = 0; i2 < keyColNum; ++i2) {
                if (keyCols[i2] <= 0 || keyCols[i2] > colNum) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + keyCols[i2]);
                            Object var7_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + keyCols[i2]);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.keyColumns[i2] = keyCols[i2];
            }
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int getPageSize() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.pageSize);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = this.pageSize;
            Object var6_8 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageSize(int pSize) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pSize));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (pSize < 0 || this.maxRows > 0 && pSize > this.maxRows) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 325);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 325);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.pageSize = pSize;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncProvider getSyncProvider() throws SQLException {
        SyncProvider syncProvider;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.syncProvider);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            syncProvider = this.syncProvider;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return syncProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncProvider(String providerName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(providerName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.syncProvider = SyncFactory.getInstance(providerName);
            this.reader = this.syncProvider.getRowSetReader();
            this.writer = this.syncProvider.getRowSetWriter();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableName() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tableName);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = this.tableName;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableName(String tblName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(tblName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.tableName = tblName;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    oracleCachedRowSet = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet ocrs = (OracleCachedRowSet)this.createCopy();
            ocrs.initializeProperties();
            ocrs.listener = new Vector();
            try {
                ocrs.unsetMatchColumn(ocrs.getMatchColumnIndexes());
                ocrs.unsetMatchColumn(ocrs.getMatchColumnNames());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ocrs);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = ocrs;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public CachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    oracleCachedRowSet = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet ocrs = (OracleCachedRowSet)this.createCopy();
            ocrs.rows = null;
            ocrs.rowCount = 0;
            ocrs.currentPage = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ocrs);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = ocrs;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnUpdated(int columnIndex) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 326);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 326);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean __result__ = this.getCurrentRow().isColumnChanged(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnUpdated(String columnName) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.columnUpdated(this.getColumnIndex(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Connection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(conn));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = conn;
            this.execute();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.getConnectionInternal().commit();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.getConnectionInternal().rollback();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback(Savepoint svpt) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(svpt));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Connection localConnection = this.getConnectionInternal();
            boolean autoCommitStatus = localConnection.getAutoCommit();
            try {
                localConnection.setAutoCommit(false);
                localConnection.rollback(svpt);
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                localConnection.setAutoCommit(autoCommitStatus);
                throw throwable;
            }
            localConnection.setAutoCommit(autoCommitStatus);
            Object var7_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oracleRollback(OracleSavepoint svpt) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(svpt));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ((OracleConnection)this.getConnectionInternal()).oracleRollback(svpt);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOriginalRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 327);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 327);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.setOriginalRowInternal(this.presentRow);
            Object var6_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowCount);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.rowCount;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextPage() throws SQLException {
        boolean __result__;
        block29: {
            boolean __ex__3;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 328);
                            Object var4_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rows.size() == 0 && !this.isPopulateDone) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 329);
                            Object var6_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__3 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
                    __ex__3.fillInStackTrace();
                    throw __ex__3;
                }
                if (!this.isExecuteCalled() && !this.isPopulateDone || this.rowCount >= this.pageSize) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var8_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__3 = false;
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_25 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_21 = null;
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return __ex__3;
        }
        if (this.isExecuteCalled()) {
            ++this.currentPage;
            this.execute();
        } else {
            this.populate(this.resultSet);
            ++this.currentPage;
        }
        boolean bl = __result__ = !this.isPopulateDone;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var10_30 = null;
            }
            catch (Throwable throwable) {
                Object var10_31 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl2 = __result__;
        Object var12_19 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_23 = null;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean previousPage() throws SQLException {
        boolean __result__;
        block27: {
            boolean __ex__3;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.resultSet != null && this.resultSet.getType() == 1003) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 328);
                            Object var4_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rows.size() == 0 && !this.isPopulateDone) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 329);
                            Object var6_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__3 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
                    __ex__3.fillInStackTrace();
                    throw __ex__3;
                }
                if (this.currentPage != 0) break block27;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var8_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__3 = false;
                Object var12_18 = null;
                if (!TRACE) return __ex__3;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_25 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return __ex__3;
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_21 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return __ex__3;
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        boolean bl = __result__ = this.currentPage != 0;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var10_30 = null;
            }
            catch (Throwable throwable) {
                Object var10_31 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl2 = __result__;
        Object var12_19 = null;
        if (!TRACE) return bl2;
        if (!OracleLog.recursiveEnter()) return bl2;
        try {
            OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_23 = null;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(event) + ", " + OracleLog.argument(numRows));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (numRows <= 0 || numRows < this.fetchSize) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 330);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 330);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowCount % numRows == 0) {
                this.rowsetEvent = new RowSetEvent(this);
                this.notifyRowSetChanged();
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetWarning getRowSetWarnings() throws SQLException {
        RowSetWarning rowSetWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsetWarning);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rowSetWarning = this.rowsetWarning;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rowSetWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(ResultSet rset, int startRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rset) + ", " + OracleLog.argument(startRow));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (startRow < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 331);
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 331);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (rset == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 332);
                        Object var8_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 332);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int rsetType = rset.getType();
            if (rsetType == 1003) {
                int skipRow;
                boolean readAll = false;
                for (skipRow = 0; skipRow < startRow; ++skipRow) {
                    if (rset.next()) continue;
                    readAll = true;
                    break;
                }
                if (skipRow < startRow && startRow > 0 && readAll) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 333);
                            Object var10_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 333);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else if (startRow == 0) {
                rset.beforeFirst();
            } else {
                rset.absolute(startRow);
            }
            this.populate(rset);
            Object var12_21 = null;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_25 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_23 = null;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoDelete() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cancelRowDelete();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoInsert() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cancelRowInsert();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoUpdate() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cancelRowUpdates();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

