/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance = null;
    protected Hashtable m_connCache = null;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription = false;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    protected static AtomicInteger UNNAMED_CACHE_COUNT;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OracleConnectionCacheManager() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.m_connCache = new Hashtable();
            UNNAMED_CACHE_COUNT = new AtomicInteger();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        OracleConnectionCacheManager oracleConnectionCacheManager;
        try {
            block18: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                        Object var1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var1_1 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (cacheManagerInstance == null) {
                        cacheManagerInstance = new OracleConnectionCacheManager();
                    }
                }
                catch (RuntimeException re) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block18;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_10, "         Event: OracleConnectionCacheManager.getConnectionCacheManagerInstance(): RuntimeException : " + re.getMessage());
                        Object var3_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, "         Return: " + cacheManagerInstance);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnectionCacheManager = cacheManagerInstance;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, "         Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, "         Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnectionCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createCache(OracleDataSource ods, Properties cacheProperties) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(ods) + ", " + OracleLog.argument(cacheProperties));
                    string = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            String connectionCacheName = null;
            if (ods == null || !ods.getConnectionCachingEnabled()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                        Object var6_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            connectionCacheName = ods.connCacheName != null ? ods.connCacheName : ods.dataSourceName + "#0x" + Integer.toHexString(UNNAMED_CACHE_COUNT.getAndIncrement());
            this.createCache(connectionCacheName, ods, cacheProperties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connectionCacheName);
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            string = connectionCacheName;
            Object var10_13 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_15 = null;
            OracleLog.recursiveExit();
            return string;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void createCache(String cacheName, OracleDataSource ods, Properties cacheProperties) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(ods) + ", " + OracleLog.argument(cacheProperties));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (ods == null || !ods.getConnectionCachingEnabled()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                        Object var7_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (cacheName == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 138);
                        Object var9_16 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 138);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.m_connCache.containsKey(cacheName)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 140);
                        Object var11_20 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 140);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean _odsIsFcfEnabled = ods.getFastConnectionFailoverEnabled();
            if (_odsIsFcfEnabled && this.failoverEventHandlerThread == null) {
                final String onsConfigStr = ods.getONSConfiguration();
                if (onsConfigStr != null && !onsConfigStr.equals("")) {
                    OracleConnectionCacheManager oracleConnectionCacheManager = this;
                    // MONITORENTER : oracleConnectionCacheManager
                    if (!isONSInitializedForRemoteSubscription) {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws ONSException {
                                    ONS ons = new ONS(onsConfigStr);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException onsexc) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 175 + onsexc);
                                    Object var13_23 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var13_24 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 175, onsexc);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        isONSInitializedForRemoteSubscription = true;
                    }
                    // MONITOREXIT : oracleConnectionCacheManager
                }
                this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
            }
            OracleImplicitConnectionCache icc = new OracleImplicitConnectionCache(ods, cacheProperties);
            icc.cacheName = cacheName;
            ods.odsCache = icc;
            this.m_connCache.put(cacheName, icc);
            if (_odsIsFcfEnabled) {
                this.checkAndStartThread(this.failoverEventHandlerThread);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var16_26 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var16_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var18_29 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var18_30 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var20_34 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_33 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_31 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var20_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String cacheName, long waitTimeout) throws SQLException {
        try {
            OracleImplicitConnectionCache oicc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(waitTimeout));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(cacheName) : null;
            if (oicc != null) {
                block21: {
                    oicc.disableConnectionCache();
                    if (waitTimeout > 0L) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(waitTimeout * 1000L);
                        }
                        catch (InterruptedException ea) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block21;
                            try {
                                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager." + "removeCache() - Exception Occurred : " + ea.getMessage());
                                Object var7_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                    }
                }
                if (oicc.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                    this.cleanupFCFThreads(oicc);
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            oicc.closeConnectionCache(waitTimeout < 0L ? 32 : 1);
            oicc = null;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeCache(String cacheName, Properties cacheProperties) throws SQLException {
        try {
            OracleImplicitConnectionCache oicc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(cacheProperties));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
            if (oicc == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.disableCache(cacheName);
            oicc.reinitializeCacheConnections(cacheProperties);
            this.enableCache(cacheName);
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsCache(String cacheName) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean __result__ = this.m_connCache.containsKey(cacheName);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = __result__;
            Object var7_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCache(String cacheName) throws SQLException {
        try {
            OracleImplicitConnectionCache oicc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
            if (oicc == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            oicc.enableConnectionCache();
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCache(String cacheName) throws SQLException {
        try {
            OracleImplicitConnectionCache oicc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
            if (oicc == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            oicc.disableConnectionCache();
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void refreshCache(String cacheName, int mode) throws SQLException {
        try {
            block21: {
                SQLException __ex__;
                block20: {
                    OracleImplicitConnectionCache oicc;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(mode));
                            Object var4_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                    if (oicc == null) break block20;
                    switch (mode) {
                        case 4096: 
                        case 8192: {
                            oicc.refreshCacheConnections(mode);
                            break block21;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                                    Object var6_7 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_8 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache(String cacheName, boolean cleanupCheckedOutConnections) throws SQLException {
        try {
            OracleImplicitConnectionCache oicc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(cleanupCheckedOutConnections));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
            if (oicc == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            oicc.purgeCacheConnections(cleanupCheckedOutConnections, 1);
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCacheProperties(String cacheName) throws SQLException {
        block14: {
            Properties properties;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                        properties = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc == null) break block14;
                properties = oicc.getConnectionCacheProperties();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return properties;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                Object var5_14 = null;
            }
            catch (Throwable throwable) {
                Object var5_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCacheNameList() throws SQLException {
        String[] stringArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    stringArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String[] sArray = this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sArray);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            stringArray = sArray;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableConnections(String cacheName) throws SQLException {
        block14: {
            int n2;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc == null) break block14;
                n2 = oicc.cacheSize;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                Object var5_15 = null;
            }
            catch (Throwable throwable) {
                Object var5_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * Exception decompiling
     */
    public int getNumberOfActiveConnections(String cacheName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setConnectionPoolDataSource(String cacheName, ConnectionPoolDataSource ds) throws SQLException {
        try {
            SQLException __ex__;
            OracleImplicitConnectionCache oicc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(ds));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
            if (oicc != null) {
                if (oicc.cacheSize > 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 78);
                            Object var6_7 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 78);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            ((OracleConnectionPoolDataSource)ds).makeURL();
            ((OracleConnectionPoolDataSource)ds).setURL(((OracleConnectionPoolDataSource)ds).url);
            oicc.connectionPoolDS = (OracleConnectionPoolDataSource)ds;
            Object var10_13 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_15 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void verifyAndHandleEvent(int eventType, byte[] eventBody) throws SQLException {
        try {
            StringTokenizer strTokens;
            int cardinality;
            String status;
            String hostNameKey;
            String dbUniqNameKey;
            String instNameKey;
            String svcName;
            block31: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(eventBody));
                        Object var4_3 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                svcName = null;
                instNameKey = null;
                dbUniqNameKey = null;
                hostNameKey = null;
                status = null;
                cardinality = 0;
                strTokens = null;
                try {
                    strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
                }
                catch (UnsupportedEncodingException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block31;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager : verifyAndHandleEvent()" + " - UTF-8 Encoding Exception" + e2.getMessage());
                        Object var12_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                val = null;
                st = strTokens.nextToken();
                if (st.equals("=") && strTokens.hasMoreTokens()) {
                    val = strTokens.nextToken();
                } else {
                    key = st;
                }
                if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 146);
                            Object var14_22 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var14_23 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 146);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (key.equalsIgnoreCase("service") && val != null) {
                    svcName = val;
                }
                if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                    instNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("database") && val != null) {
                    dbUniqNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("host") && val != null) {
                    hostNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("status") && val != null) {
                    status = val;
                }
                if (!key.equalsIgnoreCase("card") || val == null) continue;
                try {
                    cardinality = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    Object var16_21;
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager : verifyAndHandleEvent()" + " - Cardinality value= " + val + " : Error : " + nfe.getMessage());
                        var16_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        var16_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            this.invokeFailoverProcessingThreads(eventType, svcName, instNameKey, dbUniqNameKey, hostNameKey, status, cardinality);
            strTokens = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var18_25 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var18_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var20_28 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var20_29 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var22_33 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var22_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var22_30 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var22_31 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeFailoverProcessingThreads(int eventType, String svcName, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(svcName) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oicc2 = null;
            boolean serviceEvent = false;
            boolean hostEvent = false;
            if (eventType == 256) {
                serviceEvent = true;
            }
            if (eventType == 512) {
                hostEvent = true;
            }
            for (OracleImplicitConnectionCache oicc2 : this.m_connCache.values()) {
                if ((!serviceEvent || !svcName.equalsIgnoreCase(oicc2.dataSourceServiceName)) && !hostEvent) continue;
                OracleFailoverWorkerThread workerTh = new OracleFailoverWorkerThread(oicc2, eventType, instNameKey, dbUniqNameKey, hostNameKey, status, card);
                this.checkAndStartThread(workerTh);
                oicc2.failoverWorkerThread = workerTh;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_23 = null;
            }
            catch (Throwable throwable2) {
                Object var18_24 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var18_21 = null;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkAndStartThread(Thread thr) throws SQLException {
        try {
            block16: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(thr));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (!thr.isAlive()) {
                        thr.setDaemon(true);
                        thr.start();
                    }
                }
                catch (IllegalThreadStateException ie) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block16;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager.checkAndStartThread()" + " - IllegalThreadStateException occurred:" + ie.getMessage());
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable2) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean failoverEnabledCacheExists() {
        block19: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.failoverEnabledCacheCount <= 0) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bl = true;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var10_16 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                Object var6_21 = null;
            }
            catch (Throwable throwable) {
                Object var6_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var8_10 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void parseRuntimeLoadBalancingEvent(String service, byte[] eventBody) throws SQLException {
        try {
            if (OracleConnectionCacheManager.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(service) + ", " + OracleLog.argument(eventBody));
                    var4_3 = null;
                }
                catch (Throwable var3_5) {
                    var4_4 = null;
                    OracleLog.recursiveExit();
                    throw var3_5;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            icc = null;
            iccSet = this.m_connCache.elements();
            while (iccSet.hasMoreElements()) {
                try {
                    icc = (OracleImplicitConnectionCache)iccSet.nextElement();
                    if (!service.equalsIgnoreCase(icc.dataSourceServiceName)) continue;
                    if (eventBody == null) {
                        icc.zapRLBInfo();
                        continue;
                    }
                    this.retrieveServiceMetrics(icc, eventBody);
                }
                catch (Exception e) {
                    if (!OracleConnectionCacheManager.TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleConnectionCacheManager." + "parseRuntimeLoadBalancingEvent():" + e.getMessage());
                        var7_8 = null;
                    }
                    catch (Throwable var6_9) {
                        var7_8 = null;
                        OracleLog.recursiveExit();
                        throw var6_9;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            if (OracleConnectionCacheManager.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    var9_10 = null;
                }
                catch (Throwable var8_12) {
                    var9_11 = null;
                    OracleLog.recursiveExit();
                    throw var8_12;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var11_13 = null;
        }
        catch (Throwable var10_21) {
            var11_14 = null;
            if (OracleConnectionCacheManager.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var13_17 = null;
                }
                catch (Throwable var12_20) {
                    var13_18 = null;
                    OracleLog.recursiveExit();
                    throw var12_20;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw var10_21;
        }
        if (!OracleConnectionCacheManager.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl79
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var13_15 = null;
        }
        catch (Throwable var12_19) {
            var13_16 = null;
            OracleLog.recursiveExit();
            throw var12_19;
        }
        OracleLog.recursiveExit();
lbl79:
        // 2 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveServiceMetrics(OracleImplicitConnectionCache icc, byte[] eventBody) throws SQLException {
        try {
            boolean updateNecessary;
            int flag;
            int percent;
            String dbUniqNameKey;
            String instNameKey;
            StringTokenizer strTokens;
            block35: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(icc) + ", " + OracleLog.argument(eventBody));
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                strTokens = null;
                instNameKey = null;
                dbUniqNameKey = null;
                percent = 0;
                flag = 0;
                updateNecessary = false;
                try {
                    strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
                }
                catch (UnsupportedEncodingException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block35;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager : retrieveServiceMetrics" + "() - (RLB)UTF-8 Encoding Exception:" + e2.getMessage());
                        Object var11_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                block36: {
                    val = null;
                    st = strTokens.nextToken();
                    if (st.equals("=") && strTokens.hasMoreTokens()) {
                        val = strTokens.nextToken();
                    } else {
                        if (st.equals("}")) {
                            if (!updateNecessary) continue;
                            icc.updateDatabaseInstance(dbUniqNameKey, instNameKey, percent, flag);
                            updateNecessary = false;
                            continue;
                        }
                        if (st.equals("{") || st.equals(" ")) continue;
                        key = st;
                        updateNecessary = true;
                    }
                    if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 146);
                                Object var13_21 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_22 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 146);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (key.equalsIgnoreCase("database") && val != null) {
                        dbUniqNameKey = val.toLowerCase().intern();
                    }
                    if (key.equalsIgnoreCase("instance") && val != null) {
                        instNameKey = val.toLowerCase().intern();
                    }
                    if (key.equalsIgnoreCase("percent") && val != null) {
                        try {
                            percent = Integer.parseInt(val);
                            if (percent == 0) {
                                percent = 1;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            Object var15_20;
                            if (!TRACE || !OracleLog.recursiveEnter()) break block36;
                            try {
                                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleConnectionCacheManager.retrieveServiceMetrics" + "() - Exception occurred : (RLB)percent value= " + val + nfe.getMessage());
                                var15_20 = null;
                            }
                            catch (Throwable throwable) {
                                var15_20 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                    }
                }
                if (!key.equalsIgnoreCase("flag") || val == null) continue;
                if (val.equalsIgnoreCase("good")) {
                    flag = 1;
                    continue;
                }
                if (val.equalsIgnoreCase("violating")) {
                    flag = 3;
                    continue;
                }
                if (val.equalsIgnoreCase("NO_DATA")) {
                    flag = 4;
                    continue;
                }
                if (val.equalsIgnoreCase("UNKNOWN")) {
                    flag = 2;
                    continue;
                }
                if (!val.equalsIgnoreCase("BLOCKED")) continue;
                flag = 5;
            }
            icc.processDatabaseInstances();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var17_24 = null;
                }
                catch (Throwable throwable) {
                    Object var17_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var19_27 = null;
        }
        catch (Throwable throwable) {
            Object var19_28 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_31 = null;
            }
            catch (Throwable throwable2) {
                Object var21_32 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var21_29 = null;
        }
        catch (Throwable throwable) {
            Object var21_30 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cleanupFCFThreads(OracleImplicitConnectionCache oicc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cleanupFCFWorkerThread(oicc);
            oicc.cleanupRLBThreads();
            if (this.failoverEnabledCacheCount <= 0) {
                this.cleanupFCFEventHandlerThread();
            }
            --this.failoverEnabledCacheCount;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oicc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oicc));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (oicc.failoverWorkerThread != null) {
                block17: {
                    try {
                        if (oicc.failoverWorkerThread.isAlive()) {
                            oicc.failoverWorkerThread.join();
                        }
                    }
                    catch (InterruptedException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                        try {
                            OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager.cleanupFCFWorkerThread(" + ") - Exception occurred:" + e2.getMessage());
                            Object var5_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                }
                oicc.failoverWorkerThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable2) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void cleanupFCFEventHandlerThread() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.failoverEventHandlerThread != null) {
                block16: {
                    try {
                        this.failoverEventHandlerThread.interrupt();
                    }
                    catch (Exception e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block16;
                        try {
                            OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager.cleanupFCFEventHandlerThread" + "() - Exception occurred:" + e2.getMessage());
                            Object var4_5 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                this.failoverEventHandlerThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean isFatalConnectionError(SQLException se) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(se));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean retCode = false;
            int errCode = se.getErrorCode();
            if (errCode == 3113 || errCode == 3114 || errCode == 1033 || errCode == 1034 || errCode == 1089 || errCode == 1090 || errCode == 17002) {
                retCode = true;
            }
            if (!retCode && this.fatalErrorCodes != null) {
                for (int i2 = 0; i2 < this.fatalErrorCodes.length; ++i2) {
                    if (errCode != this.fatalErrorCodes[i2]) continue;
                    retCode = true;
                    break;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retCode);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = retCode;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setConnectionErrorCodes(int[] fatalErrorCodes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(fatalErrorCodes));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (fatalErrorCodes != null) {
                this.fatalErrorCodes = fatalErrorCodes;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getConnectionErrorCodes() throws SQLException {
        int[] nArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fatalErrorCodes);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            nArray = this.fatalErrorCodes;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Map getStatistics(String cacheName) throws SQLException {
        Map map;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Map map2 = null;
            OracleImplicitConnectionCache icc = null;
            if (this.m_connCache != null && (icc = (OracleImplicitConnectionCache)this.m_connCache.get(cacheName)) != null) {
                map2 = icc.getStatistics();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + map2);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            map = map2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

