/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ROWID;

class NTFDCNRowChanges
implements RowChangeDescription {
    RowChangeDescription.RowOperation opcode;
    int rowidLength;
    byte[] rowid;
    ROWID rowidObj;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNRowChanges(RowChangeDescription.RowOperation _opcode, int _rowidLength, byte[] _rowid) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)_opcode) + ", " + OracleLog.argument(_rowidLength) + ", " + OracleLog.argument(_rowid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.opcode = _opcode;
            this.rowidLength = _rowidLength;
            this.rowid = _rowid;
            this.rowidObj = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getRowid() {
        ROWID rOWID;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowidObj == null) {
                this.rowidObj = new ROWID(this.rowid);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowidObj);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rOWID = this.rowidObj;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNRowChanges.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rOWID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowChangeDescription.RowOperation getRowOperation() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.opcode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RowChangeDescription.RowOperation rowOperation = this.opcode;
            return rowOperation;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("      ROW:  operation=" + (Object)((Object)this.getRowOperation()) + ", ROWID=" + new String(this.rowid) + "\n");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNRowChanges.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNRowChanges"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

