/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ANYDATA;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

class AQMessageI
implements AQMessage {
    private byte[] id = null;
    private AQMessagePropertiesI properties = null;
    private byte[] toid = null;
    private byte[] payload;
    private STRUCT payLoadSTRUCT;
    private ANYDATA payLoadANYDATA;
    private RAW payLoadRAW;
    private XMLType payLoadXMLType;
    private Connection conn;
    private String typeName;
    private TypeDescriptor sd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQMessageI(AQMessagePropertiesI _prop, Connection _conn) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_prop) + ", " + OracleLog.argument(_conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.properties = _prop;
            this.conn = _conn;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQMessageI(AQMessagePropertiesI prop) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.properties = prop;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTypeName(String _typeName) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.typeName = _typeName;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTypeDescriptor(TypeDescriptor _sd) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_sd));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sd = _sd;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMessageId() {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.id);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = this.id;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMessageId(byte[] _id) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_id));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.id = _id;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQMessageProperties getMessageProperties() {
        AQMessagePropertiesI aQMessagePropertiesI;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.properties);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aQMessagePropertiesI = this.properties;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aQMessagePropertiesI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQMessagePropertiesI getMessagePropertiesI() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.properties);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AQMessagePropertiesI aQMessagePropertiesI = this.properties;
            return aQMessagePropertiesI;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(byte[] _payload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_payload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = _payload;
            this.toid = TypeDescriptor.RAWTOID;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(byte[] _payload, byte[] _toid) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_payload) + ", " + OracleLog.argument(_toid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = _payload;
            this.toid = _toid;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(STRUCT _payload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_payload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = _payload.toBytes();
            this.payLoadSTRUCT = _payload;
            this.toid = _payload.getDescriptor().getOracleTypeADT().getTOID();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(ANYDATA _payload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_payload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = _payload.toDatum(this.conn).shareBytes();
            this.payLoadANYDATA = _payload;
            this.toid = TypeDescriptor.ANYDATATOID;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(RAW _payload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_payload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = _payload.shareBytes();
            this.payLoadRAW = _payload;
            this.toid = TypeDescriptor.RAWTOID;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(XMLType _payload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_payload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = _payload.toBytes();
            this.payLoadXMLType = _payload;
            this.toid = TypeDescriptor.XMLTYPETOID;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPayload() {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.payload);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = this.payload;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAWPayload() throws SQLException {
        RAW rAW;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW ret = null;
            if (this.payLoadRAW != null) {
                ret = this.payLoadRAW;
            } else if (this.isRAWPayload()) {
                ret = this.payLoadRAW = new RAW(this.payload);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rAW = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rAW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRAWPayload() throws SQLException {
        block34: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.toid == null || this.toid.length != 16) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (!AQMessageI.compareToid(this.toid, TypeDescriptor.RAWTOID)) break block34;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = false;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCTPayload() throws SQLException {
        STRUCT sTRUCT;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT ret = null;
            if (!this.isSTRUCTPayload()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.payLoadSTRUCT != null) {
                ret = this.payLoadSTRUCT;
            } else {
                if (this.sd == null) {
                    this.typeName = OracleTypeADT.toid2typename(this.conn, this.toid);
                    this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)this.conn);
                }
                if (this.sd instanceof StructDescriptor) {
                    this.payLoadSTRUCT = ret = new STRUCT((StructDescriptor)this.sd, this.payload, this.conn);
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sTRUCT = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSTRUCTPayload() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.toid == null || this.toid.length != 16) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean isObjectPayload = true;
            boolean allzero = true;
            for (int i2 = 0; i2 < 15; ++i2) {
                if (this.toid[i2] == 0) continue;
                allzero = false;
                break;
            }
            if (allzero || this.isRAWPayload() || this.isANYDATAPayload()) {
                isObjectPayload = false;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + isObjectPayload);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = isObjectPayload;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANYDATA getANYDATAPayload() throws SQLException {
        ANYDATA aNYDATA;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ANYDATA ret = null;
            if (this.payLoadANYDATA != null) {
                ret = this.payLoadANYDATA;
            } else if (this.isANYDATAPayload()) {
                OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
                OPAQUE opq = new OPAQUE(desc, this.payload, this.conn);
                ret = this.payLoadANYDATA = new ANYDATA(opq);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aNYDATA = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aNYDATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isANYDATAPayload() throws SQLException {
        block34: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.toid == null || this.toid.length != 16) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if ((this.typeName == null || !this.typeName.equals("SYS.ANYDATA")) && !AQMessageI.compareToid(this.toid, TypeDescriptor.ANYDATATOID)) break block34;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = false;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLType getXMLTypePayload() throws SQLException {
        XMLType xMLType;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XMLType ret = null;
            if (this.payLoadXMLType != null) {
                ret = this.payLoadXMLType;
            } else if (this.isXMLTypePayload()) {
                OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
                OPAQUE opq = new OPAQUE(desc, this.payload, this.conn);
                ret = this.payLoadXMLType = XMLType.createXML((OPAQUE)opq);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            xMLType = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return xMLType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLTypePayload() throws SQLException {
        block34: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.toid == null || this.toid.length != 16) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if ((this.typeName == null || !this.typeName.equals("SYS.XMLTYPE")) && !AQMessageI.compareToid(this.toid, TypeDescriptor.XMLTYPETOID)) break block34;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = false;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPayloadTOID() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.toid);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.toid;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean compareToid(byte[] toid, byte[] toid2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(toid) + ", " + OracleLog.argument(toid2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean ret = false;
            if (toid != null) {
                if (toid == toid2) {
                    ret = true;
                } else if (toid.length == toid2.length) {
                    boolean identical = true;
                    for (int i2 = 0; i2 < toid.length; ++i2) {
                        if (toid[i2] == toid2[i2]) continue;
                        identical = false;
                        break;
                    }
                    if (identical) {
                        ret = true;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Message Properties={");
            sb.append(this.properties);
            sb.append("} ");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQMessageI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.AQMessageI"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

