/*
 * Decompiled with CFR 0.152.
 */
package com.pietjonas.wmfwriter2d;

import com.pietjonas.wmfwriter2d.WMF;
import com.pietjonas.wmfwriter2d.WMFGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WMFGraphics2D
extends Graphics2D {
    BufferedImage img;
    WMFGraphics wmfg;
    Graphics2D g2D;
    AffineTransform trans;
    Stroke stroke;
    Paint paint;
    Color color;
    Shape deviceclip;
    boolean gdifontdrawing = true;
    boolean gdipendrawing = true;
    boolean gdipenwidthdrawing = true;
    double flatness = 0.1;

    public WMFGraphics2D(WMF wmf, int width, int height) {
        this(wmf, width, height, Color.black, Color.white);
    }

    public WMFGraphics2D(WMF wmf, int width, int height, Color foreground, Color background) {
        if (foreground == null) {
            foreground = Color.black;
        }
        if (background == null) {
            background = Color.white;
        }
        this.wmfg = new WMFGraphics(wmf, width, height, foreground, background);
        this.img = new BufferedImage(1, 1, 2);
        this.g2D = (Graphics2D)this.img.getGraphics();
        this.trans = new AffineTransform();
        this.stroke = this.g2D.getStroke();
        this.paint = foreground;
        this.color = foreground;
        this.deviceclip = null;
    }

    WMFGraphics2D(WMFGraphics2D g) {
        this.wmfg = (WMFGraphics)g.wmfg.create();
        this.trans = (AffineTransform)g.trans.clone();
        this.stroke = g.stroke;
        this.paint = g.paint;
        this.color = g.color;
        this.deviceclip = g.deviceclip;
        this.img = new BufferedImage(g.img.getWidth(), g.img.getHeight(), 2);
        this.flatness = g.flatness;
        this.gdifontdrawing = g.gdifontdrawing;
        this.gdipendrawing = g.gdipendrawing;
        this.gdipenwidthdrawing = g.gdipenwidthdrawing;
        this.g2D = (Graphics2D)g.img.getGraphics();
    }

    public void setGDIFontDrawing(boolean gdifontdrawing) {
        this.gdifontdrawing = gdifontdrawing;
    }

    public boolean isGDIFontDrawing() {
        return this.gdifontdrawing;
    }

    public void setGDIPenDrawing(boolean gdipendrawing) {
        this.gdipendrawing = gdipendrawing;
    }

    public boolean isGDIPenDrawing() {
        return this.gdipendrawing;
    }

    public void setGDIPenWidthDrawing(boolean gdipenwidthdrawing) {
        this.gdipenwidthdrawing = gdipenwidthdrawing;
    }

    public boolean isGDIPenWidthDrawing() {
        return this.gdipenwidthdrawing;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public RenderingHints getRenderingHints() {
        return this.g2D.getRenderingHints();
    }

    public Graphics create() {
        WMFGraphics2D g = new WMFGraphics2D(this);
        return g;
    }

    public Font getFont() {
        return this.wmfg.getFont();
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void clip(Shape s) {
        if (this.deviceclip != null) {
            Area area = new Area(this.getClip());
            if (s != null) {
                area.intersect(new Area(s));
            }
            s = area;
        }
        this.setClip(s);
    }

    public void setPaintMode() {
        this.wmfg.setPaintMode();
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.g2D.setTransform(this.trans);
        this.g2D.setStroke(this.getStroke());
        this.g2D.setClip(this.getClip());
        return this.g2D.hit(rect, s, onStroke);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        Shape s = this.trans.createTransformedShape(bounds);
        Rectangle r = s.getBounds();
        Image transedimg = this.transformImage(image, bounds, r, observer, bgcolor);
        this.wmfg.setClip(null);
        this.wmfg.drawImage(transedimg, r.x, r.y, r.width, r.height, observer);
        return true;
    }

    public FontRenderContext getFontRenderContext() {
        this.g2D.setTransform(this.trans);
        return this.g2D.getFontRenderContext();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2D.getDeviceConfiguration();
    }

    public Color getColor() {
        return this.color;
    }

    public Composite getComposite() {
        return this.g2D.getComposite();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        BufferedImage bimg = new BufferedImage(image.getColorModel(), image.getData().createCompatibleWritableRaster(), false, null);
        bimg.setData(image.getData());
        this.drawImage(bimg, xform, null);
    }

    public void setClip(Shape clip) {
        this.deviceclip = this.trans.createTransformedShape(clip);
    }

    public void setTransform(AffineTransform Tx) {
        this.trans = (AffineTransform)Tx.clone();
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void setBackground(Color color) {
        this.wmfg.background = color;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void fillPolygon(int[] xpoints, int[] ypoints, int npoints) {
        this.fill(new Polygon(xpoints, ypoints, npoints));
    }

    public void setRenderingHint(RenderingHints.Key key, Object hintValue) {
        this.g2D.setRenderingHint(key, hintValue);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int[] p = new int[]{dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2};
        Rectangle bounds = new Line2D.Float(dx1, dy1, dx2, dy2).getBounds();
        Shape s = this.trans.createTransformedShape(bounds);
        Rectangle r = s.getBounds();
        Image transedimg = this.transformImage(image, p, r, observer, bgcolor);
        this.wmfg.setClip(null);
        this.wmfg.drawImage(transedimg, r.x, r.y, r.width, r.height, observer);
        return true;
    }

    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    public void setFont(Font font) {
        this.wmfg.setFont(font);
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.color = (Color)paint;
            }
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g2D.copyArea(x, y, width, height, dx, dy);
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    public void drawPolygon(int[] xpoints, int[] ypoints, int npoints) {
        this.draw(new Polygon(xpoints, ypoints, npoints));
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawPolyline(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xpoints[0], ypoints[0]);
            for (int i = 1; i < npoints; ++i) {
                path.lineTo(xpoints[i], ypoints[i]);
            }
            this.draw(path);
        }
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new GeneralPath(new Line2D.Float(x1, y1, x2, y2)));
    }

    public void drawRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.draw(rect);
    }

    public void dispose() {
        this.wmfg.dispose();
        this.g2D.dispose();
        this.img.flush();
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        this.drawRenderedImage(image.createDefaultRendering(), xform);
    }

    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(image, x, y, image.getWidth(observer), image.getHeight(observer), bgcolor, observer);
    }

    public void rotate(double theta, double x, double y) {
        this.trans.rotate(theta, x, y);
    }

    public void transform(AffineTransform Tx) {
        this.trans.concatenate(Tx);
    }

    public void clearRect(int x, int y, int width, int height) {
        Paint oldpaint = this.paint;
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(oldpaint);
    }

    public void setColor(Color c) {
        this.setPaint(c);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g2D.getRenderingHint(key);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(image, x, y, width, height, null, observer);
    }

    public void setRenderingHints(Map hints) {
        this.g2D.setRenderingHints(hints);
    }

    public void translate(int x, int y) {
        this.trans.translate(x, y);
    }

    public void setXORMode(Color color) {
        this.wmfg.setXORMode(color);
    }

    public Rectangle getClipBounds() {
        if (this.deviceclip != null) {
            return this.getClip().getBounds();
        }
        return null;
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        Paint oldpaint = this.getPaint();
        this.setColor(this.getColor());
        this.fill(layout.getOutline(AffineTransform.getTranslateInstance(x, y)));
        this.setPaint(oldpaint);
    }

    public void addRenderingHints(Map hints) {
        this.g2D.addRenderingHints(hints);
    }

    public Color getBackground() {
        return this.wmfg.background;
    }

    public void translate(double tx, double ty) {
        this.trans.translate(tx, ty);
    }

    public void fill(Shape s) {
        this.doFilling(s, false);
    }

    void doFilling(Shape s, boolean draw) {
        this.wmfg.setClip(null);
        Area clipped = new Area(this.trans.createTransformedShape(s));
        if (this.deviceclip != null) {
            clipped.intersect(new Area(this.deviceclip));
        }
        if (!(this.getPaint() instanceof Color)) {
            Rectangle devicebounds = clipped.getBounds();
            if (devicebounds.width == 0 || devicebounds.height == 0) {
                return;
            }
            PaintContext pc = this.paint.createContext(this.img.getColorModel(), devicebounds, s.getBounds(), this.trans, this.getRenderingHints());
            Raster r = pc.getRaster(devicebounds.x, devicebounds.y, devicebounds.width, devicebounds.height);
            BufferedImage bimg = new BufferedImage(pc.getColorModel(), r.createCompatibleWritableRaster(), false, null);
            bimg.setData(r);
            BufferedImage pattern = new BufferedImage(devicebounds.width, devicebounds.height, 2);
            Graphics2D g = (Graphics2D)pattern.getGraphics();
            g.addRenderingHints(this.getRenderingHints());
            g.setTransform(AffineTransform.getTranslateInstance(-devicebounds.x, -devicebounds.y));
            g.setClip(clipped);
            g.drawImage((Image)bimg, devicebounds.x, devicebounds.y, null);
            this.wmfg.drawImage(pattern, devicebounds.x, devicebounds.y, devicebounds.width, devicebounds.height, null);
            return;
        }
        AffineTransform trans1 = new AffineTransform();
        PathIterator path = clipped.getPathIterator(trans1, this.flatness);
        if (path.getWindingRule() == 0) {
            this.wmfg.wmf.setPolyFillMode(1);
        } else {
            this.wmfg.wmf.setPolyFillMode(2);
        }
        int penstyle = this.wmfg.getPenStyle();
        this.wmfg.setPenStyle(5);
        this.wmfg.setColor(this.getColor());
        float[] p = new float[6];
        Vector<Polygon> polys = new Vector<Polygon>();
        Polygon poly = null;
        while (!path.isDone()) {
            int style = path.currentSegment(p);
            switch (style) {
                case 0: {
                    if (poly != null) {
                        polys.add(poly);
                    }
                    poly = new Polygon();
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    break;
                }
                case 3: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[2] + 0.5), (int)((double)p[3] + 0.5));
                    break;
                }
                case 2: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[4] + 0.5), (int)((double)p[5] + 0.5));
                    break;
                }
                case 1: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    break;
                }
                case 4: {
                    if (poly == null) break;
                    polys.add(poly);
                    poly = null;
                }
            }
            path.next();
        }
        if (poly != null) {
            polys.add(poly);
        }
        Polygon[] polyarray = new Polygon[polys.size()];
        int i = 0;
        Iterator it = polys.iterator();
        while (it.hasNext()) {
            polyarray[i] = (Polygon)it.next();
            ++i;
        }
        boolean nopolypoly = false;
        if (s instanceof Arc2D) {
            nopolypoly = true;
        }
        if (!nopolypoly) {
            this.wmfg.GDIPolyPolygon(polyarray);
        } else {
            for (i = 0; i < polyarray.length; ++i) {
                this.wmfg.fillPolygon(polyarray[i]);
            }
        }
        this.wmfg.setPenStyle(penstyle);
    }

    public Shape getClip() {
        try {
            return this.trans.createInverse().createTransformedShape(this.deviceclip);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        return this.drawImage(image, x, y, image.getWidth(observer), image.getHeight(observer), observer);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    public void setComposite(Composite comp) {
        this.g2D.setComposite(comp);
    }

    public void scale(double sx, double sy) {
        this.trans.scale(sx, sy);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.wmfg.getFontMetrics(f);
    }

    public boolean drawImage(Image image, AffineTransform xform, ImageObserver obs) {
        AffineTransform oldtrans = (AffineTransform)this.trans.clone();
        this.trans.concatenate(xform);
        this.drawImage(image, 0, 0, obs);
        this.trans = oldtrans;
        return true;
    }

    public void rotate(double theta) {
        this.trans.rotate(theta);
    }

    public void draw(Shape s) {
        boolean fill = true;
        if (this.gdipendrawing && this.getPaint() instanceof Color && this.stroke instanceof BasicStroke && (((BasicStroke)this.stroke).getDashArray() == null || ((BasicStroke)this.stroke).getDashArray().length == 0)) {
            fill = this.doDrawing(s, (int)((BasicStroke)this.stroke).getLineWidth());
        }
        if (fill) {
            s = this.stroke.createStrokedShape(s);
            this.doFilling(s, true);
        }
    }

    boolean doDrawing(Shape s, int linewidth) {
        Area clipped;
        boolean result = false;
        s = this.trans.createTransformedShape(s);
        if (this.deviceclip != null && !(clipped = new Area(this.deviceclip)).contains(s.getBounds())) {
            return true;
        }
        AffineTransform trans1 = new AffineTransform();
        PathIterator path = s.getPathIterator(trans1, this.flatness);
        float[] p = new float[6];
        Vector<Polygon> polys = new Vector<Polygon>();
        Polygon poly = null;
        float[] startp = new float[6];
        while (!path.isDone()) {
            int style = path.currentSegment(p);
            switch (style) {
                case 0: {
                    if (poly != null) {
                        polys.add(poly);
                    }
                    poly = new Polygon();
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    System.arraycopy(p, 0, startp, 0, p.length);
                    break;
                }
                case 3: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[2] + 0.5), (int)((double)p[3] + 0.5));
                    break;
                }
                case 2: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[4] + 0.5), (int)((double)p[5] + 0.5));
                    break;
                }
                case 1: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    break;
                }
                case 4: {
                    if (poly == null) break;
                    poly.addPoint((int)startp[0], (int)startp[1]);
                    polys.add(poly);
                    poly = null;
                }
            }
            path.next();
        }
        if (poly != null) {
            polys.add(poly);
        }
        Polygon[] polyarray = new Polygon[polys.size()];
        int i = 0;
        Iterator it = polys.iterator();
        while (it.hasNext()) {
            polyarray[i] = (Polygon)it.next();
            ++i;
        }
        int penstyle = this.wmfg.getPenStyle();
        int brush = this.wmfg.getBrushFillStyle();
        this.wmfg.setClip(null);
        this.wmfg.setColor(this.getColor());
        this.wmfg.setPenStyle(0);
        if (this.gdipenwidthdrawing) {
            this.wmfg.setPenWidth(linewidth);
        } else {
            this.wmfg.setPenWidth(0);
        }
        this.wmfg.setGDIHollowBrush();
        for (i = 0; i < polyarray.length; ++i) {
            this.wmfg.drawPolyline(polyarray[i].xpoints, polyarray[i].ypoints, polyarray[i].npoints);
        }
        this.wmfg.setBrushFillStyle(brush);
        this.wmfg.setPenStyle(penstyle);
        return result;
    }

    public void drawString(String s, float x, float y) {
        if (this.isGDIFontDrawing() && this.getPaint() instanceof Color) {
            boolean noclip;
            boolean bl = noclip = this.deviceclip == null;
            if (!noclip) {
                GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), s);
                Rectangle2D outline = gv.getOutline(x, y).getBounds2D();
                noclip = this.deviceclip.contains(this.trans.createTransformedShape(outline).getBounds2D());
            }
            if (noclip) {
                boolean savetrans = this.trans.isIdentity() && this.getFont().getTransform().isIdentity();
                double scale = 1.0;
                double angle = 0.0;
                if (!savetrans) {
                    AffineTransform alltrans = this.getFont().getTransform();
                    alltrans.preConcatenate(this.trans);
                    scale = alltrans.getScaleX();
                    boolean bl2 = savetrans = alltrans.getShearX() == -alltrans.getShearY() && alltrans.getScaleX() == alltrans.getScaleY();
                    if (savetrans && (alltrans.getShearX() != 0.0 || alltrans.getScaleX() < 0.0)) {
                        scale = Math.sqrt(alltrans.getScaleX() * alltrans.getScaleX() + alltrans.getShearX() * alltrans.getShearX());
                        angle = Math.acos(alltrans.getScaleX() / scale);
                        if (alltrans.getShearX() > 0.0) {
                            angle = -angle;
                        }
                    }
                }
                if (savetrans) {
                    boolean savefonttrans = true;
                    if (!savefonttrans) {
                        // empty if block
                    }
                    if (savefonttrans) {
                        this.wmfg.setColor(this.getColor());
                        float size = (float)((double)this.getFont().getSize2D() * scale);
                        Font oldfont = this.getFont();
                        this.wmfg.setFont(this.getFont().deriveFont(size));
                        if (angle != 0.0) {
                            this.wmfg.setFontEscapement((int)(-angle * 1800.0 / Math.PI));
                        }
                        Point2D.Double p = new Point2D.Double((double)x + this.getFont().getTransform().getTranslateX(), (double)y + this.getFont().getTransform().getTranslateY());
                        this.trans.transform(p, p);
                        this.wmfg.drawString(s, (int)((Point2D)p).getX(), (int)((Point2D)p).getY());
                        if (angle != 0.0) {
                            this.wmfg.setFontEscapement(0);
                        }
                        this.wmfg.setFont(oldfont);
                        return;
                    }
                }
            }
        }
        this.drawGlyphVector(this.getFont().createGlyphVector(this.getFontRenderContext(), s), x, y);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.trans.clone();
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(image, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    public void shear(double shx, double shy) {
        this.trans.shear(shx, shy);
    }

    Image transformImage(Image image, Rectangle bounds, Rectangle shape, ImageObserver obs, Color background) {
        if (this.trans.isIdentity() && this.getClip() == null && background == null) {
            return image;
        }
        if (this.deviceclip != null) {
            Area clipped = new Area(this.deviceclip);
            clipped.intersect(new Area(this.trans.createTransformedShape(bounds)));
            shape.setBounds(clipped.getBounds());
        }
        if (shape.width == 0 || shape.height == 0) {
            return image;
        }
        BufferedImage result = new BufferedImage(shape.width, shape.height, 2);
        Graphics2D gresult = (Graphics2D)result.getGraphics();
        gresult.addRenderingHints(this.getRenderingHints());
        gresult.translate(-shape.x, -shape.y);
        gresult.transform((AffineTransform)this.getTransform().clone());
        gresult.setClip(this.getClip());
        if (background != null) {
            gresult.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, background, obs);
        } else {
            gresult.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, obs);
        }
        gresult.dispose();
        return result;
    }

    Image transformImage(Image image, int[] points, Rectangle shape, ImageObserver obs, Color background) {
        BufferedImage result = new BufferedImage(shape.width, shape.height, 2);
        Graphics2D gresult = (Graphics2D)result.getGraphics();
        gresult.addRenderingHints(this.getRenderingHints());
        gresult.translate(-shape.x, -shape.y);
        gresult.transform((AffineTransform)this.getTransform().clone());
        gresult.setClip(this.getClip());
        if (background != null) {
            gresult.drawImage(image, points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7], background, obs);
        } else {
            gresult.drawImage(image, points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7], obs);
        }
        return result;
    }
}

