/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.AverageEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ConnectedLineEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitExponential;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitGeometric;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitHyperbolic;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitLinear;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitLogQuadratic;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitLogarithmic;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitModExponential;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitModHyperbolic;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitPolynomial;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitQuadratic;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.FitRational;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.MovingAverageEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.SVDEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.StdDevEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineProperties;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineType;

public final class TrendlineEngineFactory {
    private TrendlineEngineFactory() {
    }

    public static ITrendlineEngine getTrendlineEngine(TrendlineType type, TrendlineProperties seriesOptions) {
        switch (type) {
            case FIT_NONE: {
                assert (false);
                break;
            }
            case FIT_MEAN: {
                return new AverageEngine();
            }
            case FIT_STDDEV: {
                return new StdDevEngine();
            }
            case FIT_CONNECTED: {
                return new ConnectedLineEngine();
            }
            case FIT_SMOOTH: {
                return null;
            }
            case FIT_MOVINGAVG: {
                return new MovingAverageEngine(seriesOptions.movingAvgOrder, seriesOptions.isSciMovingAvg);
            }
            case FIT_LINEAR: {
                return new SVDEngine(new FitLinear());
            }
            case FIT_EXPONENTIAL: {
                return new SVDEngine(new FitExponential());
            }
            case FIT_GEOMETRIC: {
                return new SVDEngine(new FitGeometric());
            }
            case FIT_HYPERBOLIC: {
                return new SVDEngine(new FitHyperbolic());
            }
            case FIT_LOGARITHMIC: {
                return new SVDEngine(new FitLogarithmic());
            }
            case FIT_LOGQUADRATIC: {
                return new SVDEngine(new FitLogQuadratic());
            }
            case FIT_MODEXPONENTIAL: {
                return new SVDEngine(new FitModExponential());
            }
            case FIT_MODHYPERBOLIC: {
                return new SVDEngine(new FitModHyperbolic());
            }
            case FIT_POLYNOMIAL: {
                return new SVDEngine(new FitPolynomial(seriesOptions.polynomialOrder));
            }
            case FIT_QUADRATIC: {
                return new SVDEngine(new FitQuadratic());
            }
            case FIT_RATIONAL: {
                return new SVDEngine(new FitRational());
            }
        }
        return null;
    }
}

