/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Bar2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Depth2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.FrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import java.awt.Rectangle;

public abstract class JChart_2D
extends JChart_Base {
    private FrameObj m_Frame;
    Rectangle m_rClip;
    int m_nBaseType;
    int[] m_axisAssignments;
    int m_nDepthAngle;
    int m_nDepthRadius;
    Bar2D m_bar2D = null;
    Depth2D m_depth2D;

    JChart_2D(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        super.calc();
        Rectangle rClip = null;
        this.m_Frame = this.createFrame();
        if (this.m_Frame != null) {
            this.m_Frame.calc();
        }
        this.m_depth2D = new Depth2D(this.m_Perspective, this.m_Frame, this.m_nTotalSeries);
        this.m_depth2D.calc();
        if (this.m_Frame != null) {
            rClip = this.m_Perspective.getFrameRect(false);
        }
        this.m_rClip = rClip != null && !rClip.isEmpty() ? rClip : null;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_nDepthRadius = this.m_Perspective.getDepthRadius();
        this.m_nDepthAngle = this.m_Perspective.getDepthAngle();
        this.m_nBaseType = this.m_gt.getRiserType();
        this.m_axisAssignments = new int[this.m_nTotalSeries];
        if (this.m_gt.isDualY() || this.m_gt.isMultiY()) {
            for (int s = 0; s < this.m_nTotalSeries; ++s) {
                this.m_axisAssignments[s] = this.m_Perspective.getAxisAssignment(s);
            }
        } else {
            for (int s = 0; s < this.m_nTotalSeries; ++s) {
                this.m_axisAssignments[s] = 0;
            }
        }
    }

    protected int getSeriesTypes(int s) {
        return this.m_depth2D.getSeriesType(s);
    }

    FrameObj createFrame() {
        return new FrameObj(this.m_Perspective);
    }

    public int getAxisAssignment(int s) {
        return this.m_axisAssignments[s];
    }

    public void init() {
        super.init();
        this.m_Frame = null;
    }

    public Rectangle getLeftFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getLeftEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getRightFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getRightEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getBottomFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getBottomEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public void ConstrainBoxAspect(Rectangle box, int top, int bottom, int left, int right, double aspect) {
        double horzDiff = (double)(100 - left - right) / 100.0;
        int horzDist = box.width;
        int base = box.x;
        double percent = horzDiff / 2.0 + (double)left / 100.0;
        int horzMid = (int)(percent * (double)horzDist) + base;
        double vertDiff = (double)(100 - top - bottom) / 100.0;
        int vertDist = box.height;
        base = box.y;
        percent = vertDiff / 2.0 + (double)bottom / 100.0;
        int vertMid = (int)(percent * (double)vertDist) + base;
        int horzSize1 = aspect == 0.0 ? 0 : (int)((double)vertDist * vertDiff / aspect);
        int horzSize2 = (int)((double)horzDist * horzDiff);
        int vertSize1 = (int)((double)vertDist * vertDiff);
        int vertSize2 = (int)((double)horzDist * horzDiff * aspect);
        int horzSize = 0;
        int vertSize = 0;
        if (horzSize1 < horzSize2) {
            horzSize = horzSize1;
            vertSize = vertSize1;
        } else {
            horzSize = horzSize2;
            vertSize = vertSize2;
        }
        box.x = horzMid - horzSize / 2;
        box.width = horzSize;
        box.y = vertMid - vertSize / 2;
        box.height = vertSize;
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    public FrameObj getFrame() {
        return this.m_Frame;
    }

    public IAxis getAxis(int axisId) {
        return null;
    }
}

