/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.math;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public final class MathExt {
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double DEG_PER_RAD = 57.29577951308232;
    public static final double RAD_PER_DEG = Math.PI / 180;
    public static final double COS_SIN_45 = 0.7071067811865475;

    private MathExt() {
    }

    public static Point polToCart(double angleInDeg, double radius, Point origin) {
        Point pt = new Point(0, 0);
        double fX = radius * Math.cos(angleInDeg * (Math.PI / 180));
        double fY = radius * Math.sin(angleInDeg * (Math.PI / 180));
        pt.x = origin.x + (int)fX;
        pt.y = origin.y + (int)fY;
        return pt;
    }

    public static int findQuadrantAngle(double angle) {
        while (angle >= 360.0) {
            angle -= 360.0;
        }
        if (angle < 90.0) {
            return 1;
        }
        if (angle < 180.0) {
            return 2;
        }
        if (angle < 270.0) {
            return 3;
        }
        return 4;
    }

    public static double getIntercept(double x0, double y0, double x1, double y1, double y) {
        double fSlope = (y - y0) / (y1 - y0);
        double fXDiff = x1 - x0;
        double x = fXDiff * fSlope + x0;
        return x;
    }

    public static Point rotatePoint(Point ptIn, Point ptCenter, double dRotationAngle) {
        Point ptOut = new Point();
        double dy = -((double)(ptIn.y - ptCenter.y));
        double dx = ptIn.x - ptCenter.x;
        double radius = Math.sqrt(dy * dy + dx * dx);
        if (radius > 1.0E-14) {
            double alpha = Math.asin(dy / radius) * 180.0 / Math.PI;
            if (dx < 0.0) {
                alpha = 180.0 - alpha;
            }
            if ((alpha += dRotationAngle) < 0.0) {
                alpha += 360.0;
            }
            if (alpha > 360.0) {
                alpha -= 360.0;
            }
            ptOut.x = (int)((double)ptCenter.x + radius * Math.cos(alpha * Math.PI / 180.0));
            ptOut.y = (int)((double)ptCenter.y - radius * Math.sin(alpha * Math.PI / 180.0));
        } else {
            ptOut = ptIn;
        }
        return ptOut;
    }

    public static Polygon rotatePolygon(Polygon polyIn, Point ptCenter, double dRotationAngle) {
        Polygon polyOut = new Polygon();
        Point pt = new Point();
        for (int i = 0; i < polyIn.npoints; ++i) {
            pt.x = polyIn.xpoints[i];
            pt.y = polyIn.ypoints[i];
            pt = MathExt.rotatePoint(pt, ptCenter, dRotationAngle);
            polyOut.addPoint(pt.x, pt.y);
        }
        return polyOut;
    }

    public static Polygon offsetPolygon(Polygon polyIn, int x, int y) {
        Polygon polyOut = new Polygon();
        for (int i = 0; i < polyIn.npoints; ++i) {
            polyOut.addPoint(polyIn.xpoints[i] + x, polyIn.ypoints[i] + y);
        }
        return polyOut;
    }

    public static Shape offsetShape(Shape shape, int x, int y) {
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        Shape trShape = at.createTransformedShape(shape);
        return trShape;
    }

    static void limitYPolygon(Polygon polygon, int nMinLimit, int nMaxLimit) {
        for (int i = 0; i < polygon.npoints; ++i) {
            if (nMinLimit != -1) {
                polygon.ypoints[i] = Math.max(polygon.ypoints[i], nMinLimit);
            }
            if (nMaxLimit == -1) continue;
            polygon.ypoints[i] = Math.min(polygon.ypoints[i], nMaxLimit);
        }
    }

    public static double sigdigits(double dVal, int significantDigits) {
        int excessDigitValue;
        boolean Neg;
        String theValueString = Double.toString(dVal);
        int excessDigit = significantDigits;
        boolean Decimal = theValueString.indexOf(".") != -1;
        boolean bl = Neg = dVal < 0.0;
        if (Decimal) {
            ++excessDigit;
        }
        if (Neg) {
            ++excessDigit;
        }
        if (theValueString.length() < excessDigit) {
            return dVal;
        }
        String excessFractionString = theValueString.substring(excessDigit, theValueString.length());
        excessFractionString = "0." + excessFractionString;
        double excessFractionValue = new Double(excessFractionString);
        String significanceAdder = "0.";
        for (int i = 1; i < significantDigits; ++i) {
            significanceAdder = significanceAdder + "0";
        }
        significanceAdder = significanceAdder + "5";
        double returnValue = dVal;
        if (excessFractionValue > 0.5) {
            returnValue = Neg ? dVal - new Double(significanceAdder) : dVal + new Double(significanceAdder);
        } else if (FP.equal(excessFractionValue, 0.5) && (excessDigitValue = new Integer(theValueString.substring(excessDigit - 1, excessDigit)).intValue()) % 2 != 0) {
            returnValue = Neg ? dVal - new Double(significanceAdder) : dVal + new Double(significanceAdder);
        }
        return returnValue;
    }
}

