/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.util.xml;

import com.businessobjects.visualization.internal.util.Enum;
import com.businessobjects.visualization.util.xml.IXmlNameTable;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class XmlWriter {
    private int depth;
    private final Charset encoding;
    private final OutputStream os;
    private final XmlSerializer serializer;
    private boolean calledStartDocument;
    private final Writer writer;
    private WriteState writeState = WriteState.INITIAL;
    static /* synthetic */ Class class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState;

    public XmlWriter(OutputStream os, Charset encoding) throws XmlException {
        if (os == null || encoding == null) {
            throw new NullPointerException();
        }
        try {
            this.serializer = XmlPullParserFactory.newInstance().newSerializer();
            this.serializer.setOutput(os, encoding.name());
            this.encoding = encoding;
            this.os = os;
            this.writer = null;
        }
        catch (XmlPullParserException e) {
            throw XmlException.createXmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    public XmlWriter(Writer writer, Charset encoding) throws XmlException {
        if (writer == null || encoding == null) {
            throw new NullPointerException();
        }
        try {
            this.serializer = XmlPullParserFactory.newInstance().newSerializer();
            this.serializer.setOutput(writer);
            this.encoding = encoding;
            this.os = null;
            this.writer = writer;
        }
        catch (XmlPullParserException e) {
            throw XmlException.createXmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    public void attribute(String localName, String value) throws XmlException {
        this.attribute(null, localName, value);
    }

    public void attribute(String namespace, String localName, String value) throws XmlException {
        this.attribute(namespace, localName, value, false);
    }

    public void attribute(String namespace, String localName, int value) throws XmlException {
        Integer i = new Integer(value);
        this.attribute(namespace, localName, i.toString(), false);
    }

    public void attribute(String namespace, String localName, boolean value) throws XmlException {
        Boolean b = new Boolean(value);
        this.attribute(namespace, localName, b.toString(), false);
    }

    public void attribute(String namespace, String localName, double value) throws XmlException {
        Double d = new Double(value);
        this.attribute(namespace, localName, d.toString(), false);
    }

    private void attribute(String namespace, String localName, String value, boolean skipUndeclaredNs) throws XmlException {
        if (namespace != null) {
            if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
                if (skipUndeclaredNs) {
                    return;
                }
                throw new IllegalArgumentException("Cannot write namspace declarations.");
            }
            if (this.serializer.getPrefix(namespace, false) == null) {
                if (skipUndeclaredNs) {
                    return;
                }
                throw new IllegalArgumentException("The specified namespace (" + namespace + ") has not been declared.");
            }
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        if (localName.length() == 0) {
            throw new IllegalArgumentException("localName is empty.");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (this.writeState != WriteState.ATTRIBUTE) {
            if (this.writeState != WriteState.ELEMENT) {
                throw new IllegalStateException("Currently not in an element: " + this.writeState);
            }
            this.writeState = WriteState.ATTRIBUTE;
        }
        try {
            this.serializer.attribute(namespace, localName, value);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    public void attributes(XmlReader reader) throws XmlException {
        if (reader.getEventType() != XmlEventType.START_ELEMENT) {
            throw new IllegalStateException("The reader is not on a start element.");
        }
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            this.attribute(reader.getAttributeNamespace(i), reader.getAttributeName(i), reader.getAttributeValue(i), true);
        }
    }

    public void cdata(String text) throws XmlException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        switch (this.writeState.value()) {
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Writer not in correct state: " + this.writeState);
            }
        }
        try {
            StringBuffer b;
            int pos;
            int escapeLength = 3;
            int prevPos = 0;
            while ((pos = text.indexOf("]]>", prevPos)) != -1) {
                b = new StringBuffer(pos - prevPos + 3);
                if (prevPos > 0) {
                    b.append('>');
                }
                b.append(text.substring(prevPos, pos));
                b.append("]]");
                this.serializer.cdsect(b.toString());
                prevPos = pos + 3;
            }
            if (prevPos < text.length()) {
                b = new StringBuffer(pos - prevPos + 3);
                if (prevPos > 0) {
                    b.append('>');
                }
                b.append(text.substring(prevPos));
                this.serializer.cdsect(b.toString());
            } else if (prevPos > 0) {
                this.serializer.cdsect(">");
            }
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        this.writeState = WriteState.CONTENT;
    }

    public void close() throws XmlException {
        switch (this.writeState.value()) {
            case 7: {
                return;
            }
            case 0: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException("Still open elements left.");
            }
        }
        try {
            this.serializer.flush();
            if (this.os != null) {
                this.os.close();
            } else {
                this.writer.close();
            }
            this.writeState = WriteState.CLOSED;
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    public void declareNamespace(String prefix, String uri) throws XmlException {
        switch (this.writeState.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Writer not in correct state: " + this.writeState);
            }
        }
        if (prefix != null && prefix.length() == 0) {
            throw new IllegalArgumentException("prefix is empty.");
        }
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (uri.length() == 0) {
            throw new IllegalArgumentException("uri is empty.");
        }
        try {
            this.serializer.setPrefix(prefix, uri);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    public void endDocument() throws XmlException {
        if (this.depth != 0) {
            throw new IllegalStateException("Still elements to close; at depth " + this.depth);
        }
        if (!this.calledStartDocument) {
            throw new IllegalStateException("startDocument() not called.");
        }
        switch (this.writeState.value()) {
            case 5: {
                break;
            }
            case 1: {
                throw new IllegalStateException("No root element written.");
            }
            default: {
                throw new IllegalStateException("Not in a valid state: " + this.writeState);
            }
        }
        try {
            this.serializer.endDocument();
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        this.writeState = WriteState.END_DOCUMENT;
    }

    public void endElement(String localName) throws XmlException {
        this.endElement(null, localName);
    }

    public void endElement(String namespace, String localName) throws XmlException {
        switch (this.writeState.value()) {
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Not in a valid state: " + this.writeState);
            }
        }
        try {
            this.serializer.endTag(namespace, localName);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        if (this.depth > 1) {
            this.writeState = WriteState.CONTENT;
        } else {
            if (this.depth < 1) {
                throw new IllegalStateException("Invalid depth: " + this.depth);
            }
            this.writeState = WriteState.CLOSED_LAST_ELEMENT;
        }
        --this.depth;
    }

    public void node(XmlReader reader) throws XmlException {
        if (reader.getEventType() != XmlEventType.START_ELEMENT) {
            throw new IllegalStateException("Not on a start element.");
        }
        this.setNSPrefixes(reader);
        String ns = reader.getNamespace();
        String name = reader.getName();
        this.startElement(reader.getPrefix(), ns, name);
        this.attributes(reader);
        XmlEventType eventType = reader.next();
        while (eventType != XmlEventType.END_ELEMENT && eventType != XmlEventType.END_DOCUMENT) {
            switch (eventType.value()) {
                case 6: {
                    this.cdata(reader.getText());
                    break;
                }
                case 3: {
                    this.node(reader);
                    break;
                }
                case 5: {
                    this.text(reader.getText());
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.require(XmlEventType.END_ELEMENT, ns, name);
        this.endElement(ns, name);
    }

    private void setNSPrefixes(XmlReader parser) throws XmlException {
        int count = parser.getAttributeCount();
        IXmlNameTable nt = parser.getNameTable();
        String xmlns = nt.add("http://www.w3.org/2000/xmlns/");
        try {
            for (int i = 0; i < count; ++i) {
                String ns = parser.getAttributeNamespace(i);
                if (xmlns != ns) continue;
                String name = parser.getAttributeName(i);
                if (name == null) {
                    this.serializer.setPrefix("", parser.getAttributeValue(i));
                    continue;
                }
                this.serializer.setPrefix(name, parser.getAttributeValue(i));
            }
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    public void startDocument() throws XmlException {
        switch (this.writeState.value()) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Not a valid state: " + this.writeState);
            }
        }
        try {
            this.serializer.startDocument(this.encoding.name(), null);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        this.calledStartDocument = true;
        this.writeState = WriteState.DOCUMENT;
    }

    public void startElement(String localName) throws XmlException {
        this.startElement(null, null, localName);
    }

    public void startElement(String namespace, String localName) throws XmlException {
        this.startElement(null, namespace, localName);
    }

    public void startElement(String prefix, String namespace, String localName) throws XmlException {
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        if (localName.length() == 0) {
            throw new IllegalArgumentException("localName is empty.");
        }
        switch (this.writeState.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Not a valid state: " + this.writeState);
            }
        }
        try {
            String pf;
            if (prefix != null) {
                this.serializer.setPrefix(prefix, namespace);
            } else if (namespace != null && (pf = this.serializer.getPrefix(namespace, false)) == null) {
                throw new IllegalArgumentException("Unknown namespace: " + namespace);
            }
            this.serializer.startTag(namespace, localName);
            ++this.depth;
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        this.writeState = WriteState.ELEMENT;
    }

    public void text(String text) throws XmlException {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        switch (this.writeState.value()) {
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Writer not in correct state: " + this.writeState);
            }
        }
        try {
            this.serializer.text(text);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        this.writeState = WriteState.CONTENT;
    }

    public String getEncoding() {
        return this.encoding.name();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class WriteState
    extends Enum {
        public static final int I_INITIAL = 0;
        public static final int I_DOCUMENT = 1;
        public static final int I_ELEMENT = 2;
        public static final int I_ATTRIBUTE = 3;
        public static final int I_CONTENT = 4;
        public static final int I_CLOSED_LAST_ELEMENT = 5;
        public static final int I_END_DOCUMENT = 6;
        public static final int I_CLOSED = 7;
        public static final WriteState INITIAL = new WriteState(0, "INITIAL");
        public static final WriteState DOCUMENT = new WriteState(1, "DOCUMENT");
        public static final WriteState ELEMENT = new WriteState(2, "ELEMENT");
        public static final WriteState ATTRIBUTE = new WriteState(3, "ATTRIBUTE");
        public static final WriteState CONTENT = new WriteState(4, "CONTENT");
        public static final WriteState CLOSED_LAST_ELEMENT = new WriteState(5, "CLOSED_LAST_ELEMENT");
        public static final WriteState END_DOCUMENT = new WriteState(6, "END_DOCUMENT");
        public static final WriteState CLOSED = new WriteState(7, "CLOSED");

        private WriteState(int value, String name) {
            super(value, name);
        }

        public static WriteState fromInt(int i) {
            return (WriteState)WriteState.fromInt(class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState == null ? (class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState = XmlWriter.class$("com.businessobjects.visualization.util.xml.XmlWriter$WriteState")) : class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState, i);
        }

        public static List values() {
            return WriteState.values(class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState == null ? (class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState = XmlWriter.class$("com.businessobjects.visualization.util.xml.XmlWriter$WriteState")) : class$com$businessobjects$visualization$util$xml$XmlWriter$WriteState);
        }
    }
}

