/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.Graphic;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.ISettingsListener;
import com.businessobjects.visualization.graphic.Property;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.graphic.SettingsEvent;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuString;
import java.util.Hashtable;
import java.util.Vector;

public class SettingsManager {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$SettingsManager == null ? (class$com$businessobjects$visualization$graphic$SettingsManager = SettingsManager.class$("com.businessobjects.visualization.graphic.SettingsManager")) : class$com$businessobjects$visualization$graphic$SettingsManager));
    private Hashtable htListeners_ = new Hashtable();
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$SettingsManager;

    public void addListener(GraphicDefNode node, ISettingsListener listener) {
        this.addInternalListener(node, listener);
    }

    private void addInternalListener(GraphicDefNode node, ISettingsListener listener) {
        Vector listeners = null;
        if (this.htListeners_.containsKey(node)) {
            listeners = (Vector)this.htListeners_.get(node);
        } else {
            listeners = new Vector();
            this.htListeners_.put(node, listeners);
        }
        listeners.add(listener);
    }

    public void updateSettings(Graphic graphic, Region region, PropertyDef pdef, VisuObject vo) {
        this.fireUpdateSettings(new SettingsEvent(graphic, graphic, region, pdef, vo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdateSettings(SettingsEvent event) {
        ISettingsListener l;
        int i;
        SettingsManager settingsManager;
        Object[] ls;
        Vector listeners;
        if (event != null && this.htListeners_.containsKey(event.getPropertyDef())) {
            listeners = (Vector)this.htListeners_.get(event.getPropertyDef());
            ls = listeners.toArray();
            settingsManager = this;
            synchronized (settingsManager) {
                for (i = 0; i < ls.length; ++i) {
                    l = (ISettingsListener)ls[i];
                    l.updateSettings(event);
                }
            }
        }
        if (event != null && this.htListeners_.containsKey(event.getRegion().getRegionDef())) {
            listeners = (Vector)this.htListeners_.get(event.getRegion().getRegionDef());
            ls = listeners.toArray();
            settingsManager = this;
            synchronized (settingsManager) {
                for (i = 0; i < ls.length; ++i) {
                    l = (ISettingsListener)ls[i];
                    l.updateSettings(event);
                }
            }
        }
        if (event != null && this.htListeners_.containsKey(event.getGraphicLayer().getDef())) {
            listeners = (Vector)this.htListeners_.get(event.getGraphicLayer().getDef());
            ls = listeners.toArray();
            settingsManager = this;
            synchronized (settingsManager) {
                for (i = 0; i < ls.length; ++i) {
                    l = (ISettingsListener)ls[i];
                    l.updateSettings(event);
                }
            }
        }
    }

    public void cleanAllListener() {
        this.htListeners_.clear();
    }

    public void addListener(RegionDef rdef, ISettingsListener listener) {
        this.addInternalListener(rdef, listener);
    }

    public void removeListener(GraphicDefNode node, ISettingsListener listener) {
        Vector listeners = null;
        if (this.htListeners_.containsKey(node)) {
            listeners = (Vector)this.htListeners_.get(node);
            listeners.remove(listener);
        }
        listeners.add(listener);
    }

    public static void keepSettingsRegion(IRegion rootToRestore, IRegion rootToKeepIn, PublicGraphicDef pgOld, PublicGraphicDef pgNew) {
        Region regionToRestore = (Region)rootToRestore;
        Region regionToKeepIn = (Region)rootToKeepIn;
        regionToKeepIn.setValue(regionToRestore.getValue());
        IGraphicNode[] children = regionToRestore.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IGraphicNode child = children[i];
            if (child.getDef().getNodeType() == IGraphicDefNode.GraphicDefNodeType.REGION) {
                Region subRegionRestore;
                Region subRegionNew;
                RegionDef regionDef = (RegionDef)child.getDef();
                if (regionDef.getType() != RegionDefType.STATIC || null == (subRegionNew = (Region)regionToKeepIn.getRegion((subRegionRestore = (Region)child).getId()))) continue;
                SettingsManager.keepSettingsRegion(subRegionRestore, subRegionNew, pgOld, pgNew);
                continue;
            }
            if (child.getDef().getNodeType() == IGraphicDefNode.GraphicDefNodeType.PROPERTY) {
                Property subPropRestore = (Property)child;
                Property subPropNew = (Property)regionToKeepIn.getProperty(subPropRestore.getId());
                if (null == subPropNew || subPropRestore.getPropertyValue().getType() != subPropNew.getPropertyValue().getType()) continue;
                SettingsManager.keepSettingsProperty(rootToRestore.getId(), subPropRestore, subPropNew, pgOld, pgNew);
                continue;
            }
            LOGGER.warn((Object)("Type " + child.getDef().getNodeType() + " not supported for migration in turnTo()"), null);
        }
    }

    private static void keepSettingsProperty(String regionId, Property propertytoRestore, Property newProperty, PublicGraphicDef pgOld, PublicGraphicDef pgNew) {
        VisuObject vObjectToSet = SettingsManager.getObjectToRestore(regionId, propertytoRestore, newProperty, pgOld, pgNew);
        try {
            newProperty.setPropertyValue(vObjectToSet);
        }
        catch (VisualizationRuntimeException vre) {
            LOGGER.warn((Object)vre.getMessage(), (Throwable)((Object)vre));
            try {
                SettingsManager.updateWithRules(propertytoRestore, newProperty);
            }
            catch (VisualizationRuntimeException vre2) {
                LOGGER.warn((Object)vre.getMessage(), (Throwable)((Object)vre2));
            }
        }
        if (vObjectToSet.getType() == VisuObjectType.STATE || vObjectToSet.getType() == VisuObjectType.BOOL) {
            IGraphicNode[] children = propertytoRestore.getChildren();
            for (int i = 0; i < children.length; ++i) {
                IGraphicNode child = children[i];
                Property subPropRestore = (Property)child;
                Property subPropNew = (Property)newProperty.getProperty(subPropRestore.getId());
                if (null == subPropNew) continue;
                SettingsManager.keepSettingsProperty(regionId, subPropRestore, subPropNew, pgOld, pgNew);
            }
        }
    }

    private static VisuObject getObjectToRestore(String regionId, Property propertytoRestore, Property newProperty, PublicGraphicDef pgOld, PublicGraphicDef pgNew) {
        VisuObject vObjectToSet = propertytoRestore.getPropertyValue();
        if (pgNew != null && pgNew.containPropertyRef(regionId, newProperty.getId())) {
            vObjectToSet = pgNew.getPropertyRef(regionId, newProperty.getId()).getDefaultValue();
        } else if (pgOld != null && pgOld.containPropertyRef(regionId, propertytoRestore.getId())) {
            RegionDef rd = (RegionDef)pgNew.getGraphicDef().getNode(regionId, IGraphicDefNode.GraphicDefNodeType.REGION);
            vObjectToSet = ((PropertyDef)rd.getNode(propertytoRestore.getId(), IGraphicDefNode.GraphicDefNodeType.PROPERTY)).getDefaultValue();
        }
        return vObjectToSet;
    }

    private static void updateWithRules(Property propertytoRestore, Property newProperty) throws VisualizationRuntimeException {
        if (propertytoRestore.getPropertyDef().getType() == VisuObjectType.STRING) {
            int value = ((VisuInteger)newProperty.getPropertyDef().getParameter()).intValue();
            String newValue = ((VisuString)propertytoRestore.getPropertyValue()).toString().substring(0, value);
            newProperty.setPropertyValue(new VisuString(newValue));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

