/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class GraphicDefNode
implements IGraphicDefNode {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$GraphicDefNode == null ? (class$com$businessobjects$visualization$graphic$GraphicDefNode = GraphicDefNode.class$("com.businessobjects.visualization.graphic.GraphicDefNode")) : class$com$businessobjects$visualization$graphic$GraphicDefNode));
    private String id_;
    private String basicId_;
    private String uid_;
    private String name_;
    private String description_;
    protected ArrayList childList_ = new ArrayList();
    private IGraphicDefNode parent_;
    private IGraphicDefNode rootParent_;
    private IGraphicDefNode.GraphicDefNodeType nodeType_;
    private ArrayList childVisibility_ = new ArrayList();
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$GraphicDefNode;

    public GraphicDefNode(String basicId, String name, String description, IGraphicDefNode parent, IGraphicDefNode rootParent, IGraphicDefNode.GraphicDefNodeType nodeType) {
        this.parent_ = parent;
        this.rootParent_ = rootParent;
        this.basicId_ = basicId;
        this.description_ = description;
        if (parent != null && parent.getClass().equals(this.getClass())) {
            this.id_ = parent.getId() + "/" + basicId;
            this.uid_ = parent.getUid() + "/" + basicId;
        } else if (parent != null) {
            this.uid_ = parent.getUid() + "/" + basicId;
            this.id_ = basicId;
        } else {
            this.uid_ = this.id_ = basicId;
        }
        this.name_ = name;
        this.nodeType_ = nodeType;
    }

    public String getId() {
        return this.id_;
    }

    protected final String getBasicId() {
        return this.basicId_;
    }

    public final String getUid() {
        return this.uid_;
    }

    public final String getName() {
        return this.name_;
    }

    public final IGraphicDefNode getParent() {
        return this.parent_;
    }

    public final IGraphicDefNode getRootParent() {
        return this.rootParent_;
    }

    public final IGraphicDefNode.GraphicDefNodeType getNodeType() {
        return this.nodeType_;
    }

    public IGraphicDefNode[] getChildren() {
        IGraphicDefNode[] result = null;
        result = new IGraphicDefNode[this.childList_.size()];
        this.childList_.toArray(result);
        return result;
    }

    final void addChild(IGraphicDefNode child) {
        if (this.nodeExist(child.getId(), child.getNodeType())) {
            throw new VisualizationRuntimeException("VIZ_00093_ERR_CHILD_WITH_THE_SAME_", new Object[]{child.getId()});
        }
        if (!this.hierarchyIsValid(this.nodeType_, child.getNodeType())) {
            throw new VisualizationRuntimeException("VIZ_00094_ERR_HIERARCHY_IS_NOT_CON", new Object[]{this.nodeType_, child.getNodeType()});
        }
        this.childList_.add(child);
    }

    private boolean hierarchyIsValid(IGraphicDefNode.GraphicDefNodeType parentType, IGraphicDefNode.GraphicDefNodeType childType) {
        boolean result = false;
        if (parentType == IGraphicDefNode.GraphicDefNodeType.GRAPHIC && childType == IGraphicDefNode.GraphicDefNodeType.REGION) {
            result = true;
        } else if (parentType == IGraphicDefNode.GraphicDefNodeType.REGION && (childType == IGraphicDefNode.GraphicDefNodeType.REGION || childType == IGraphicDefNode.GraphicDefNodeType.PROPERTY)) {
            result = true;
        } else if (parentType == IGraphicDefNode.GraphicDefNodeType.PROPERTY && childType == IGraphicDefNode.GraphicDefNodeType.PROPERTY) {
            result = true;
        }
        return result;
    }

    final ArrayList getChildren(IGraphicDefNode.GraphicDefNodeType nodeType) {
        ArrayList<IGraphicDefNode> list = new ArrayList<IGraphicDefNode>();
        Iterator iter = this.childList_.iterator();
        while (iter.hasNext()) {
            IGraphicDefNode obj = (IGraphicDefNode)iter.next();
            if (!obj.getNodeType().equals(nodeType)) continue;
            list.add(obj);
        }
        return list;
    }

    final IGraphicDefNode getNode(String key, IGraphicDefNode.GraphicDefNodeType nodeType) {
        IGraphicDefNode result = this.searchNode(key, this.getChildren(), nodeType);
        if (result == null) {
            LOGGER.debug((Object)("Node:" + key + "(" + nodeType + ") not exist in :" + this.id_));
        }
        return result;
    }

    final boolean contains(GraphicDefNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return this.childList_.contains(node);
    }

    public final boolean nodeExist(String key, IGraphicDefNode.GraphicDefNodeType nodeType) {
        boolean result = false;
        IGraphicDefNode node = this.searchNode(key, this.getChildren(), nodeType);
        if (node != null) {
            result = true;
        }
        return result;
    }

    protected IGraphicDefNode searchNode(String key, IGraphicDefNode[] children, IGraphicDefNode.GraphicDefNodeType nodeType) {
        IGraphicDefNode result = null;
        if (children != null) {
            for (int i = 0; i < children.length && result == null; ++i) {
                if (key.equals(children[i].getId()) && children[i].getNodeType() == nodeType) {
                    result = children[i];
                    break;
                }
                if (nodeType != children[i].getNodeType()) continue;
                result = this.searchNode(key, children[i].getChildren(), nodeType);
            }
        }
        return result;
    }

    public void trace() {
        LOGGER.debug((Object)("GraphicDefNode Node Type :" + this.nodeType_.toString()));
        LOGGER.debug((Object)("id = " + this.id_));
        LOGGER.debug((Object)"{");
        Iterator iter = this.childList_.iterator();
        while (iter.hasNext()) {
            GraphicDefNode gdn = (GraphicDefNode)iter.next();
            gdn.trace();
        }
        LOGGER.debug((Object)"}");
    }

    public final String getDescription() {
        return this.description_;
    }

    protected void setId(String id) {
        this.id_ = id;
    }

    protected void setUid(String uid) {
        this.uid_ = uid;
    }

    void addChildVisibility(PropertyDefVisibilityType vis) {
        if (!this.childVisibility_.contains(vis)) {
            this.childVisibility_.add(vis);
            if (this.getParent() != null) {
                ((GraphicDefNode)this.getParent()).addChildVisibility(vis);
            }
        }
    }

    boolean containsChildWithVisibility(PropertyDefVisibilityType visibility) {
        boolean result = false;
        result = visibility == null ? true : this.childVisibility_.contains(visibility);
        return result;
    }

    public String toString() {
        return this.getId();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

