/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.ProviderDescription;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLPublicGraphic;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegion;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisualizationLibrary;
import com.businessobjects.visualization.rendering.formats.OutputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class GraphicDef
extends GraphicDefNode {
    public static final String REGION_ROOT = "root";
    private boolean multiLayer_;
    private ProviderDescription providerDescription_;
    private String feedId_;
    private String defaultPublicGraphicId_;
    private ArrayList publicGraphicList_ = new ArrayList();
    private int outputTypes_;

    public GraphicDef(XMLGraphic xg, ProviderDescription pdesc, LocalizedEngine.Localizator loc, XMLVisualizationLibrary xlibTemplate, int outputs) {
        super(xg.m_a_Id, loc.getValue(xg.m_a_Name), loc.getValue(xg.m_a_Description), null, null, IGraphicDefNode.GraphicDefNodeType.GRAPHIC);
        this.providerDescription_ = pdesc;
        String rootId = pdesc.getId() + "/" + xg.m_a_Id;
        this.setId(rootId);
        this.setUid(rootId);
        this.feedId_ = xg.m_a_DataFeedDefinitionId;
        if (!pdesc.isValidDataFeedId(this.feedId_)) {
            throw new VisualizationInternalException("Invalid FeedId:" + this.feedId_ + " for graphicId:" + this.getId());
        }
        this.defaultPublicGraphicId_ = pdesc.getId() + "/" + xg.m_a_DefaultPublicGraphicId;
        for (int j = 0; j < xg.m_list_Region.size(); ++j) {
            RegionDef rd = new RegionDef((XMLRegion)xg.m_list_Region.get(j), this, this, loc, xlibTemplate);
            this.addChild(rd);
        }
        this.outputTypes_ = OutputType.decodeOutputType(xg.m_a_Output);
        if (this.outputTypes_ == 0) {
            this.outputTypes_ = outputs;
        }
        Iterator iterPG = xg.m_list_PublicGraphic.iterator();
        while (iterPG.hasNext()) {
            XMLPublicGraphic xpg = (XMLPublicGraphic)iterPG.next();
            PublicGraphicDef pg = new PublicGraphicDef(xg, xpg, this, loc, xlibTemplate);
            this.publicGraphicList_.add(pg);
        }
    }

    public boolean isMultiLayer() {
        return this.multiLayer_;
    }

    public ProviderDescription getProviderDescription() {
        return this.providerDescription_;
    }

    public String getFeedId() {
        return this.feedId_;
    }

    public String getDefaultPublicGraphicId() {
        return this.defaultPublicGraphicId_;
    }

    public Collection getPublicGraphics() {
        return this.publicGraphicList_;
    }

    public int getAvailableOutputTypes() {
        return this.outputTypes_;
    }

    public RegionDef[] getRegions() {
        ArrayList list = this.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION);
        return list.toArray(new RegionDef[list.size()]);
    }

    public RegionDef getRegion(String id) {
        RegionDef result = (RegionDef)this.getNode(id, IGraphicDefNode.GraphicDefNodeType.REGION);
        return result;
    }

    public RegionDef getDynamicRegion(String id) {
        RegionDef result = (RegionDef)this.getNode(id, IGraphicDefNode.GraphicDefNodeType.REGION);
        if (result == null || result.getType() != RegionDefType.DYNAMIC) {
            throw new VisualizationRuntimeException("VIZ_00037_ERR_ID_____ID_____DOESN_", new Object[]{id});
        }
        return result;
    }
}

