/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.formatting.defaultimpl;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.formatting.INumericFormatter;
import com.businessobjects.visualization.formatting.defaultimpl.SimpleFormatSettings;
import com.businessobjects.visualization.formatting.defaultimpl.SimpleNumericFormatPattern;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class SimpleNumericFormatter
implements INumericFormatter {
    private final SimpleNumericFormatPattern pattern_;
    private final SimpleFormatSettings settings_;
    private StringBuffer stringBuffer_;
    private final NumberFormat numberFormat_;

    public SimpleNumericFormatter(SimpleFormatSettings settings, SimpleNumericFormatPattern pattern) {
        this.pattern_ = pattern;
        this.settings_ = settings;
        this.stringBuffer_ = new StringBuffer();
        this.numberFormat_ = NumberFormat.getInstance(this.settings_.getLocale());
        if (this.numberFormat_ instanceof DecimalFormat && this.pattern_ != null) {
            ((DecimalFormat)this.numberFormat_).applyPattern(this.pattern_.getPattern());
        } else if (this.pattern_ != null) {
            throw new VisualizationRuntimeException("VIZ_00032_ERR_NO_AVAILABLE_DECIMAL");
        }
    }

    public boolean format(double value) {
        this.stringBuffer_.setLength(0);
        this.stringBuffer_.append(this.numberFormat_.format(value));
        return true;
    }

    public boolean format(long value) {
        this.stringBuffer_.setLength(0);
        this.stringBuffer_.append(this.numberFormat_.format(value));
        return true;
    }

    public String out() {
        return this.stringBuffer_.toString();
    }
}

