/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.sdk.occa.report.application;

import com.crystaldecisions12.client.helper.SDKResourceManager;
import com.crystaldecisions12.sdk.occa.report.application.IPrintOutputControllerEventListener;
import com.crystaldecisions12.sdk.occa.report.application.ReportSource;
import com.crystaldecisions12.sdk.occa.report.application.af;
import com.crystaldecisions12.sdk.occa.report.application.bl;
import com.crystaldecisions12.sdk.occa.report.application.c;
import com.crystaldecisions12.sdk.occa.report.application.t;
import com.crystaldecisions12.sdk.occa.report.definition.Areas;
import com.crystaldecisions12.sdk.occa.report.definition.IDetailAreaFormat;
import com.crystaldecisions12.sdk.occa.report.definition.Sections;
import com.crystaldecisions12.sdk.occa.report.document.IPrintOptions;
import com.crystaldecisions12.sdk.occa.report.document.IReportDocument;
import com.crystaldecisions12.sdk.occa.report.document.PageMargins;
import com.crystaldecisions12.sdk.occa.report.document.PaperOrientation;
import com.crystaldecisions12.sdk.occa.report.document.PrintReportOptions;
import com.crystaldecisions12.sdk.occa.report.document.ReportDocument;
import com.crystaldecisions12.sdk.occa.report.exportoptions.CharacterSeparatedValuesExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.DataOnlyExcelExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.EditableRTFExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.ExcelExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.ExportOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.IExportOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.PDFExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.RTFWordExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.exportoptions.ReportExportFormat;
import com.crystaldecisions12.sdk.occa.report.exportoptions.TextExportFormatOptions;
import com.crystaldecisions12.sdk.occa.report.lib.IClone;
import com.crystaldecisions12.sdk.occa.report.lib.PropertyBag;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKExceptionBase;
import com.crystaldecisions12.sdk.occa.report.lib.ReportSDKPrinterException;
import com.crystaldecisions12.sdk.occa.report.reportsource.IReportSource;
import com.crystaldecisions12.sdk.occa.report.reportsource.RequestContext;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrintOutputController
extends af {
    private IReportSource zU = null;
    private IReportDocument zT = null;
    private static int zV = 185789;

    PrintOutputController() {
    }

    public InputStream export(ReportExportFormat reportExportFormat) throws ReportSDKException {
        if (reportExportFormat == null) {
            throw new IllegalArgumentException();
        }
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(reportExportFormat);
        Object object = this.a(reportExportFormat);
        if (object != null) {
            exportOptions.setFormatOptions(object);
        }
        exportOptions.setUseDefault(true);
        return this.export(exportOptions);
    }

    public InputStream export(IExportOptions iExportOptions) throws ReportSDKException {
        if (iExportOptions == null) {
            throw new IllegalArgumentException();
        }
        this.a9();
        RequestContext requestContext = new RequestContext();
        try {
            if (this.zU instanceof ReportSource) {
                return ((ReportSource)this.zU).a(iExportOptions, requestContext);
            }
            return this.zU.export(iExportOptions, requestContext);
        }
        catch (ReportSDKExceptionBase reportSDKExceptionBase) {
            ReportSDKException reportSDKException = (ReportSDKException)reportSDKExceptionBase;
            reportSDKException.fillInStackTrace();
            throw reportSDKException;
        }
    }

    private Object a(ReportExportFormat reportExportFormat) {
        if (reportExportFormat == null) {
            return null;
        }
        if (reportExportFormat.value() == 1) {
            return new RTFWordExportFormatOptions();
        }
        if (reportExportFormat.value() == 2) {
            return new ExcelExportFormatOptions();
        }
        if (reportExportFormat.value() == 5) {
            return new PDFExportFormatOptions();
        }
        if (reportExportFormat.value() == 3) {
            return new RTFWordExportFormatOptions();
        }
        if (reportExportFormat.value() == 7) {
            return new TextExportFormatOptions();
        }
        if (reportExportFormat.value() == 8) {
            return new CharacterSeparatedValuesExportFormatOptions();
        }
        if (reportExportFormat.value() == 6) {
            return new DataOnlyExcelExportFormatOptions();
        }
        if (reportExportFormat.value() == 10) {
            return new EditableRTFExportFormatOptions();
        }
        return null;
    }

    void a(bl bl2, EventObject eventObject) throws ReportSDKException {
        if (!(eventObject instanceof t)) {
            throw new IllegalArgumentException();
        }
        t t2 = (t)eventObject;
        block4: for (int i2 = 0; i2 < this.bb().size(); ++i2) {
            IPrintOutputControllerEventListener iPrintOutputControllerEventListener = (IPrintOutputControllerEventListener)this.bb().elementAt(i2);
            switch (bl2.a()) {
                case 3: {
                    iPrintOutputControllerEventListener.onChanged(t2);
                    continue block4;
                }
                case 4: {
                    iPrintOutputControllerEventListener.onChanging(t2);
                }
            }
        }
    }

    void a(IReportSource iReportSource) {
        this.zU = iReportSource;
    }

    void a(IReportDocument iReportDocument) {
        this.zT = iReportDocument;
    }

    public IPrintOptions getPrintOptions() {
        if (this.zT != null) {
            return ((ReportDocument)this.zT).getPrintOptions();
        }
        return null;
    }

    public void modifyPrintOptions(IPrintOptions iPrintOptions) throws ReportSDKException {
        if (this.zT == null) {
            return;
        }
        IPrintOptions iPrintOptions2 = this.getPrintOptions();
        if (iPrintOptions2.hasContent(iPrintOptions)) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("PrintOptions", iPrintOptions);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("PrintOptions", this.getPrintOptions());
        this.a(propertyBag, propertyBag2);
    }

    public void modifyPageMargins(int n2, int n3, int n4, int n5) throws ReportSDKException {
        if (this.zT == null) {
            return;
        }
        PageMargins pageMargins = new PageMargins();
        pageMargins.setBottom(n5);
        pageMargins.setTop(n4);
        pageMargins.setLeft(n2);
        pageMargins.setRight(n3);
        IPrintOptions iPrintOptions = this.getPrintOptions();
        PageMargins pageMargins2 = (PageMargins)iPrintOptions.getPageMargins();
        if (pageMargins2 != null && pageMargins2.hasContent(pageMargins)) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("PageMargins", pageMargins);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("PageMargins", iPrintOptions.getPageMargins());
        this.a(propertyBag, propertyBag2);
    }

    public void modifyUserPaperSize(int n2, int n3) throws ReportSDKException {
        IClone iClone;
        int n4;
        if (this.zT == null) {
            return;
        }
        if (n3 >= zV || n2 >= zV) {
            String string = "Error_PrinterPaperSizeError";
            ReportSDKException.throwReportSDKException(-2147215366, SDKResourceManager.getString(string, this.a7()));
            return;
        }
        IPrintOptions iPrintOptions = this.getPrintOptions();
        boolean bl2 = iPrintOptions.getPaperOrientation() == PaperOrientation.landscape;
        int n5 = bl2 ? n2 : n3;
        int n6 = n4 = bl2 ? n3 : n2;
        if (iPrintOptions.getPageMargins() != null && (n5 <= ((PageMargins)(iClone = (PageMargins)iPrintOptions.getPageMargins())).getLeft() + ((PageMargins)iClone).getRight() || n4 <= ((PageMargins)iClone).getTop() + ((PageMargins)iClone).getBottom())) {
            String string = "Error_PrinterPaperSizeError";
            ReportSDKException.throwReportSDKException(-2147215366, SDKResourceManager.getString(string, this.a7()));
            return;
        }
        iClone = new PropertyBag();
        ((PropertyBag)iClone).putIntValue("CustomPaperHeight", n2);
        ((PropertyBag)iClone).putIntValue("CustomPaperWidth", n3);
        int n7 = iPrintOptions.getContentHeight();
        int n8 = iPrintOptions.getContentWidth();
        if (iPrintOptions.getPageMargins() != null) {
            n7 += iPrintOptions.getPageMargins().getTop() + iPrintOptions.getPageMargins().getBottom();
            n8 += iPrintOptions.getPageMargins().getLeft() + iPrintOptions.getPageMargins().getRight();
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putIntValue("CustomPaperHeight", n7);
        propertyBag.putIntValue("CustomPaperWidth", n8);
        this.a((PropertyBag)iClone, propertyBag);
    }

    public void modifyPrinterName(String string) throws ReportSDKException {
        if (this.zT == null) {
            return;
        }
        if (string == null) {
            return;
        }
        IPrintOptions iPrintOptions = this.getPrintOptions();
        String string2 = iPrintOptions.getPrinterName();
        if (string.equalsIgnoreCase(string2)) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putStringValue("PrinterName", string);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("PrinterName", string2);
        this.a(propertyBag, propertyBag2);
    }

    public void modifyPaperOrientation(PaperOrientation paperOrientation) throws ReportSDKException {
        if (this.zT == null) {
            return;
        }
        if (paperOrientation == null) {
            return;
        }
        IPrintOptions iPrintOptions = this.getPrintOptions();
        if (paperOrientation.value() == iPrintOptions.getPaperOrientation().value()) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putIntValue("PaperOrientation", paperOrientation.value());
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.putIntValue("PaperOrientation", iPrintOptions.getPaperOrientation().value());
        this.a(propertyBag, propertyBag2);
    }

    private void a(PropertyBag propertyBag, PropertyBag propertyBag2) throws ReportSDKException {
        c c10 = new c();
        c10.setController(this);
        c10.long(false);
        c10.a(propertyBag, propertyBag2);
        this.a(c10, true);
    }

    private void V(int n2) {
        int n3 = 0;
        Areas areas = this.zT.getReportDefinition().getAreas();
        int n4 = areas.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            IClone iClone;
            n3 = areas.getArea(i2).getFormat() instanceof IDetailAreaFormat ? ((iClone = (IDetailAreaFormat)areas.getArea(i2).getFormat()).getEnableMultipleColumnFormatting() && iClone.getDetailWidth() < n2 ? iClone.getDetailWidth() : n2) : n2;
            iClone = areas.getArea(i2).getSections();
            int n5 = ((ArrayList)((Object)iClone)).size();
            for (int i3 = 0; i3 < n5; ++i3) {
                ((Sections)iClone).getSection(i3).setWidth(n3);
            }
        }
    }

    void new(PropertyBag propertyBag) {
        assert (this.zT != null);
        if (propertyBag.containsKey("PrintOptions")) {
            IPrintOptions iPrintOptions = (IPrintOptions)propertyBag.get("PrintOptions");
            IPrintOptions iPrintOptions2 = this.getPrintOptions();
            if (iPrintOptions2.getContentWidth() != iPrintOptions.getContentWidth()) {
                this.V(iPrintOptions.getContentWidth());
            }
            iPrintOptions.copyTo(iPrintOptions2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printReport(PrintReportOptions printReportOptions) throws ReportSDKPrinterException {
        Throwable throwable = null;
        try {
            Class<?> clazz = Class.forName("com.businessobjects12.crystalreports.printer.bean.ReportPrinter");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("setReportSource", IReportSource.class);
            method.invoke(obj, this.zU);
            if (printReportOptions != null) {
                Method method2 = clazz.getMethod("print", PrintReportOptions.class);
                method2.invoke(obj, printReportOptions);
            } else {
                Method method3 = clazz.getMethod("print", null);
                method3.invoke(obj, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        finally {
            if (throwable != null) {
                ReportSDKPrinterException.throwReportSDKPrinterException(-2147215357, throwable.getMessage(), throwable);
            }
        }
    }
}

