/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import java.util.Comparator;
import java.util.Locale;

public abstract class StringValue
extends FormulaValue {
    public static final StringValue empty = new a("");

    public static StringValue fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return empty;
        }
        return new a(string);
    }

    public abstract String getString();

    public int getLength() {
        return this.getString().length();
    }

    public char getCharAt(int n2) {
        return this.getString().charAt(n2);
    }

    public String getSubstring(int n2, int n3) {
        return this.getString().substring(n2, n3);
    }

    public final ValueType getValueType() {
        return ValueType.v;
    }

    public FormulaValue coerceToString() {
        return this;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.getString().equals(((StringValue)object).getString());
    }

    public int compareTo(Object object, Comparator comparator) {
        return comparator.compare(this.getString(), ((StringValue)object).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("s(");
        stringBuilder.append(this.getString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toValueString(Locale locale) {
        return this.getString();
    }

    public static CrystalValue fromFormattedString(Locale locale, String string) {
        return StringValue.fromString(string);
    }

    public String toValueString() {
        return this.getString();
    }

    private static final class a
    extends StringValue {
        private final String g;

        private a(String string) {
            if (string == null) {
                throw new NullPointerException("The string cannot be null.");
            }
            this.g = string;
        }

        public String getString() {
            return this.g;
        }
    }
}

