/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.ValueType;

public class FormulaValueType {
    public static final FormulaValueType number = new FormulaValueType(6);
    public static final FormulaValueType currency = new FormulaValueType(7);
    public static final FormulaValueType bool = new FormulaValueType(8);
    public static final FormulaValueType date = new FormulaValueType(9);
    public static final FormulaValueType time = new FormulaValueType(10);
    public static final FormulaValueType dateTime = new FormulaValueType(15);
    public static final FormulaValueType string = new FormulaValueType(11);
    public static final FormulaValueType unknown = new FormulaValueType(255);
    public static final FormulaValueType numberRange = new FormulaValueType(4102);
    public static final FormulaValueType currencyRange = new FormulaValueType(4103);
    public static final FormulaValueType dateRange = new FormulaValueType(4105);
    public static final FormulaValueType timeRange = new FormulaValueType(4106);
    public static final FormulaValueType dateTimeRange = new FormulaValueType(4111);
    public static final FormulaValueType stringRange = new FormulaValueType(4107);
    public static final FormulaValueType unknownRange = new FormulaValueType(4351);
    public static final FormulaValueType numberArray = new FormulaValueType(8198);
    public static final FormulaValueType currencyArray = new FormulaValueType(8199);
    public static final FormulaValueType booleanArray = new FormulaValueType(8200);
    public static final FormulaValueType dateArray = new FormulaValueType(8201);
    public static final FormulaValueType timeArray = new FormulaValueType(8202);
    public static final FormulaValueType dateTimeArray = new FormulaValueType(8207);
    public static final FormulaValueType stringArray = new FormulaValueType(8203);
    public static final FormulaValueType unknownArray = new FormulaValueType(8447);
    public static final FormulaValueType numberRangeArray = new FormulaValueType(12294);
    public static final FormulaValueType currencyRangeArray = new FormulaValueType(12295);
    public static final FormulaValueType dateRangeArray = new FormulaValueType(12297);
    public static final FormulaValueType timeRangeArray = new FormulaValueType(12298);
    public static final FormulaValueType dateTimeRangeArray = new FormulaValueType(12303);
    public static final FormulaValueType stringRangeArray = new FormulaValueType(12299);
    public static final FormulaValueType unknownRangeArray = new FormulaValueType(12543);
    private final int a;

    private FormulaValueType(int n2) {
        this.a = n2;
    }

    public static boolean isValidValue(int n2) {
        switch (n2) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 255: 
            case 4102: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4107: 
            case 4111: 
            case 4351: 
            case 8198: 
            case 8199: 
            case 8200: 
            case 8201: 
            case 8202: 
            case 8203: 
            case 8207: 
            case 8447: 
            case 12294: 
            case 12295: 
            case 12297: 
            case 12298: 
            case 12299: 
            case 12303: 
            case 12543: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidValue(ValueType valueType) {
        return FormulaValueType.isValidValue(valueType.int());
    }

    public static FormulaValueType fromInt(int n2) {
        switch (n2) {
            case 6: {
                return number;
            }
            case 7: {
                return currency;
            }
            case 8: {
                return bool;
            }
            case 9: {
                return date;
            }
            case 10: {
                return time;
            }
            case 15: {
                return dateTime;
            }
            case 11: {
                return string;
            }
            case 255: {
                return unknown;
            }
            case 4102: {
                return numberRange;
            }
            case 4103: {
                return currencyRange;
            }
            case 4105: {
                return dateRange;
            }
            case 4106: {
                return timeRange;
            }
            case 4111: {
                return dateTimeRange;
            }
            case 4107: {
                return stringRange;
            }
            case 4351: {
                return unknownRange;
            }
            case 8198: {
                return numberArray;
            }
            case 8199: {
                return currencyArray;
            }
            case 8200: {
                return booleanArray;
            }
            case 8201: {
                return dateArray;
            }
            case 8202: {
                return timeArray;
            }
            case 8207: {
                return dateTimeArray;
            }
            case 8203: {
                return stringArray;
            }
            case 8447: {
                return unknownArray;
            }
            case 12294: {
                return numberRangeArray;
            }
            case 12295: {
                return currencyRangeArray;
            }
            case 12297: {
                return dateRangeArray;
            }
            case 12298: {
                return timeRangeArray;
            }
            case 12303: {
                return dateTimeRangeArray;
            }
            case 12299: {
                return stringRangeArray;
            }
            case 12543: {
                return unknownRangeArray;
            }
        }
        CrystalAssert.a(false);
        return new FormulaValueType(n2);
    }

    public static FormulaValueType fromValueType(ValueType valueType) {
        return FormulaValueType.fromInt(valueType.int());
    }

    public int value() {
        return this.a;
    }

    public boolean isValidValueType() {
        return true;
    }

    public ValueType toValueType() {
        return ValueType.if(this.a);
    }

    public String toString() {
        return this.toValueType().toString();
    }

    public boolean isNumeric() {
        return this.toValueType().new();
    }

    public FormulaValueType getBaseFormulaValueType() {
        return FormulaValueType.fromValueType(this.toValueType().do());
    }

    public boolean isRange() {
        return this.toValueType().else();
    }

    public boolean isArray() {
        return this.toValueType().char();
    }

    public boolean isRangeArray() {
        return this.toValueType().byte();
    }

    public FormulaValueType getRangeFormulaValueType() {
        return FormulaValueType.fromValueType(this.toValueType().try());
    }

    public FormulaValueType getNonRangeFormulaValueType() {
        return FormulaValueType.fromValueType(this.toValueType().if());
    }

    public FormulaValueType getArrayFormulaValueType() {
        return FormulaValueType.fromValueType(this.toValueType().void());
    }

    public FormulaValueType getNonArrayFormulaValueType() {
        return FormulaValueType.fromValueType(this.toValueType().case());
    }

    public FormulaValueType getRangeArrayFormulaValueType() {
        return FormulaValueType.fromValueType(this.toValueType().a());
    }
}

