/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.definition;

import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.client.helper.XMLSerializationHelper;
import com.crystaldecisions.sdk.occa.report.definition.EmbeddedContentType;
import com.crystaldecisions.sdk.occa.report.definition.FontColor;
import com.crystaldecisions.sdk.occa.report.definition.IFontColor;
import com.crystaldecisions.sdk.occa.report.definition.IHasEmbeddedContentType;
import com.crystaldecisions.sdk.occa.report.definition.IParagraph;
import com.crystaldecisions.sdk.occa.report.definition.IParagraphElement;
import com.crystaldecisions.sdk.occa.report.definition.IParagraphFieldElement;
import com.crystaldecisions.sdk.occa.report.definition.IParagraphTextElement;
import com.crystaldecisions.sdk.occa.report.definition.ITextObject;
import com.crystaldecisions.sdk.occa.report.definition.Paragraph;
import com.crystaldecisions.sdk.occa.report.definition.ParagraphElements;
import com.crystaldecisions.sdk.occa.report.definition.ParagraphTextElement;
import com.crystaldecisions.sdk.occa.report.definition.Paragraphs;
import com.crystaldecisions.sdk.occa.report.definition.ReadingOrder;
import com.crystaldecisions.sdk.occa.report.definition.ReportObject;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IEROMControllerInterface;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.IRepositoryObjectInternal;
import com.crystaldecisions.sdk.occa.report.lib.ReportObjectKind;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.IXMLSerializable;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TextObject
extends ReportObject
implements ITextObject,
IRepositoryObjectInternal,
IHasEmbeddedContentType {
    private IFontColor T = null;
    private Paragraphs R = null;
    private int Y = 0;
    private ReadingOrder S = ReadingOrder.leftToRight;
    private boolean ad = false;
    private boolean X = false;
    private EmbeddedContentType Z = EmbeddedContentType.none;
    private static final String U = "FontColor";
    private static final String ac = "Paragraphs";
    private static final String W = "MaxNumberOfLines";
    private static final String aa = "ReadingOrder";
    private static final String V = "EnableSuppressIfDuplicated";
    private static final String ab = "SuppressEmbeddedFieldBlankLines";
    private String Q = "EmbeddedContentType";

    public TextObject(ITextObject iTextObject) {
        this();
        iTextObject.copyTo(this, true);
    }

    public TextObject() {
        this.setKind(ReportObjectKind.text);
        this.setWidth(1440);
        this.setHeight(200);
    }

    public TextObject(String string) {
        this.setKind(ReportObjectKind.text);
        this.setWidth(1440);
        this.setHeight(200);
        Paragraphs paragraphs = this.getParagraphs();
        Paragraph paragraph = new Paragraph();
        paragraphs.add(paragraph);
        ParagraphElements paragraphElements = paragraph.getParagraphElements();
        ParagraphTextElement paragraphTextElement = new ParagraphTextElement();
        paragraphElements.add(paragraphTextElement);
        paragraphTextElement.setText(string);
    }

    public Object clone(boolean bl2) {
        TextObject textObject = new TextObject();
        this.copyTo(textObject, bl2);
        return textObject;
    }

    public void copyTo(Object object, boolean bl2) {
        super.copyTo(object, bl2);
        if (!(object instanceof TextObject)) {
            throw new ClassCastException();
        }
        TextObject textObject = (TextObject)object;
        textObject.setMaxNumberOfLines(this.Y);
        textObject.setReadingOrder(this.S);
        if (this.T != null && bl2) {
            if (CloneUtil.canCopyTo(this.T, textObject.T)) {
                this.T.copyTo(textObject.T, bl2);
            } else {
                textObject.setFontColor((IFontColor)this.T.clone(bl2));
            }
        } else {
            textObject.T = this.T;
        }
        if (this.R != null && bl2) {
            if (CloneUtil.canCopyTo(this.R, textObject.getParagraphs())) {
                this.R.copyTo(textObject.getParagraphs(), bl2);
            } else {
                textObject.setParagraphs((Paragraphs)this.R.clone(bl2));
            }
        } else {
            textObject.setParagraphs(this.R);
        }
        textObject.setEnableSuppressIfDuplicated(this.ad);
        textObject.setSuppressEmbeddedFieldBlankLines(this.X);
        textObject.setEmbeddedContentType(this.Z);
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        Object object = null;
        if (string.equals(ac)) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.R = (Paragraphs)object;
            }
        } else if (string.equals(U)) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.T = (FontColor)object;
            }
        } else {
            return super.createMember(string, attributes, xMLSerializationContext, map, blArray);
        }
        return object;
    }

    public void endElement(String string, Map map) {
    }

    public ReadingOrder getReadingOrder() {
        if (this.R == null || this.R.size() == 0) {
            return this.S;
        }
        return this.R.getParagraph(0).getReadingOrder();
    }

    public IFontColor getFontColor() {
        if (this.T == null) {
            this.T = new FontColor();
            this.case.propagateController(this.T);
        }
        if (this.R == null || this.R.size() == 0) {
            return this.T;
        }
        return this.R.getParagraph(0).getFontColor();
    }

    public int getMaxNumberOfLines() {
        return this.Y;
    }

    public Paragraphs getParagraphs() {
        if (this.R == null) {
            this.R = new Paragraphs();
            this.case.propagateController(this.R);
        }
        return this.R;
    }

    public String getText() {
        if (this.R == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.R.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IParagraph iParagraph = this.R.getParagraph(i2);
            ParagraphElements paragraphElements = iParagraph.getParagraphElements();
            int n3 = paragraphElements.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                IParagraphElement iParagraphElement;
                IParagraphElement iParagraphElement2 = paragraphElements.getParagraphElement(i3);
                if (iParagraphElement2 instanceof IParagraphTextElement) {
                    iParagraphElement = (IParagraphTextElement)iParagraphElement2;
                    if (iParagraphElement.getText() == null) continue;
                    stringBuffer.append(iParagraphElement.getText());
                    continue;
                }
                if (!(iParagraphElement2 instanceof IParagraphFieldElement) || (iParagraphElement = (IParagraphFieldElement)iParagraphElement2).getDataSource() == null) continue;
                stringBuffer.append(iParagraphElement.getDataSource());
            }
            if (i2 >= n2 - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean getEnableSuppressIfDuplicated() {
        return this.ad;
    }

    public boolean getSuppressEmbeddedFieldBlankLines() {
        return this.X;
    }

    public EmbeddedContentType getEmbeddedContentType() {
        return this.Z;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof TextObject)) {
            return false;
        }
        TextObject textObject = (TextObject)object;
        if (!super.hasContent(textObject)) {
            return false;
        }
        if (this.X != textObject.getSuppressEmbeddedFieldBlankLines()) {
            return false;
        }
        if (this.Y != textObject.getMaxNumberOfLines()) {
            return false;
        }
        if (!CloneUtil.hasContent(this.getParagraphs(), textObject.getParagraphs())) {
            return false;
        }
        if (this.getReadingOrder() != textObject.getReadingOrder()) {
            return false;
        }
        if (this.ad != textObject.getEnableSuppressIfDuplicated()) {
            return false;
        }
        if (!CloneUtil.hasContent(this.getFontColor(), textObject.getFontColor())) {
            return false;
        }
        return this.Z == textObject.getEmbeddedContentType();
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        super.readElement(string, string2, attributes, map);
        if (string.equals(W)) {
            this.Y = XMLConverter.getInt(string2);
        } else if (string.equals(V)) {
            this.ad = XMLConverter.getBooleanValue(string2);
        } else if (string.equals(ab)) {
            this.X = XMLConverter.getBooleanValue(string2);
        } else if (string.equals(aa)) {
            this.S = ReadingOrder.from_string(string2);
        } else if (string.equals(this.Q)) {
            this.Z = EmbeddedContentType.from_string(string2);
        }
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement(string, properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        super.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeIntElement(W, this.Y, null);
        xMLWriter.writeObjectElement(this.R, ac, xMLSerializationContext);
        xMLWriter.writeBooleanElement(V, this.ad, null);
        xMLWriter.writeBooleanElement(ab, this.X, null);
        xMLWriter.writeObjectElement((IXMLSerializable)((Object)this.T), U, xMLSerializationContext);
        xMLWriter.writeEnumElement(aa, this.S, null);
        xMLWriter.writeEnumElement(this.Q, this.Z, null);
    }

    public void setFontColor(final IFontColor iFontColor) {
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.T = iFontColor;
                if (TextObject.this.R != null) {
                    int n2 = TextObject.this.R.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        IFontColor iFontColor2 = null;
                        if (iFontColor != null) {
                            iFontColor2 = (IFontColor)iFontColor.clone(true);
                        }
                        TextObject.this.R.getParagraph(i2).setFontColor(iFontColor2);
                    }
                }
            }
        });
    }

    public void setMaxNumberOfLines(final int n2) {
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.Y = n2;
            }
        });
    }

    public void setReadingOrder(final ReadingOrder readingOrder) {
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.S = readingOrder;
                if (TextObject.this.R != null) {
                    int n2 = TextObject.this.R.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        TextObject.this.R.getParagraph(i2).setReadingOrder(readingOrder);
                    }
                }
            }
        });
    }

    public void setParagraphs(final Paragraphs paragraphs) {
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.R = paragraphs;
            }
        });
    }

    public void setEnableSuppressIfDuplicated(final boolean bl2) {
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.ad = bl2;
            }
        });
    }

    public void setSuppressEmbeddedFieldBlankLines(final boolean bl2) {
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.X = bl2;
            }
        });
    }

    public void setEmbeddedContentType(final EmbeddedContentType embeddedContentType) {
        if (embeddedContentType == null) {
            throw new IllegalArgumentException();
        }
        this.case.makeChange(new IChange(){

            public void run() {
                TextObject.this.Z = embeddedContentType;
            }
        });
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }

    public boolean isConnected() {
        String string = this.getLinkedURI();
        return string != null && string.length() > 0;
    }

    public void disconnect() {
        this.setLinkedURI(null);
    }

    public void refresh() {
        IEROMControllerInterface iEROMControllerInterface = (IEROMControllerInterface)((Object)this.case.getControllerInterface());
        iEROMControllerInterface.getRepositoryService().refreshRepositoryObject(this);
    }

    public void enumerateMembers(IMemberVisitor iMemberVisitor) {
        super.enumerateMembers(iMemberVisitor);
        this.T = iMemberVisitor.visit(this.T, true);
        this.R = iMemberVisitor.visit(this.R, true);
    }
}

