/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.definition;

import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.client.helper.SDKResourceManager;
import com.crystaldecisions.client.helper.XMLSerializationHelper;
import com.crystaldecisions.sdk.occa.report.definition.AreaSectionKind;
import com.crystaldecisions.sdk.occa.report.definition.ChartDefinition;
import com.crystaldecisions.sdk.occa.report.definition.ChartStyle;
import com.crystaldecisions.sdk.occa.report.definition.ChartStyleConverter;
import com.crystaldecisions.sdk.occa.report.definition.IChartDefinition;
import com.crystaldecisions.sdk.occa.report.definition.IChartObject;
import com.crystaldecisions.sdk.occa.report.definition.IChartStyle;
import com.crystaldecisions.sdk.occa.report.definition.ReportObject;
import com.crystaldecisions.sdk.occa.report.definition.visualization.GraphicInstance;
import com.crystaldecisions.sdk.occa.report.definition.visualization.LocalizedEngine;
import com.crystaldecisions.sdk.occa.report.definition.visualization.VisualizationEngine;
import com.crystaldecisions.sdk.occa.report.lib.ControllableHelper;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IEROMControllerInterface;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.ReportObjectKind;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKRuntimeException;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class ChartObject
extends ReportObject
implements IChartObject,
IClone {
    private ChartDefinition ai = null;
    private IChartStyle ah = null;
    private GraphicInstance ag = null;
    private IChartStyle af = null;

    public ChartObject(IChartObject iChartObject) {
        this();
        iChartObject.copyTo(this, true);
    }

    public ChartObject() {
        this.setKind(ReportObjectKind.chart);
        this.setWidth(5760);
        this.setHeight(2880);
    }

    public Object clone(boolean bl2) {
        ChartObject chartObject = new ChartObject();
        this.copyTo(chartObject, bl2);
        return chartObject;
    }

    public void copyTo(Object object, boolean bl2) {
        super.copyTo(object, bl2);
        if (!(object instanceof ChartObject)) {
            throw new ClassCastException();
        }
        ChartObject chartObject = (ChartObject)object;
        if (this.ai != null && bl2) {
            if (CloneUtil.canCopyTo(this.ai, chartObject.getChartDefinition())) {
                this.ai.copyTo(chartObject.getChartDefinition(), bl2);
            } else {
                chartObject.setChartDefinition((IChartDefinition)this.ai.clone(bl2));
            }
        } else {
            chartObject.setChartDefinition(this.ai);
        }
        if (this.ah != null && bl2) {
            if (CloneUtil.canCopyTo(this.ah, chartObject.ah)) {
                this.ah.copyTo(chartObject.ah, bl2);
            } else {
                chartObject.setChartStyle((IChartStyle)this.ah.clone(bl2));
            }
        } else {
            chartObject.setChartStyle(this.ah);
        }
        if (this.af != null && bl2) {
            if (CloneUtil.canCopyTo(this.af, chartObject.af)) {
                this.af.copyTo(chartObject.af, bl2);
            } else {
                chartObject.af = (IChartStyle)this.af.clone(bl2);
            }
        } else {
            chartObject.af = this.af;
        }
        if (this.ag != null && bl2) {
            if (chartObject.ag != null) {
                this.ag.copyTo(chartObject.ag);
            } else {
                chartObject.setGraphicInstance(this.ag.clone());
            }
        } else {
            chartObject.setGraphicInstance(this.ag);
        }
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        Object object = null;
        if (string.equals("ChartDefinition")) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.ai = (ChartDefinition)object;
            }
        } else if (string.equals("GraphicInstance")) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.ag = (GraphicInstance)object;
            }
        } else {
            return super.createMember(string, attributes, xMLSerializationContext, map, blArray);
        }
        return object;
    }

    public void endElement(String string, Map map) {
    }

    public ChartDefinition getChartDefinition() {
        if (this.ai == null) {
            this.ai = new ChartDefinition();
            this.case.propagateController(this.ai);
        }
        return this.ai;
    }

    public int getChartGroupIndex() {
        return this.getSectionCode() % 25;
    }

    public AreaSectionKind getChartReportArea() {
        return AreaSectionKind.from_int(this.getSectionCode() / 1000);
    }

    public IChartStyle getChartStyle() {
        if (this.ah == null) {
            this.ah = new ChartStyle();
            this.resyncChartStyleFromGraphic();
            this.case.propagateController(this.ah);
        }
        return this.ah;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IChartObject)) {
            return false;
        }
        IChartObject iChartObject = (IChartObject)object;
        if (!super.hasContent(iChartObject)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.getChartDefinition(), iChartObject.getChartDefinition())) {
            return false;
        }
        if (!CloneUtil.hasContent(this.getChartStyle(), iChartObject.getChartStyle())) {
            return false;
        }
        return !(this.getGraphicInstance() == null || iChartObject.getGraphicInstance() == null ? this.getGraphicInstance() != iChartObject.getGraphicInstance() : !this.getGraphicInstance().hasContent(iChartObject.getGraphicInstance()));
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        super.readElement(string, string2, attributes, map);
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement("CrystalReports.ChartObject", properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement("CrystalReports.ChartObject");
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        super.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeObjectElement(this.ai, "ChartDefinition", xMLSerializationContext);
        xMLWriter.writeObjectElement(this.ag, "GraphicInstance", xMLSerializationContext);
    }

    public void setChartDefinition(final IChartDefinition iChartDefinition) {
        this.case.makeChange(new IChange(){

            public void run() {
                ChartObject.this.ai = (ChartDefinition)iChartDefinition;
            }
        });
    }

    public void setChartGroupIndex(int n2) {
        int n3 = this.getSectionCode();
        this.setSectionCode(n3 / 1000 * 1000 + n2 % 25 + n3 / 25 % 40 * 25);
    }

    public void setChartReportArea(AreaSectionKind areaSectionKind) {
        AreaSectionKind areaSectionKind2 = this.getChartReportArea();
        if (areaSectionKind2 != areaSectionKind) {
            this.setSectionCode(areaSectionKind.value() * 1000);
        }
    }

    public void setChartStyle(final IChartStyle iChartStyle) {
        this.case.makeChange(new IChange(){

            public void run() {
                ChartObject.this.ah = iChartStyle;
            }
        });
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }

    public void doControllerModification(Object object) throws ReportSDKException {
        IChartObject iChartObject = (IChartObject)object;
        IEROMControllerInterface iEROMControllerInterface = (IEROMControllerInterface)((Object)this.case.getControllerInterface());
        iEROMControllerInterface.getReportDefController().modifyChartObject(this, iChartObject);
    }

    public void enumerateMembers(IMemberVisitor iMemberVisitor) {
        super.enumerateMembers(iMemberVisitor);
        this.ai = iMemberVisitor.visit(this.ai, true);
        this.ah = iMemberVisitor.visit(this.ah, true);
    }

    public GraphicInstance getGraphicInstance() {
        if (this.ag == null) {
            Locale locale = this.case.getControllerInterface() == null ? Locale.getDefault() : this.case.getControllerInterface().getLocale();
            VisualizationEngine visualizationEngine = VisualizationEngine.getInstance();
            LocalizedEngine localizedEngine = visualizationEngine.getLocalizedEngine(locale);
            this.ag = localizedEngine.getGraphicInstance("pfjgraphics/bar");
            this.ag.setChartObject(this);
        }
        return this.ag;
    }

    public void setGraphicInstance(GraphicInstance graphicInstance) {
        if (graphicInstance == this.ag) {
            return;
        }
        if (ControllableHelper.hasEnabledController(this)) {
            String string = SDKResourceManager.getString("Error_CannotChangeGraphicInstance", this.case.getControllerInterface().getLocale());
            throw new ReportSDKRuntimeException(string);
        }
        this.ag = graphicInstance;
        if (this.ag != null) {
            this.ag.setChartObject(this);
        }
    }

    public boolean isChartStyleChangedSinceSync() {
        return !CloneUtil.hasContent(this.af, this.ah);
    }

    public void resyncChartStyleFromGraphic() {
        if (this.ah == null || this.getGraphicInstance().getGraphic().getId().startsWith("pfjlite")) {
            return;
        }
        ChartStyleConverter.updateChartStyleFromGraphic(this.ah, this.getGraphicInstance().getGraphic());
        this.af = (IChartStyle)this.ah.clone(true);
    }

    public void updateSyncedChartStyle() {
        this.af = (IChartStyle)this.ah.clone(true);
    }
}

