/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.application;

import com.crystaldecisions.client.helper.SDKResourceManager;
import com.crystaldecisions.sdk.occa.report.application.IPrintOutputControllerEventListener;
import com.crystaldecisions.sdk.occa.report.application.ReportClientDocument;
import com.crystaldecisions.sdk.occa.report.application.ReportSource;
import com.crystaldecisions.sdk.occa.report.application.an;
import com.crystaldecisions.sdk.occa.report.application.b7;
import com.crystaldecisions.sdk.occa.report.application.d;
import com.crystaldecisions.sdk.occa.report.application.y;
import com.crystaldecisions.sdk.occa.report.definition.Areas;
import com.crystaldecisions.sdk.occa.report.definition.IDetailAreaFormat;
import com.crystaldecisions.sdk.occa.report.definition.Sections;
import com.crystaldecisions.sdk.occa.report.document.IPageMargins;
import com.crystaldecisions.sdk.occa.report.document.IPrintOptions;
import com.crystaldecisions.sdk.occa.report.document.PageMargins;
import com.crystaldecisions.sdk.occa.report.document.PaperOrientation;
import com.crystaldecisions.sdk.occa.report.document.PrintReportOptions;
import com.crystaldecisions.sdk.occa.report.document.ReportDocument;
import com.crystaldecisions.sdk.occa.report.exportoptions.CharacterSeparatedValuesExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.DataOnlyExcelExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.EditableRTFExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ExcelExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ExportOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.IExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.IExportOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.PDFExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.RTFWordExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ReportExportFormat;
import com.crystaldecisions.sdk.occa.report.exportoptions.TextExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IPrintProgressListener;
import com.crystaldecisions.sdk.occa.report.lib.IReportPrinter;
import com.crystaldecisions.sdk.occa.report.lib.PropertyBag;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKExceptionBase;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKPrinterException;
import com.crystaldecisions.sdk.occa.report.reportsource.IReportSource;
import com.crystaldecisions.sdk.occa.report.reportsource.IRequestContext;
import com.crystaldecisions.sdk.occa.report.reportsource.RequestContext;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintOutputController
extends an {
    private ReportClientDocument p = null;
    private IReportPrinter n = null;
    private final Map<String, Object> m = new HashMap<String, Object>();
    private static int o = 185789;

    PrintOutputController(ReportClientDocument reportClientDocument) {
        super(reportClientDocument);
        this.p = reportClientDocument;
    }

    public InputStream export(ReportExportFormat reportExportFormat) throws ReportSDKException {
        if (reportExportFormat == null) {
            throw new IllegalArgumentException();
        }
        return this.export(PrintOutputController.createDefaultExportOptions(reportExportFormat));
    }

    public InputStream export(IExportOptions iExportOptions) throws ReportSDKException {
        return this.export(iExportOptions, (IRequestContext)null);
    }

    public InputStream export(IExportOptions iExportOptions, IRequestContext iRequestContext) throws ReportSDKException {
        return this.if(iExportOptions, iRequestContext, null);
    }

    public void export(ReportExportFormat reportExportFormat, OutputStream outputStream) throws ReportSDKException {
        if (reportExportFormat == null) {
            throw new IllegalArgumentException();
        }
        this.export(PrintOutputController.createDefaultExportOptions(reportExportFormat), outputStream);
    }

    public void export(IExportOptions iExportOptions, OutputStream outputStream) throws ReportSDKException {
        this.export(iExportOptions, null, outputStream);
    }

    public void export(IExportOptions iExportOptions, IRequestContext iRequestContext, OutputStream outputStream) throws ReportSDKException {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        this.if(iExportOptions, iRequestContext, outputStream);
    }

    private InputStream if(IExportOptions iExportOptions, IRequestContext iRequestContext, OutputStream outputStream) throws ReportSDKException {
        if (iExportOptions == null) {
            throw new IllegalArgumentException();
        }
        if (iRequestContext == null) {
            iRequestContext = new RequestContext();
        }
        this.new();
        try {
            IReportSource iReportSource = this.p.x();
            if (iReportSource instanceof ReportSource) {
                return ((ReportSource)iReportSource).a(iExportOptions, iRequestContext, outputStream);
            }
            if (outputStream == null) {
                return iReportSource.export(iExportOptions, iRequestContext);
            }
            iReportSource.export(iExportOptions, iRequestContext, outputStream);
            return null;
        }
        catch (ReportSDKExceptionBase reportSDKExceptionBase) {
            ReportSDKException reportSDKException = (ReportSDKException)reportSDKExceptionBase;
            reportSDKException.fillInStackTrace();
            throw reportSDKException;
        }
    }

    public static IExportOptions createDefaultExportOptions(ReportExportFormat reportExportFormat) {
        if (reportExportFormat == null) {
            return null;
        }
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(reportExportFormat);
        IExportFormatOptions iExportFormatOptions = PrintOutputController.a(reportExportFormat);
        if (iExportFormatOptions != null) {
            exportOptions.setFormatOptions(iExportFormatOptions);
        }
        exportOptions.setUseDefault(true);
        return exportOptions;
    }

    private static IExportFormatOptions a(ReportExportFormat reportExportFormat) {
        if (reportExportFormat == null) {
            return null;
        }
        if (reportExportFormat.value() == 1) {
            return new RTFWordExportFormatOptions();
        }
        if (reportExportFormat.value() == 2) {
            return new ExcelExportFormatOptions();
        }
        if (reportExportFormat.value() == 5) {
            return new PDFExportFormatOptions();
        }
        if (reportExportFormat.value() == 3) {
            return new RTFWordExportFormatOptions();
        }
        if (reportExportFormat.value() == 7) {
            return new TextExportFormatOptions();
        }
        if (reportExportFormat.value() == 8) {
            return new CharacterSeparatedValuesExportFormatOptions();
        }
        if (reportExportFormat.value() == 6) {
            return new DataOnlyExcelExportFormatOptions();
        }
        if (reportExportFormat.value() == 10) {
            return new EditableRTFExportFormatOptions();
        }
        return null;
    }

    @Override
    void a(b7 b72, EventObject eventObject) throws ReportSDKException {
        if (!(eventObject instanceof y)) {
            throw new IllegalArgumentException();
        }
        y y2 = (y)eventObject;
        for (EventListener eventListener : this.a()) {
            IPrintOutputControllerEventListener iPrintOutputControllerEventListener = (IPrintOutputControllerEventListener)eventListener;
            switch (b72.a()) {
                case 3: {
                    iPrintOutputControllerEventListener.onChanged(y2);
                    break;
                }
                case 4: {
                    iPrintOutputControllerEventListener.onChanging(y2);
                }
            }
        }
    }

    public IPrintOptions getPrintOptions() throws ReportSDKException {
        ReportDocument reportDocument = this.p.getReportDocument();
        if (reportDocument != null) {
            return reportDocument.getPrintOptions();
        }
        return null;
    }

    public void modifyPrintOptions(IPrintOptions iPrintOptions) throws ReportSDKException {
        IPrintOptions iPrintOptions2 = this.getPrintOptions();
        if (iPrintOptions2 != null && iPrintOptions2.hasContent(iPrintOptions)) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("PrintOptions", iPrintOptions);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("PrintOptions", this.getPrintOptions());
        IPageMargins iPageMargins = iPrintOptions.getPageMargins();
        boolean bl2 = false;
        if (iPageMargins != null && (iPageMargins.getTop() > 0 || iPageMargins.getBottom() > 0 || iPageMargins.getLeft() > 0 || iPageMargins.getRight() > 0)) {
            bl2 = true;
        }
        propertyBag.putBooleanValue("IsPageMarginValuesInitialized", bl2);
        this.a(propertyBag, propertyBag2);
    }

    public void modifyPageMargins(int n2, int n3, int n4, int n5) throws ReportSDKException {
        PageMargins pageMargins = new PageMargins();
        pageMargins.setBottom(n5);
        pageMargins.setTop(n4);
        pageMargins.setLeft(n2);
        pageMargins.setRight(n3);
        IPrintOptions iPrintOptions = this.getPrintOptions();
        PageMargins pageMargins2 = (PageMargins)iPrintOptions.getPageMargins();
        if (pageMargins2 != null && pageMargins2.hasContent(pageMargins)) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("PageMargins", pageMargins);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("PageMargins", iPrintOptions.getPageMargins());
        this.a(propertyBag, propertyBag2);
    }

    public void modifyUserPaperSize(int n2, int n3) throws ReportSDKException {
        if (n3 >= o || n2 >= o) {
            String string = "Error_PrinterPaperSizeError";
            ReportSDKException.throwReportSDKException(-2147215366, SDKResourceManager.getString(string, this.getLocale()));
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putIntValue("CustomPaperHeight", n2);
        propertyBag.putIntValue("CustomPaperWidth", n3);
        IPrintOptions iPrintOptions = this.getPrintOptions();
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        if (iPrintOptions != null) {
            PageMargins pageMargins;
            int n6;
            bl2 = iPrintOptions.getDissociatePageSizeAndPrinterPaperSize();
            boolean bl3 = iPrintOptions.getPaperOrientation() == PaperOrientation.landscape;
            int n7 = bl3 ? n2 : n3;
            int n8 = n6 = bl3 ? n3 : n2;
            if (iPrintOptions.getPageMargins() != null && (n7 <= (pageMargins = (PageMargins)iPrintOptions.getPageMargins()).getLeft() + pageMargins.getRight() || n6 <= pageMargins.getTop() + pageMargins.getBottom())) {
                String string = "Error_PrinterPaperSizeError";
                ReportSDKException.throwReportSDKException(-2147215366, SDKResourceManager.getString(string, this.getLocale()));
                return;
            }
            n4 = iPrintOptions.getContentHeight();
            n5 = iPrintOptions.getContentWidth();
            if (iPrintOptions.getPageMargins() != null) {
                n4 += iPrintOptions.getPageMargins().getTop() + iPrintOptions.getPageMargins().getBottom();
                n5 += iPrintOptions.getPageMargins().getLeft() + iPrintOptions.getPageMargins().getRight();
            }
        }
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.putIntValue("CustomPaperHeight", n4);
        propertyBag2.putIntValue("CustomPaperWidth", n5);
        propertyBag.putBooleanValue("DissociatePageSizeAndPrinterPaperSize", bl2);
        this.a(propertyBag, propertyBag2);
    }

    public void modifyPrinterName(String string) throws ReportSDKException {
        if (string == null) {
            return;
        }
        IPrintOptions iPrintOptions = this.getPrintOptions();
        String string2 = iPrintOptions.getPrinterName();
        if (string.equalsIgnoreCase(string2)) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putStringValue("PrinterName", string);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("PrinterName", string2);
        this.a(propertyBag, propertyBag2);
    }

    public void modifyPaperOrientation(PaperOrientation paperOrientation) throws ReportSDKException {
        if (paperOrientation == null) {
            return;
        }
        IPrintOptions iPrintOptions = this.getPrintOptions();
        if (paperOrientation.value() == iPrintOptions.getPaperOrientation().value()) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putIntValue("PaperOrientation", paperOrientation.value());
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.putIntValue("PaperOrientation", iPrintOptions.getPaperOrientation().value());
        this.a(propertyBag, propertyBag2);
    }

    private void a(PropertyBag propertyBag, PropertyBag propertyBag2) throws ReportSDKException {
        d d10 = new d();
        d10.setController(this);
        d10.void(false);
        d10.a(propertyBag, propertyBag2);
        this.a(d10, true);
    }

    private void if(int n2) throws ReportSDKException {
        int n3 = 0;
        ReportDocument reportDocument = this.p.getReportDocument();
        Areas areas = reportDocument.getReportDefinition().getAreas();
        int n4 = areas.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            IClone iClone;
            n3 = areas.getArea(i2).getFormat() instanceof IDetailAreaFormat ? ((iClone = (IDetailAreaFormat)areas.getArea(i2).getFormat()).getEnableMultipleColumnFormatting() && iClone.getDetailWidth() < n2 ? iClone.getDetailWidth() : n2) : n2;
            iClone = areas.getArea(i2).getSections();
            int n5 = ((ArrayList)((Object)iClone)).size();
            for (int i3 = 0; i3 < n5; ++i3) {
                ((Sections)iClone).getSection(i3).setWidth(n3);
            }
        }
    }

    void new(PropertyBag propertyBag) throws ReportSDKException {
        if (propertyBag.containsKey("PrintOptions")) {
            IPrintOptions iPrintOptions = (IPrintOptions)propertyBag.get("PrintOptions");
            IPrintOptions iPrintOptions2 = this.getPrintOptions();
            if (iPrintOptions2.getContentWidth() != iPrintOptions.getContentWidth()) {
                this.if(iPrintOptions.getContentWidth());
            }
            iPrintOptions.copyTo(iPrintOptions2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAvailableMediaTrays(String string) throws ReportSDKPrinterException {
        Throwable throwable = null;
        try {
            Class<?> clazz = Class.forName("com.businessobjects.crystalreports.printer.bean.ReportPrinter");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("findAvailableMediaTrays", String.class);
            Object object = method.invoke(obj, string);
            List list = (List)object;
            return list;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        finally {
            if (throwable != null) {
                ReportSDKPrinterException.throwReportSDKPrinterException(-2147215357, throwable.getMessage(), throwable);
            }
        }
        return new ArrayList();
    }

    public void printReport(PrinterJob printerJob, List<IRequestContext> list) throws ReportSDKPrinterException, CancellationException {
        IReportPrinter iReportPrinter = this.g();
        iReportPrinter.setContexts(list);
        try {
            if (printerJob == null) {
                iReportPrinter.print();
            } else {
                iReportPrinter.print(printerJob);
            }
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Exception exception) {
            ReportSDKPrinterException.throwReportSDKPrinterException(-2147215357, exception.getMessage(), exception);
        }
    }

    public void printReport(PrintReportOptions printReportOptions) throws ReportSDKPrinterException {
        IReportPrinter iReportPrinter = this.g();
        try {
            if (printReportOptions == null) {
                iReportPrinter.print();
            } else {
                iReportPrinter.print(printReportOptions);
            }
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Exception exception) {
            ReportSDKPrinterException.throwReportSDKPrinterException(-2147215357, exception.getMessage(), exception);
        }
    }

    private synchronized IReportPrinter g() throws ReportSDKPrinterException {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName("com.businessobjects.crystalreports.printer.bean.ReportPrinter");
            this.n = (IReportPrinter)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            ReportSDKPrinterException.throwReportSDKPrinterException(-2147215357, reflectiveOperationException.getMessage(), reflectiveOperationException);
        }
        this.n.setReportSource(this.p.x());
        this.n.addPrintProgressListener(new a());
        return this.n;
    }

    private synchronized void a(String string, Object object) {
        this.m.put(string, object);
    }

    private synchronized void h() {
        this.m.clear();
    }

    private static ReportSDKException a(ReportSDKExceptionBase reportSDKExceptionBase) {
        ReportSDKException reportSDKException;
        if (reportSDKExceptionBase instanceof ReportSDKException) {
            reportSDKException = (ReportSDKException)reportSDKExceptionBase;
        } else {
            reportSDKException = new ReportSDKException(reportSDKExceptionBase.errorCode(), reportSDKExceptionBase.getMessage(), reportSDKExceptionBase.getCause());
            reportSDKException.setStackTrace(reportSDKExceptionBase.getStackTrace());
        }
        return reportSDKException;
    }

    synchronized void f() throws ReportSDKException {
        if (this.n != null) {
            try {
                this.n.cancel();
            }
            catch (ReportSDKExceptionBase reportSDKExceptionBase) {
                throw PrintOutputController.a(reportSDKExceptionBase);
            }
        }
    }

    synchronized Map<String, Object> e() {
        return this.m;
    }

    private class a
    implements IPrintProgressListener {
        private a() {
        }

        public void printingStarted(IReportSource iReportSource) {
            PrintOutputController.this.a("print_current_page", -1);
            PrintOutputController.this.a("print_precentage_complete", 0.0);
        }

        public void printingProgress(IReportSource iReportSource, int n2, float f7) {
            PrintOutputController.this.a("print_current_page", n2);
            PrintOutputController.this.a("print_precentage_complete", f7);
        }

        public void printingCancelled(IReportSource iReportSource) {
            PrintOutputController.this.h();
        }

        public void printingComplete(IReportSource iReportSource) {
            PrintOutputController.this.h();
        }
    }
}

