/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.string;

import com.crystaldecisions.reports.common.StringUtil;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.locale.FormatterCache;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

class y
extends FormulaFunctionBase {
    public y(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
        super(string, string2, formulaFunctionArgumentDefinitionArray);
    }

    public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        return FormulaValueType.number;
    }

    public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        FormulaValue formulaValue = formulaValueReferenceArray[0].getFormulaValue();
        if (formulaValue.getFormulaValueType().isNumeric()) {
            if (formulaValue instanceof CurrencyValue) {
                return NumberValue.fromCurrencyValue((CurrencyValue)((CurrencyValue)formulaValue));
            }
            return formulaValue;
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.bool) {
            BooleanValue booleanValue = (BooleanValue)formulaValue;
            if (booleanValue.getBoolean()) {
                return NumberValue.one;
            }
            return NumberValue.zero;
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.string) {
            String string = ((StringValue)formulaValue).getString();
            string = string.trim();
            Locale locale = formulaEnvironment.getFormulaContext().getLocale();
            DecimalFormat decimalFormat = FormatterCache.GetDecimalFormatter((Locale)locale);
            DecimalFormat decimalFormat2 = FormatterCache.GetDecimalCurrencyFormatter((Locale)locale);
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat2.getDecimalFormatSymbols();
            String string2 = decimalFormatSymbols.getCurrencySymbol();
            String string3 = StringUtil.removeNegativeSymbol((String)(string = StringUtil.removeCurrencySymbol((String)string, (String)string2)));
            boolean bl2 = string3.compareTo(string) != 0;
            try {
                Number number = decimalFormat.parse(string3);
                double d10 = number.doubleValue();
                if (bl2) {
                    d10 = -d10;
                }
                return NumberValue.fromDouble((double)d10);
            }
            catch (ParseException parseException) {
                throw new FormulaFunctionArgumentException("JRC00002489", "", FormulaResources.a(), "StringIsNonNumeric", 0);
            }
        }
        CrystalAssert.ASSERT((boolean)false);
        return formulaValue;
    }
}

