/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.image;

import com.crystaldecisions.reports.common.CrystalGraphicsUtil;
import com.crystaldecisions.reports.common.ICrystalImage;
import com.crystaldecisions.reports.common.JavaImage;
import com.crystaldecisions.reports.common.JpegEncoder;
import com.crystaldecisions.reports.common.TwipSize;
import com.crystaldecisions.reports.common.io.EndianReader;
import com.crystaldecisions.reports.common.io.EndianWriter;
import com.crystaldecisions.reports.common.io.IEndianReader;
import com.crystaldecisions.reports.common.io.IEndianWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ImageUtils {
    public static final byte[] a = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

    private ImageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(String string) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            BITMAPFILEHEADER bITMAPFILEHEADER = new BITMAPFILEHEADER();
            bITMAPFILEHEADER.a(bufferedInputStream);
            int n2 = bITMAPFILEHEADER.if - 14;
            byte[] byArray = new byte[n2];
            ((InputStream)bufferedInputStream).read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static void a(boolean bl2, BITMAPINFOHEADER bITMAPINFOHEADER, byte[] byArray, OutputStream outputStream) throws FileNotFoundException, IOException {
        if (null == bITMAPINFOHEADER || null == byArray) {
            throw new IllegalArgumentException();
        }
        if (bl2) {
            BITMAPFILEHEADER bITMAPFILEHEADER = new BITMAPFILEHEADER();
            bITMAPFILEHEADER.if = bITMAPINFOHEADER.biSizeImage + 14;
            bITMAPFILEHEADER.int = 54;
            int n2 = 0;
            switch (bITMAPINFOHEADER.biBitCount) {
                case 1: 
                case 4: 
                case 8: 
                case 16: {
                    n2 = 1 << bITMAPINFOHEADER.biBitCount;
                }
            }
            if (bITMAPINFOHEADER.biClrUsed != 0) {
                n2 = bITMAPINFOHEADER.biClrUsed;
            }
            bITMAPFILEHEADER.int += n2 * 4;
            bITMAPFILEHEADER.a(outputStream);
        }
        bITMAPINFOHEADER.write(outputStream);
        outputStream.write(byArray);
    }

    public static BITMAPINFOHEADER do(byte[] byArray) {
        return ImageUtils.a(byArray, 0, byArray.length);
    }

    public static BITMAPINFOHEADER a(byte[] byArray, int n2, int n3) {
        if (null == byArray || n3 < 40 || byArray.length < n2) {
            return null;
        }
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            byteArrayInputStream.skip(n2);
            bITMAPINFOHEADER.read(byteArrayInputStream);
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return bITMAPINFOHEADER;
    }

    public static byte[] a(byte[] byArray, boolean bl2, int n2) {
        if (null == byArray || 0 == byArray.length) {
            throw new IllegalArgumentException("Cannot convert NULL image");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length / 2);
        try {
            ImageUtils.a(byArray, bl2, n2, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void a(byte[] byArray, boolean bl2, int n2, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        int n3;
        if (null == byArray || 0 == byArray.length) {
            throw new IllegalArgumentException("Cannot convert NULL image");
        }
        BITMAPINFOHEADER bITMAPINFOHEADER = ImageUtils.do(byArray);
        if (null == bITMAPINFOHEADER || 40 != bITMAPINFOHEADER.biSize) {
            throw new RasterFormatException("Invalid bitmap");
        }
        int n4 = 4;
        int n5 = 5;
        int n6 = (n3 >> 2 << 2) + (((n3 = bITMAPINFOHEADER.biWidth * (bITMAPINFOHEADER.biBitCount >> 3)) & 3) != 0 ? 4 : 0);
        int n7 = bITMAPINFOHEADER.biBitCount >> 3;
        int n8 = bITMAPINFOHEADER.biSize + (1 << bITMAPINFOHEADER.biBitCount) * 4;
        int n9 = n6 * bITMAPINFOHEADER.biHeight;
        DataBufferByte dataBufferByte = null;
        ComponentSampleModel componentSampleModel = null;
        IndexColorModel indexColorModel = null;
        if (0 != bITMAPINFOHEADER.biClrUsed) {
            n8 = bITMAPINFOHEADER.biSize + bITMAPINFOHEADER.biClrUsed * 4;
        }
        switch (bITMAPINFOHEADER.biBitCount) {
            case 1: {
                n3 = (bITMAPINFOHEADER.biWidth >> 3) + ((bITMAPINFOHEADER.biWidth & 3) != 0 ? 1 : 0);
                n5 = 12;
                break;
            }
            case 4: {
                n3 = (bITMAPINFOHEADER.biWidth >> 1) + ((bITMAPINFOHEADER.biWidth & 1) != 0 ? 1 : 0);
                n5 = 12;
                break;
            }
            case 8: {
                n5 = 13;
                int n10 = 256;
                if (0 != bITMAPINFOHEADER.biClrUsed) {
                    n10 = bITMAPINFOHEADER.biClrUsed;
                    n8 = bITMAPINFOHEADER.biSize + n10 * 4;
                }
                object2 = new byte[n10];
                object = new byte[n10];
                byte[] byArray2 = new byte[n10];
                int n11 = bITMAPINFOHEADER.biSize;
                for (int i2 = 0; i2 < n10; ++i2) {
                    object2[i2] = byArray[n11 + 0];
                    object[i2] = byArray[n11 + 1];
                    byArray2[i2] = byArray[n11 + 2];
                    n11 += 4;
                }
                indexColorModel = new IndexColorModel(8, n10, (byte[])object2, (byte[])object, byArray2);
                int[] nArray = new int[]{0};
                componentSampleModel = new ComponentSampleModel(0, bITMAPINFOHEADER.biWidth, bITMAPINFOHEADER.biHeight, n7, n6, nArray);
                dataBufferByte = new DataBufferByte(byArray, n9, n8);
                break;
            }
            case 16: {
                n5 = 8;
                break;
            }
            case 24: {
                n5 = 5;
                n8 = bITMAPINFOHEADER.biSize;
                int[] nArray = new int[]{2, 1, 0};
                componentSampleModel = new ComponentSampleModel(0, bITMAPINFOHEADER.biWidth, bITMAPINFOHEADER.biHeight, n7, n6, nArray);
                dataBufferByte = new DataBufferByte(byArray, n9, n8);
                break;
            }
            case 32: {
                n5 = 6;
                n8 = bITMAPINFOHEADER.biSize;
                int[] nArray = new int[]{0, 1, 2, 3};
                componentSampleModel = new PixelInterleavedSampleModel(0, bITMAPINFOHEADER.biWidth, bITMAPINFOHEADER.biHeight, n7, n6, nArray);
                dataBufferByte = new DataBufferByte(byArray, n9, n8);
                break;
            }
            default: {
                throw new RasterFormatException("invalid bitcount");
            }
        }
        if (null == componentSampleModel || null == dataBufferByte) {
            throw new RasterFormatException("Unknown/unimplemented data format");
        }
        Raster raster = Raster.createRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        object2 = null;
        object2 = null == indexColorModel ? (Object)new BufferedImage(bITMAPINFOHEADER.biWidth, bITMAPINFOHEADER.biHeight, n5) : (Object)new BufferedImage(bITMAPINFOHEADER.biWidth, bITMAPINFOHEADER.biHeight, n5, indexColorModel);
        ((BufferedImage)object2).setData(raster);
        object = new JpegEncoder((Image)object2, n2, outputStream, bl2, new TwipSize(bITMAPINFOHEADER.biWidth, bITMAPINFOHEADER.biHeight));
        ((JpegEncoder)object).if();
        object = null;
    }

    public static long a(int n2, int n3) {
        long l2 = (long)((double)(n2 * n3) / 8.0 + 0.9);
        if ((l2 & 3L) != 0L) {
            l2 += 4L - (l2 & 3L);
        }
        return l2;
    }

    public static void a(byte[] byArray, int n2, boolean bl2) {
        byte by2 = a[n2 % 8];
        if (bl2) {
            int n3 = n2 / 8;
            byArray[n3] = (byte)(byArray[n3] | by2);
        } else {
            int n4 = n2 / 8;
            byArray[n4] = (byte)(byArray[n4] & ~by2);
        }
    }

    public static final int a(int n2) {
        if (n2 <= 2) {
            return 1;
        }
        if (n2 <= 16) {
            return 4;
        }
        if (n2 <= 256) {
            return 8;
        }
        if (n2 <= 65536) {
            return 16;
        }
        return 24;
    }

    public static final int if(int n2) {
        switch (n2) {
            case 1: {
                return 2;
            }
            case 4: {
                return 16;
            }
            case 8: {
                return 256;
            }
            case 16: 
            case 24: 
            case 32: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final int a(int n2, int n3, int n4, int n5) {
        return 0xF000 & n5 << 12 | 0xF00 & n4 << 8 | 0xF0 & n3 << 4 | 0xF & n2;
    }

    public static final int if(int n2, int n3, int n4, int n5) {
        return 0xF000 & n2 << 12 | 0xF00 & n3 << 8 | 0xF0 & n4 << 4 | 0xF & n5;
    }

    public static boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static ICrystalImage a(String string, Font font, int n2, int n3) {
        int n4;
        int n5 = CrystalGraphicsUtil.GetScreenResolution();
        int n6 = CrystalGraphicsUtil.TwipsToPixelsInt((int)n5, (long)n2);
        int n7 = CrystalGraphicsUtil.TwipsToPixelsInt((int)n5, (long)n3);
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, n6, n7);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.BLACK);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds(string, graphics2D).getBounds();
        int n8 = (int)Math.floor((double)(n6 / 2) - rectangle.getCenterX());
        if (n8 < 0) {
            n8 = 0;
        }
        if ((n4 = (int)Math.ceil(rectangle.getHeight())) > n7) {
            n4 = n7;
        }
        graphics2D.drawString(string, n8, n4);
        return new JavaImage(bufferedImage);
    }

    public static ImageInfo if(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return ImageUtils.a(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo a(InputStream inputStream) {
        ImageInputStream imageInputStream = null;
        ImageInfo imageInfo = new ImageInfo();
        try {
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                ImageInfo imageInfo2 = null;
                return imageInfo2;
            }
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            Node node = iIOMetadata.getAsTree("javax_imageio_1.0");
            imageInfo.a = ImageUtils.a(ImageUtils.a(node, "Dimension.HorizontalPixelSize"));
            imageInfo.if = ImageUtils.a(ImageUtils.a(node, "Dimension.VerticalPixelSize"));
        }
        catch (Exception exception) {
            ImageInfo imageInfo3 = null;
            return imageInfo3;
        }
        finally {
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {
                    imageInfo = null;
                }
            }
        }
        return imageInfo;
    }

    private static float a(Node node) {
        if (node == null) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(node.getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    private static Node a(Node node, String string) {
        if (string == null || node == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        int n2 = string.indexOf(46);
        boolean bl2 = n2 < 0;
        String string2 = bl2 ? string : string.substring(0, n2);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!node2.getNodeName().equals(string2)) continue;
            if (bl2) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                return namedNodeMap == null ? null : namedNodeMap.item(0);
            }
            return ImageUtils.a(node2, string.substring(n2 + 1));
        }
        return null;
    }

    public static BITMAPFILEHEADER a(byte[] byArray) {
        if (null == byArray || byArray.length < 40) {
            return null;
        }
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            bITMAPINFOHEADER.read(byteArrayInputStream);
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        int n2 = bITMAPINFOHEADER.biSizeImage;
        if (n2 == 0) {
            int n3 = (bITMAPINFOHEADER.biWidth * bITMAPINFOHEADER.biBitCount + 31 & 0xFFFFFFE0) >> 3;
            n2 = n3 * bITMAPINFOHEADER.biHeight;
        }
        BITMAPFILEHEADER bITMAPFILEHEADER = new BITMAPFILEHEADER();
        bITMAPFILEHEADER.if = n2 + bITMAPINFOHEADER.biSize + 14;
        bITMAPFILEHEADER.int = 14 + bITMAPINFOHEADER.biSize;
        int n4 = 0;
        switch (bITMAPINFOHEADER.biBitCount) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                n4 = 1 << bITMAPINFOHEADER.biBitCount;
            }
        }
        if (bITMAPINFOHEADER.biClrUsed != 0) {
            n4 = bITMAPINFOHEADER.biClrUsed;
        }
        bITMAPFILEHEADER.if += n4 * 4;
        bITMAPFILEHEADER.int += n4 * 4;
        return bITMAPFILEHEADER;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ImageInfo {
        private float a;
        private float if;

        public int if() {
            if (Float.isNaN(this.a)) {
                return -1;
            }
            return Math.round(25.4f / this.a);
        }

        public int a() {
            if (Float.isNaN(this.if)) {
                return -1;
            }
            return Math.round(25.4f / this.if);
        }
    }

    public static final class BITMAPINFOHEADER {
        public static final int SIZEOF_BITMAPINFOHEADER = 40;
        public static final int BI_RGB = 0;
        public static final int BI_RLE8 = 1;
        public static final int BI_RLE4 = 2;
        public static final int BI_BITFIELDS = 3;
        public int biSize = 40;
        public int biWidth;
        public int biHeight;
        public short biPlanes = 1;
        public short biBitCount;
        public int biCompression;
        public int biSizeImage;
        public int biXPelsPerMeter = 0;
        public int biYPelsPerMeter = 0;
        public int biClrUsed = 0;
        public int biClrImportant = 0;

        public void read(InputStream inputStream) throws IOException {
            EndianReader endianReader = new EndianReader(inputStream);
            this.biSize = endianReader.try();
            this.biWidth = endianReader.try();
            this.biHeight = endianReader.try();
            this.biPlanes = endianReader.char();
            this.biBitCount = endianReader.char();
            this.biCompression = endianReader.try();
            this.biSizeImage = endianReader.try();
            this.biXPelsPerMeter = endianReader.try();
            this.biYPelsPerMeter = endianReader.try();
            this.biClrUsed = endianReader.try();
            this.biClrImportant = endianReader.try();
            endianReader.new();
        }

        public void write(OutputStream outputStream) throws IOException {
            EndianWriter endianWriter = new EndianWriter(outputStream);
            endianWriter.if(this.biSize);
            endianWriter.if(this.biWidth);
            endianWriter.if(this.biHeight);
            endianWriter.a(this.biPlanes);
            endianWriter.a(this.biBitCount);
            endianWriter.if(this.biCompression);
            endianWriter.if(this.biSizeImage);
            endianWriter.if(this.biXPelsPerMeter);
            endianWriter.if(this.biYPelsPerMeter);
            endianWriter.if(this.biClrUsed);
            endianWriter.if(this.biClrImportant);
            endianWriter.new();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class BITMAPFILEHEADER {
        public static final int new = 14;
        public short for = (short)19778;
        public int if;
        public short do = 0;
        public short a = 0;
        public int int;

        public void a(InputStream inputStream) throws IOException {
            EndianReader endianReader = new EndianReader(inputStream);
            this.for = endianReader.char();
            this.if = endianReader.try();
            inputStream.skip(4L);
            this.int = endianReader.try();
            endianReader.new();
        }

        public void a(OutputStream outputStream) throws IOException {
            EndianWriter endianWriter = new EndianWriter(outputStream);
            endianWriter.a(this.for);
            endianWriter.if(this.if);
            endianWriter.a(this.do);
            endianWriter.a(this.a);
            endianWriter.if(this.int);
            endianWriter.new();
        }
    }

    public static final class DIBColor
    extends Color
    implements Comparable {
        private final IEndianWriter a = new EndianWriter();

        public DIBColor(float f7, float f8, float f9) {
            super(f7, f8, f9);
        }

        public DIBColor(float f7, float f8, float f9, float f10) {
            super(f7, f8, f9, f10);
        }

        public DIBColor(int n2) {
            super(n2);
        }

        public DIBColor(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        public DIBColor(int n2, int n3, int n4, int n5) {
            super(n2, n3, n4, n5);
        }

        public void a(OutputStream outputStream, boolean bl2) throws IOException {
            this.a.a(outputStream);
            this.a(this.a, bl2);
            this.a.new();
        }

        public void a(IEndianWriter iEndianWriter, boolean bl2) throws IOException {
            iEndianWriter.do(this.getRed());
            iEndianWriter.do(this.getGreen());
            iEndianWriter.do(this.getBlue());
            if (bl2) {
                iEndianWriter.do(this.getAlpha());
            }
        }

        public static DIBColor a(IEndianReader iEndianReader, boolean bl2) throws IOException {
            byte by2 = iEndianReader.case();
            byte by3 = iEndianReader.case();
            byte by4 = iEndianReader.case();
            int n2 = 0;
            if (bl2) {
                iEndianReader.case();
            }
            return new DIBColor(by2, by3, by4, n2);
        }

        public static void a(Color color, IEndianWriter iEndianWriter, boolean bl2) throws IOException {
            iEndianWriter.do(color.getRed());
            iEndianWriter.do(color.getGreen());
            iEndianWriter.do(color.getBlue());
            if (bl2) {
                iEndianWriter.do(color.getAlpha());
            }
        }

        public int compareTo(Object object) {
            int n2;
            if (!(object instanceof Color)) {
                throw new ClassCastException();
            }
            int n3 = this.getRGB();
            return n3 < (n2 = ((Color)object).getRGB()) ? -1 : (n3 == n2 ? 0 : 1);
        }
    }
}

