/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.report.web.shared;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIUtil {
    private static final char[] hexadecimal;
    private static final BitSet alpha;
    private static final BitSet alphanum;
    private static final BitSet reserved;
    private static final BitSet mark;
    private static final BitSet unreserved;
    private static final BitSet delims;
    private static final BitSet unwise;
    private static final BitSet pathReserved;
    private static final BitSet pathSafe;
    private static final BitSet queryStringValueSafe;

    private static final byte convertHexDigit(byte b10) {
        switch (b10) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return (byte)(b10 - 48);
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return (byte)(b10 - 97 + 10);
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return (byte)(b10 - 65 + 10);
            }
        }
        throw new IllegalArgumentException(b10 + " is not a hex value");
    }

    public static final String decode(byte[] bytes) {
        try {
            return URIUtil.decode(bytes, null, false);
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, int off, int len) {
        try {
            return URIUtil.decode(bytes, off, len, null, false);
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, int off, int len, String enc) throws UnsupportedEncodingException {
        return URIUtil.decode(bytes, 0, bytes.length, enc, false);
    }

    public static final String decode(byte[] bytes, int off, int len, String enc, boolean plusIsSpace) throws UnsupportedEncodingException {
        if (null == bytes) {
            return null;
        }
        int end = off + len;
        int ix = off;
        int ox = off;
        while (ix < end) {
            int b10 = bytes[ix++];
            if (plusIsSpace && b10 == 43) {
                b10 = 32;
            } else if (b10 == 37) {
                b10 = (byte)((URIUtil.convertHexDigit(bytes[ix++]) << 4) + URIUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b10;
        }
        if (enc != null) {
            return new String(bytes, off, ox, enc);
        }
        return new String(bytes, off, ox);
    }

    public static final String decode(byte[] bytes, int off, int len, boolean plusIsSpace) {
        try {
            return URIUtil.decode(bytes, off, len, null, plusIsSpace);
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, String enc) throws UnsupportedEncodingException {
        return URIUtil.decode(bytes, 0, bytes.length, enc, false);
    }

    public static final String decode(byte[] bytes, String enc, boolean plusIsSpace) throws UnsupportedEncodingException {
        return URIUtil.decode(bytes, 0, bytes.length, enc, plusIsSpace);
    }

    public static final String decode(byte[] bytes, boolean plusIsSpace) {
        try {
            return URIUtil.decode(bytes, null, plusIsSpace);
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(String str) {
        return URIUtil.decode(str, false);
    }

    public static final String decode(String str, boolean plusIsSpace) {
        try {
            return str == null ? null : URIUtil.decode(str.getBytes(), null, plusIsSpace);
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String encode(byte[] bytes, int off, int len, BitSet safe) {
        return bytes == null ? null : URIUtil.encode(bytes, 0, bytes.length, safe, false);
    }

    public static final String encode(byte[] bytes, int off, int len, BitSet safe, boolean spaceAsPlus) {
        if (null == bytes) {
            return null;
        }
        if (null == safe) {
            safe = unreserved;
        }
        StringBuffer rewrittenStr = new StringBuffer(len);
        for (int i2 = off; i2 < len; ++i2) {
            char c10 = (char)bytes[i2];
            if (safe.get(c10)) {
                rewrittenStr.append(c10);
                continue;
            }
            if (spaceAsPlus && ' ' == c10) {
                rewrittenStr.append('+');
                continue;
            }
            byte toEscape = bytes[i2];
            rewrittenStr.append('%');
            int low = toEscape & 0xF;
            int high = (toEscape & 0xF0) >> 4;
            rewrittenStr.append(hexadecimal[high]);
            rewrittenStr.append(hexadecimal[low]);
        }
        return rewrittenStr.toString();
    }

    public static final String encode(byte[] bytes, BitSet safe) {
        return bytes == null ? null : URIUtil.encode(bytes, 0, bytes.length, safe, false);
    }

    public static final String encode(byte[] bytes, BitSet safe, boolean spaceAsPlus) {
        return bytes == null ? null : URIUtil.encode(bytes, 0, bytes.length, safe, spaceAsPlus);
    }

    public static final String encode(String str) {
        return URIUtil.encode(str, null, false);
    }

    public static final String encode(String str, BitSet safe) {
        return str == null ? null : URIUtil.encode(str.getBytes(), safe, false);
    }

    public static final String encode(String str, BitSet safe, String enc) {
        return URIUtil.encode(str, safe, enc, false);
    }

    public static final String encode(String str, BitSet safe, String enc, boolean spaceAsPlus) {
        try {
            return URIUtil.encode(str.getBytes(enc), safe, spaceAsPlus);
        }
        catch (UnsupportedEncodingException e10) {
            return URIUtil.encode(str.getBytes(), safe, spaceAsPlus);
        }
    }

    public static final String encode(String str, BitSet safe, boolean spaceAsPlus) {
        return str == null ? null : URIUtil.encode(str.getBytes(), safe, spaceAsPlus);
    }

    public static final String encode(String str, boolean spaceAsPlus) {
        return URIUtil.encode(str, null, spaceAsPlus);
    }

    public static final BitSet pathSafe() {
        return pathSafe;
    }

    public static final BitSet queryStringValueSafe() {
        return queryStringValueSafe;
    }

    public static final BitSet unreserved() {
        return unreserved;
    }

    static {
        int i2;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        alpha = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            alpha.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            alpha.set(i2);
        }
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        for (i2 = 48; i2 <= 57; ++i2) {
            alphanum.set(i2);
        }
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        delims = new BitSet(256);
        delims.set(60);
        delims.set(62);
        delims.set(35);
        delims.set(37);
        delims.set(34);
        unwise = new BitSet(256);
        unwise.set(123);
        unwise.set(125);
        unwise.set(124);
        unwise.set(92);
        unwise.set(94);
        unwise.set(91);
        unwise.set(93);
        unwise.set(96);
        pathReserved = new BitSet(256);
        pathReserved.set(47);
        pathReserved.set(59);
        pathReserved.set(61);
        pathReserved.set(63);
        pathSafe = new BitSet(256);
        pathSafe.or(unreserved);
        pathSafe.or(pathReserved);
        queryStringValueSafe = new BitSet(256);
        queryStringValueSafe.or(unreserved);
    }
}

