/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int connectTimeout = -1;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    public Vector cOpts = new Vector(10, 10);

    public ConnStrategy(Properties up) {
        this.osuser = up.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = up.getProperty("oracle.jdbc.v$session.program");
        this.createSocketOptions(up);
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(Properties up) {
        String propertyKey = null;
        String propertyValue = null;
        boolean tcpNoDelayParam = false;
        Enumeration<Object> e2 = up.keys();
        while (e2.hasMoreElements()) {
            propertyKey = (String)e2.nextElement();
            if (propertyKey.equalsIgnoreCase("TCP.NODELAY")) {
                tcpNoDelayParam = true;
                propertyValue = up.getProperty("TCP.NODELAY").toUpperCase();
                if (propertyValue.equals("NO")) {
                    this.socketOptions.put((Object)0, "NO");
                    continue;
                }
                this.socketOptions.put((Object)0, "YES");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.READ_TIMEOUT");
                this.socketOptions.put((Object)3, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.CONNECT_TIMEOUT");
                this.socketOptions.put((Object)2, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                propertyValue = up.getProperty("oracle.net.ssl_server_dn_match");
                this.socketOptions.put((Object)4, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_location")) {
                propertyValue = up.getProperty("oracle.net.wallet_location");
                this.socketOptions.put((Object)5, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_password")) {
                propertyValue = up.getProperty("oracle.net.wallet_password");
                this.socketOptions.put((Object)16, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_version")) {
                propertyValue = up.getProperty("oracle.net.ssl_version");
                this.socketOptions.put((Object)6, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                propertyValue = up.getProperty("oracle.net.ssl_cipher_suites");
                this.socketOptions.put((Object)7, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStore");
                this.socketOptions.put((Object)8, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStoreType");
                this.socketOptions.put((Object)9, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStorePassword");
                this.socketOptions.put((Object)10, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStore");
                this.socketOptions.put((Object)11, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStoreType");
                this.socketOptions.put((Object)12, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStorePassword");
                this.socketOptions.put((Object)13, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                propertyValue = up.getProperty("ssl.keyManagerFactory.algorithm");
                this.socketOptions.put((Object)14, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                propertyValue = up.getProperty("FORCE_DNS_LOAD_BALANCING");
                this.socketOptions.put((Object)18, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.SDP")) {
                propertyValue = up.getProperty("oracle.net.SDP");
                this.socketOptions.put((Object)19, propertyValue);
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("oracle.net.keepAlive")) continue;
            propertyValue = up.getProperty("oracle.net.keepAlive");
            if (Boolean.parseBoolean(propertyValue)) {
                this.socketOptions.put((Object)1, "YES");
                continue;
            }
            this.socketOptions.put((Object)1, "NO");
        }
        if (!tcpNoDelayParam && !this.reuseOpt) {
            this.socketOptions.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean keepAlive) {
        if (keepAlive) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addOption(ConnOption cOption) {
        this.cOpts.addElement(cOption);
    }

    public boolean hasMoreOptions() {
        return this.nextOptToTry < this.cOpts.size();
    }

    public ConnOption execute() throws NetException {
        IOException causeException = null;
        if (this.connectTimeout == -1) {
            if (this.socketOptions.get(2) == null) {
                this.socketOptions.put((Object)2, Integer.toString(60000));
            }
        } else {
            this.socketOptions.put((Object)2, Integer.toString(this.connectTimeout));
        }
        if (this.retryCount < 0) {
            this.retryCount = 0;
        }
        this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
        for (int i2 = this.lastRetryCounter; i2 <= this.retryCount; ++i2) {
            while (this.nextOptToTry < this.cOpts.size()) {
                try {
                    this.copt = (ConnOption)this.cOpts.elementAt(this.nextOptToTry);
                    this.copt.connect(this.socketOptions);
                    this.copt.sdu = this.sdu;
                    this.copt.tdu = this.tdu;
                    this.optFound = true;
                    ++this.nextOptToTry;
                    this.lastRetryCounter = i2;
                    return this.copt;
                }
                catch (IOException err) {
                    ++this.nextOptToTry;
                    causeException = err;
                }
            }
            this.nextOptToTry = 0;
        }
        if (causeException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(causeException);
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.cOpts.removeAllElements();
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }
}

