/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class OracleXAException
extends XAException {
    private int xaError = 0;
    private int primary = 0;
    private int secondary = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleXAException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAException(int error) {
        super(OracleXAException.errorConvert(error));
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(error));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.xaError = OracleXAException.errorConvert(error);
            this.primary = error & 0xFFFF;
            this.secondary = error >> 16;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleXAException(int error, int _xaError) {
        super(OracleXAException.errorConvert(error, _xaError));
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(error) + ", " + OracleLog.argument(_xaError));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.xaError = OracleXAException.errorConvert(error, _xaError);
            this.primary = error & 0xFFFF;
            this.secondary = error >> 16;
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    public OracleXAException(SQLException sqlex, int _xaError) {
        this(sqlex.getErrorCode(), _xaError);
        this.initCause(sqlex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, int error) {
        OracleXAException oracleXAException;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(error));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((xacode = (xaexc = new OracleXAException(error)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleXAException = xaexc;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleXAException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, int error, int xaerror) {
        OracleXAException oracleXAException;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(error) + ", " + OracleLog.argument(xaerror));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((xacode = (xaexc = new OracleXAException(error, xaerror)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleXAException = xaexc;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleXAException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, SQLException sqlexc, int xaerror) {
        OracleXAException oracleXAException;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sqlexc) + ", " + OracleLog.argument(xaerror));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((xacode = (xaexc = new OracleXAException(sqlexc, xaerror)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleXAException = xaexc;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleXAException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int errorConvert(int err) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(err));
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int __result__ = OracleXAException.errorConvert(err, -3);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = __result__;
            Object var6_9 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleXAException.logger().log(Level.FINER, "         Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int errorConvert(int err, int defaultErrorCode) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(err) + ", " + OracleLog.argument(defaultErrorCode));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            switch (err & 0xFFFF) {
                case 24756: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -4");
                            Object var5_15 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var5_16 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n3 = -4;
                    Object var25_18 = null;
                    if (!TRACE) return n3;
                    if (!OracleLog.recursiveEnter()) return n3;
                    try {
                        OracleXAException.logger().log(Level.FINER, "         Exit");
                        Object var27_29 = null;
                        OracleLog.recursiveExit();
                        return n3;
                    }
                    catch (Throwable throwable) {
                        Object var27_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                case 25351: 
                case 30006: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 4");
                            Object var7_62 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var7_63 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n4 = 4;
                    Object var25_19 = null;
                    if (!TRACE) return n4;
                    if (!OracleLog.recursiveEnter()) return n4;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_32 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_31 = null;
                    OracleLog.recursiveExit();
                    return n4;
                }
                case 24764: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 7");
                            Object var9_65 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_66 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n5 = 7;
                    Object var25_20 = null;
                    if (!TRACE) return n5;
                    if (!OracleLog.recursiveEnter()) return n5;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_34 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_33 = null;
                    OracleLog.recursiveExit();
                    return n5;
                }
                case 24765: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 6");
                            Object var11_68 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var11_69 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n6 = 6;
                    Object var25_21 = null;
                    if (!TRACE) return n6;
                    if (!OracleLog.recursiveEnter()) return n6;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_36 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_35 = null;
                    OracleLog.recursiveExit();
                    return n6;
                }
                case 24766: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 5");
                            Object var13_71 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var13_72 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n7 = 5;
                    Object var25_22 = null;
                    if (!TRACE) return n7;
                    if (!OracleLog.recursiveEnter()) return n7;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_38 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_37 = null;
                    OracleLog.recursiveExit();
                    return n7;
                }
                case 24767: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 3");
                            Object var15_74 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var15_75 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n8 = 3;
                    Object var25_23 = null;
                    if (!TRACE) return n8;
                    if (!OracleLog.recursiveEnter()) return n8;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_40 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_39 = null;
                    OracleLog.recursiveExit();
                    return n8;
                }
                case 28: 
                case 1031: 
                case 1033: 
                case 1034: 
                case 1041: 
                case 1089: 
                case 1090: 
                case 1092: 
                case 3113: 
                case 3114: 
                case 12571: 
                case 17002: 
                case 17008: 
                case 17410: 
                case 24796: 
                case 25400: 
                case 25401: 
                case 25402: 
                case 25403: 
                case 25404: 
                case 25405: 
                case 25406: 
                case 25407: 
                case 25408: 
                case 25409: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -7");
                            Object var17_77 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var17_78 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n9 = -7;
                    Object var25_24 = null;
                    if (!TRACE) return n9;
                    if (!OracleLog.recursiveEnter()) return n9;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_42 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_41 = null;
                    OracleLog.recursiveExit();
                    return n9;
                }
                case 2056: 
                case 17448: 
                case 24763: 
                case 24768: 
                case 24769: 
                case 24770: 
                case 24775: 
                case 24776: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -6");
                            Object var19_80 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var19_81 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n10 = -6;
                    Object var25_25 = null;
                    if (!TRACE) return n10;
                    if (!OracleLog.recursiveEnter()) return n10;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_44 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_43 = null;
                    OracleLog.recursiveExit();
                    return n10;
                }
                case 2091: 
                case 2092: 
                case 24761: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 100");
                            Object var21_83 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var21_84 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n11 = 100;
                    Object var25_26 = null;
                    if (!TRACE) return n11;
                    if (!OracleLog.recursiveEnter()) return n11;
                    try {}
                    catch (Throwable throwable) {
                        Object var27_46 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var27_45 = null;
                    OracleLog.recursiveExit();
                    return n11;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + defaultErrorCode);
                    Object var23_86 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var23_87 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = defaultErrorCode;
            Object var25_27 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var27_50 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            Object var27_49 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {}
        catch (Throwable throwable) {
            Object var27_48 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleXAException.logger().log(Level.FINER, "         Exit");
        Object var27_47 = null;
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getXAError() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaError);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.xaError;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOracleError() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.primary);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.primary;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOracleSQLError() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.secondary);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.secondary;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getXAErrorMessage(int eCode) {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(eCode));
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            switch (eCode) {
                case 7: {
                    String string2 = "The transaction branch has been heuristically committed.";
                    Object var4_28 = null;
                    if (!TRACE) return string2;
                    if (!OracleLog.recursiveEnter()) return string2;
                    try {
                        OracleXAException.logger().log(Level.FINER, "         Exit");
                        Object var6_53 = null;
                        OracleLog.recursiveExit();
                        return string2;
                    }
                    catch (Throwable throwable) {
                        Object var6_54 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                case 8: {
                    String string3 = "The transaction branch may have been heuristically completed.";
                    Object var4_29 = null;
                    if (!TRACE) return string3;
                    if (!OracleLog.recursiveEnter()) return string3;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_56 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_55 = null;
                    OracleLog.recursiveExit();
                    return string3;
                }
                case 5: {
                    String string4 = "The transaction branch has been heuristically committed and rolled back.";
                    Object var4_30 = null;
                    if (!TRACE) return string4;
                    if (!OracleLog.recursiveEnter()) return string4;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_58 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_57 = null;
                    OracleLog.recursiveExit();
                    return string4;
                }
                case 6: {
                    String string5 = "The transaction branch has been heuristically rolled back.";
                    Object var4_31 = null;
                    if (!TRACE) return string5;
                    if (!OracleLog.recursiveEnter()) return string5;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_60 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_59 = null;
                    OracleLog.recursiveExit();
                    return string5;
                }
                case 9: {
                    String string6 = "Resumption must occur where suspension occured.";
                    Object var4_32 = null;
                    if (!TRACE) return string6;
                    if (!OracleLog.recursiveEnter()) return string6;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_62 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_61 = null;
                    OracleLog.recursiveExit();
                    return string6;
                }
                case 100: {
                    String string7 = "The inclusive lower bound oof the rollback codes.";
                    Object var4_33 = null;
                    if (!TRACE) return string7;
                    if (!OracleLog.recursiveEnter()) return string7;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_64 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_63 = null;
                    OracleLog.recursiveExit();
                    return string7;
                }
                case 101: {
                    String string8 = "Rollback was caused by communication failure.";
                    Object var4_34 = null;
                    if (!TRACE) return string8;
                    if (!OracleLog.recursiveEnter()) return string8;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_66 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_65 = null;
                    OracleLog.recursiveExit();
                    return string8;
                }
                case 102: {
                    String string9 = "A deadlock was detected.";
                    Object var4_35 = null;
                    if (!TRACE) return string9;
                    if (!OracleLog.recursiveEnter()) return string9;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_68 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_67 = null;
                    OracleLog.recursiveExit();
                    return string9;
                }
                case 107: {
                    String string10 = "The inclusive upper bound of the rollback error code.";
                    Object var4_36 = null;
                    if (!TRACE) return string10;
                    if (!OracleLog.recursiveEnter()) return string10;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_70 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_69 = null;
                    OracleLog.recursiveExit();
                    return string10;
                }
                case 103: {
                    String string11 = "A condition that violates the integrity of the resource was detected.";
                    Object var4_37 = null;
                    if (!TRACE) return string11;
                    if (!OracleLog.recursiveEnter()) return string11;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_72 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_71 = null;
                    OracleLog.recursiveExit();
                    return string11;
                }
                case 104: {
                    String string12 = "The resource manager rolled back the transaction branch for a reason not on this list.";
                    Object var4_38 = null;
                    if (!TRACE) return string12;
                    if (!OracleLog.recursiveEnter()) return string12;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_74 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_73 = null;
                    OracleLog.recursiveExit();
                    return string12;
                }
                case 105: {
                    String string13 = "A protocol error occured in the resource manager.";
                    Object var4_39 = null;
                    if (!TRACE) return string13;
                    if (!OracleLog.recursiveEnter()) return string13;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_76 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_75 = null;
                    OracleLog.recursiveExit();
                    return string13;
                }
                case 106: {
                    String string14 = "A transaction branch took too long.";
                    Object var4_40 = null;
                    if (!TRACE) return string14;
                    if (!OracleLog.recursiveEnter()) return string14;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_78 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_77 = null;
                    OracleLog.recursiveExit();
                    return string14;
                }
                case 3: {
                    String string15 = "The transaction branch has been read-only and has been committed.";
                    Object var4_41 = null;
                    if (!TRACE) return string15;
                    if (!OracleLog.recursiveEnter()) return string15;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_80 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_79 = null;
                    OracleLog.recursiveExit();
                    return string15;
                }
                case 4: {
                    String string16 = "Routine returned with no effect and may be reissued.";
                    Object var4_42 = null;
                    if (!TRACE) return string16;
                    if (!OracleLog.recursiveEnter()) return string16;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_82 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_81 = null;
                    OracleLog.recursiveExit();
                    return string16;
                }
                case -2: {
                    String string17 = "Asynchronous operation already outstanding.";
                    Object var4_43 = null;
                    if (!TRACE) return string17;
                    if (!OracleLog.recursiveEnter()) return string17;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_84 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_83 = null;
                    OracleLog.recursiveExit();
                    return string17;
                }
                case -8: {
                    String string18 = "The XID already exists.";
                    Object var4_44 = null;
                    if (!TRACE) return string18;
                    if (!OracleLog.recursiveEnter()) return string18;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_86 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_85 = null;
                    OracleLog.recursiveExit();
                    return string18;
                }
                case -5: {
                    String string19 = "Invalid arguments were given.";
                    Object var4_45 = null;
                    if (!TRACE) return string19;
                    if (!OracleLog.recursiveEnter()) return string19;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_88 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_87 = null;
                    OracleLog.recursiveExit();
                    return string19;
                }
                case -4: {
                    String string20 = "The XID is not valid.";
                    Object var4_46 = null;
                    if (!TRACE) return string20;
                    if (!OracleLog.recursiveEnter()) return string20;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_90 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_89 = null;
                    OracleLog.recursiveExit();
                    return string20;
                }
                case -9: {
                    String string21 = "The resource manager is doing work outside global transaction.";
                    Object var4_47 = null;
                    if (!TRACE) return string21;
                    if (!OracleLog.recursiveEnter()) return string21;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_92 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_91 = null;
                    OracleLog.recursiveExit();
                    return string21;
                }
                case -6: {
                    String string22 = "Routine was invoked in an inproper context.";
                    Object var4_48 = null;
                    if (!TRACE) return string22;
                    if (!OracleLog.recursiveEnter()) return string22;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_94 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_93 = null;
                    OracleLog.recursiveExit();
                    return string22;
                }
                case -3: {
                    String string23 = "A resource manager error has occured in the transaction branch.";
                    Object var4_49 = null;
                    if (!TRACE) return string23;
                    if (!OracleLog.recursiveEnter()) return string23;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_96 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_95 = null;
                    OracleLog.recursiveExit();
                    return string23;
                }
                case -7: {
                    String string24 = "Resource manager is unavailable.";
                    Object var4_50 = null;
                    if (!TRACE) return string24;
                    if (!OracleLog.recursiveEnter()) return string24;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_98 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var6_97 = null;
                    OracleLog.recursiveExit();
                    return string24;
                }
            }
            string = "Internal XA Error";
            Object var4_51 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var4_52 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_102 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            Object var6_101 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {}
        catch (Throwable throwable) {
            Object var6_100 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleXAException.logger().log(Level.FINER, "         Exit");
        Object var6_99 = null;
        OracleLog.recursiveExit();
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAException"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

