/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oicc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oicc));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.implicitCache = oicc;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            long threadTTLTimeout = 0L;
            long threadInactivityTimeout = 0L;
            long threadAbandonedTimeout = 0L;
            while (this.timeToLive) {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        Object var8_11;
                        try {
                            OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread running...");
                            var8_11 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            var8_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    if (this.timeToLive && (threadTTLTimeout = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                        this.runTimeToLiveTimeout(threadTTLTimeout);
                    }
                    if (this.timeToLive && (threadInactivityTimeout = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                        this.runInactivityTimeout();
                    }
                    if (this.timeToLive && (threadAbandonedTimeout = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                        this.runAbandonedTimeout(threadAbandonedTimeout);
                    }
                    if (this.timeToLive) {
                        block27: {
                            this.isSleeping = true;
                            try {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    Object var10_12;
                                    try {
                                        OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread sleeping...");
                                        var10_12 = null;
                                        OracleLog.recursiveExit();
                                    }
                                    catch (Throwable throwable) {
                                        var10_12 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                }
                                OracleImplicitConnectionCacheThread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                            }
                            catch (InterruptedException ie) {
                                Object var12_13;
                                if (!TRACE || !OracleLog.recursiveEnter()) break block27;
                                try {
                                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread.run() " + "- InterruptedException" + ie.getMessage());
                                    var12_13 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    var12_13 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                        }
                        this.isSleeping = false;
                    }
                    if (this.implicitCache != null && (threadTTLTimeout > 0L || threadInactivityTimeout > 0L || threadAbandonedTimeout > 0L)) continue;
                    this.timeToLive = false;
                }
                catch (SQLException e2) {
                    Object var14_14;
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread.run()" + " - SQL Exceoption " + e2.getMessage());
                        var14_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        var14_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            Object var16_18 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var18_23 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var18_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var18_20 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimeToLiveTimeout(long threadTTLTimeout) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(threadTTLTimeout));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long connCurrTime = 0L;
            long connStartTime = 0L;
            if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
                OraclePooledConnection pc = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
                synchronized (oracleImplicitConnectionCache) {
                    Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                    int sz = this.implicitCache.checkedOutConnectionList.size();
                    for (int k2 = 0; k2 < sz; ++k2) {
                        pc = (OraclePooledConnection)ObjArr[k2];
                        Connection conn = pc.getLogicalHandle();
                        if (conn == null) continue;
                        connStartTime = ((OracleConnection)conn).getStartTime();
                        connCurrTime = System.currentTimeMillis();
                        if (connCurrTime - connStartTime <= threadTTLTimeout * 1000L) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            Object var14_15;
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runTimeToLiveTimeout():" + "TTL Timeout expired..." + " Executing cancel()/close()");
                                var14_15 = null;
                            }
                            catch (Throwable throwable) {
                                var14_15 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        try {
                            this.implicitCache.closeCheckedOutConnection(pc, true);
                            continue;
                        }
                        catch (SQLException e2) {
                            Object var16_16;
                            if (!TRACE || !OracleLog.recursiveEnter()) continue;
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runTimeToLiveTimeout() - while closeCheckedOutConnection " + "- SQLException:" + e2.getMessage());
                                var16_16 = null;
                            }
                            catch (Throwable throwable) {
                                var16_16 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                                continue;
                            }
                        }
                    }
                }
            }
            Object var19_19 = null;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var21_23 = null;
                }
                catch (Throwable throwable2) {
                    Object var21_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_21 = null;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInactivityTimeout() {
        try {
            block15: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                try {
                    this.implicitCache.doForEveryCachedConnection(4);
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block15;
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread.runInactivityTimeout()" + " - while doForEveryCachedConnection - SQLException:" + e2.getMessage());
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runAbandonedTimeout(long abandonedTimeout) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(abandonedTimeout));
                    oracleImplicitConnectionCache = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
                OraclePooledConnection pc = null;
                oracleImplicitConnectionCache = this.implicitCache;
                synchronized (oracleImplicitConnectionCache) {
                    Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                    for (int k2 = 0; k2 < ObjArr.length; ++k2) {
                        pc = (OraclePooledConnection)ObjArr[k2];
                        OracleConnection conn = (OracleConnection)pc.getLogicalHandle();
                        if (conn == null) continue;
                        OracleConnectionCacheCallback occc = conn.getConnectionCacheCallbackObj();
                        if ((long)(conn.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) <= abandonedTimeout) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            Object var10_13;
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runAbandonedTimeout():Abandoned Timeout expired..." + "Executing cancel()/close()");
                                var10_13 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                var10_13 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        try {
                            boolean closeCheckedOutConnection = true;
                            if (occc != null && (conn.getConnectionCacheCallbackFlag() == 4 || conn.getConnectionCacheCallbackFlag() == 1)) {
                                closeCheckedOutConnection = occc.handleAbandonedConnection(conn, conn.getConnectionCacheCallbackPrivObj());
                            }
                            if (!closeCheckedOutConnection) continue;
                            this.implicitCache.closeCheckedOutConnection(pc, true);
                            this.implicitCache.checkedOutConnectionList.remove(pc);
                            this.implicitCache.storeCacheConnection(pc.cachedConnectionAttributes, pc);
                            continue;
                        }
                        catch (SQLException e2) {
                            Object var12_14;
                            if (!TRACE || !OracleLog.recursiveEnter()) continue;
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runAbandonedTimeout() - while closeCheckedOutConnection" + " -  SQLException:" + e2.getMessage());
                                var12_14 = null;
                                OracleLog.recursiveExit();
                                continue;
                            }
                            catch (Throwable throwable) {
                                var12_14 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                    }
                }
            }
            Object var15_16 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_18 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCacheThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

