/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSNamespace;

class T4CTTIxsnsop
extends T4CTTIfun {
    private OracleConnection.XSOperationCode operationCode;
    private byte[] sessionId;
    private XSNamespace[] namespaces;
    private XSNamespace[] outNamespaces;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIxsnsop(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)172);
    }

    void doOXSNS(OracleConnection.XSOperationCode _operationCode, byte[] _sessionId, XSNamespace[] _namespaces, boolean roundTripRPC) throws IOException, SQLException {
        if (roundTripRPC) {
            this.setTTCCode((byte)3);
        } else {
            this.setTTCCode((byte)17);
        }
        this.operationCode = _operationCode;
        this.sessionId = _sessionId;
        this.namespaces = _namespaces;
        if (this.namespaces != null) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).doCharConversion(this.meg.conv);
            }
        }
        if (roundTripRPC) {
            this.doRPC();
        } else {
            this.doPigRPC();
        }
    }

    void marshal() throws IOException {
        this.meg.marshalUB4(this.operationCode.getCode());
        boolean sendSessionId = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            sendSessionId = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean sendNamespaces = false;
        this.meg.marshalPTR();
        if (this.namespaces != null && this.namespaces.length > 0) {
            sendNamespaces = true;
            this.meg.marshalUB4(this.namespaces.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        if (sendSessionId) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (sendNamespaces) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).marshal(this.meg);
            }
        }
    }

    void readRPA() throws SQLException, IOException {
        this.outNamespaces = null;
        int namespacesLength = (int)this.meg.unmarshalUB4();
        if (namespacesLength > 0) {
            this.outNamespaces = new XSNamespace[namespacesLength];
            for (int i2 = 0; i2 < namespacesLength; ++i2) {
                this.outNamespaces[i2] = XSNamespaceI.unmarshal(this.meg);
            }
        }
    }

    XSNamespace[] getNamespaces() throws SQLException {
        return this.outNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIxsnsop.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIxsnsop.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIxsnsop.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIxsnsop"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

