/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIidc;
import oracle.jdbc.driver.T4CTTIkvarr;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

abstract class T4CTTIfun
extends T4CTTIMsg {
    static final short OOPEN = 2;
    static final short OFETCH = 5;
    static final short OCLOSE = 8;
    static final short OLOGOFF = 9;
    static final short OCOMON = 12;
    static final short OCOMOFF = 13;
    static final short OCOMMIT = 14;
    static final short OROLLBACK = 15;
    static final short OCANCEL = 20;
    static final short ODSCRARR = 43;
    static final short OVERSION = 59;
    static final short OK2RPC = 67;
    static final short OALL7 = 71;
    static final short OSQL7 = 74;
    static final short O3LOGON = 81;
    static final short O3LOGA = 82;
    static final short OKOD = 92;
    static final short OALL8 = 94;
    static final short OLOBOPS = 96;
    static final short ODNY = 98;
    static final short OTXSE = 103;
    static final short OTXEN = 104;
    static final short OCCA = 105;
    static final short O80SES = 107;
    static final short OAUTH = 115;
    static final short OSESSKEY = 118;
    static final short OCANA = 120;
    static final short OKPN = 125;
    static final short OOTCM = 127;
    static final short OSCID = 135;
    static final short OSPFPPUT = 138;
    static final short OKPFC = 139;
    static final short OPING = 147;
    static final short OKEYVAL = 154;
    static final short OXSSCS = 155;
    static final short OXSSRO = 156;
    static final short OXSSPO = 157;
    static final short OAQEQ = 121;
    static final short OAQDQ = 122;
    static final short OAQGPS = 132;
    static final short OAQLS = 126;
    static final short OAQXQ = 145;
    static final short OXSNS = 172;
    private short funCode;
    protected final T4CTTIoer oer;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    boolean rpaProcessed = false;
    boolean rxhProcessed = false;
    boolean iovProcessed = false;
    private LinkedList<Short> ttilist = new LinkedList();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIfun(T4CConnection _conn, byte _ttcCode) {
        super(_conn, _ttcCode);
        this.oer = _conn.getT4CTTIoer();
    }

    final void setFunCode(short _funCode) {
        this.funCode = _funCode;
    }

    final short getFunCode() {
        return this.funCode;
    }

    private final void marshalFunHeader() throws IOException {
        this.marshalTTCcode();
        this.meg.marshalUB1(this.funCode);
        this.meg.marshalUB1(this.connection.getNextSeqNumber());
    }

    abstract void marshal() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doRPC() throws IOException, SQLException {
        if (this.getTTCCode() == 17) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            this.init();
            this.marshalFunHeader();
            try {
                this.connection.pipeState = 1;
                this.marshal();
                this.connection.pipeState = 2;
                this.receive();
                return;
            }
            catch (SQLException e2) {
                Object object = this.connection.cancelInProgressLockForThin;
                synchronized (object) {
                    block17: {
                        if (e2.getErrorCode() != 1013 && (!this.connection.cancelInProgressFlag || e2.getMessage() == null || !e2.getMessage().contains("ORA-01013"))) break block17;
                        this.connection.cancelInProgressFlag = false;
                        this.connection.redoCursorClose();
                        if (this.funCode != 15 && this.funCode != 12 && this.funCode != 13 && this.funCode != 14 && this.funCode != 59 || this.oer.callNumber == this.connection.currentTTCSeqNumber && !this.connection.statementCancel) break block17;
                        continue;
                    }
                    throw e2;
                }
            }
            finally {
                this.connection.pipeState = -1;
            }
        }
    }

    final void doPigRPC() throws IOException {
        this.init();
        this.marshalFunHeader();
        this.marshal();
    }

    private void init() {
        this.rpaProcessed = false;
        this.rxhProcessed = false;
        this.iovProcessed = false;
        this.ttilist.clear();
    }

    void resumeReceive() throws SQLException, IOException {
        this.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void receive() throws SQLException, IOException {
        this.receiveState = 1;
        exceptionToBeThrown = null;
        block35: while (true) lbl-1000:
        // 20 sources

        {
            try {
                code = this.meg.unmarshalUB1();
                this.ttilist.add(new Short(code));
                switch (code) {
                    case 8: {
                        if (!this.rpaProcessed) ** GOTO lbl22
                        if (T4CTTIfun.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                        __ex__.fillInStackTrace();
                        throw __ex__;
lbl22:
                        // 1 sources

                        this.readRPA();
                        try {
                            this.processRPA();
                        }
                        catch (SQLException ex) {
                            exceptionToBeThrown = ex;
                        }
                        this.rpaProcessed = true;
                        ** break;
                    }
                    case 21: {
                        this.readBVC();
                        ** break;
                    }
                    case 11: {
                        this.readIOV();
                        this.iovProcessed = true;
                        ** break;
                    }
                    case 6: {
                        this.readRXH();
                        this.rxhProcessed = true;
                        ** break;
                    }
                    case 12: {
                        this.processSLG();
                        ** break;
                    }
                    case 7: {
                        this.receiveState = 2;
                        if (this.readRXD()) {
                            this.receiveState = 3;
                            return;
                        }
                        this.receiveState = 1;
                        ** break;
                    }
                    case 16: {
                        this.readDCB();
                        ** break;
                    }
                    case 14: {
                        this.readLOBD();
                        ** break;
                    }
                    case 23: {
                        opCode = (byte)this.meg.unmarshalUB1();
                        nbOfDtys = this.meg.unmarshalUB2();
                        lengthOfDty = (byte)this.meg.unmarshalUB1();
                        if (opCode == 1) {
                            i = 0;
                            while (true) {
                                if (i >= nbOfDtys) continue block35;
                                qidc = new T4CTTIidc(this.connection);
                                qidc.unmarshal();
                                ++i;
                            }
                        }
                        if (opCode == 2) {
                            i = 0;
                            while (true) {
                                if (i >= nbOfDtys) continue block35;
                                mtspid = this.meg.unmarshalUB1();
                                ++i;
                            }
                        }
                        if (opCode == 3 || opCode == 4) continue block35;
                        if (opCode == 5) {
                            kvarr = new T4CTTIkvarr(this.connection);
                            kvarr.unmarshal();
                            ** break;
                        }
                        if (opCode != 6) continue block35;
                        i = 0;
                        while (true) {
                            if (i >= nbOfDtys) continue block35;
                            xsevent = new NTFXSEvent(this.connection);
                            this.connection.notify(xsevent);
                            ++i;
                        }
                    }
                    case 19: {
                        this.meg.marshalUB1((short)19);
                        ** break;
                    }
                    case 15: {
                        this.oer.init();
                        this.oer.unmarshalWarning();
                        try {
                            this.oer.processWarning();
                        }
                        catch (SQLWarning ea) {
                            this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), ea));
                        }
                        continue block35;
                    }
                    case 9: {
                        this.processEOCS();
                        if (this.connection.getTTCVersion() >= 3) {
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                        }
                        break block35;
                    }
                    case 4: {
                        this.processEOCS();
                        this.oer.init();
                        this.oer.unmarshal();
                        try {
                            this.processError();
                        }
                        catch (SQLException sqlex) {
                            exceptionToBeThrown = sqlex;
                        }
                        break block35;
                    }
                    default: {
                        if (T4CTTIfun.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401 + this.ttilist.toString());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttilist.toString());
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            catch (BreakNetException var3_7) {}
            continue;
            finally {
                this.connection.sentCancel = false;
                continue;
            }
            break;
        }
        this.receiveState = 0;
        if (exceptionToBeThrown != null) {
            throw exceptionToBeThrown;
        }
    }

    private final void processEOCS() throws SQLException, IOException {
        if (this.connection.hasServerCompileTimeCapability(15, 1)) {
            int ucaeocs;
            this.connection.eocs = ucaeocs = (int)this.meg.unmarshalUB4();
            if ((ucaeocs & 8) != 0) {
                long l2 = this.meg.unmarshalSB8();
            }
        }
    }

    void processRPA() throws SQLException {
    }

    void readRPA() throws IOException, SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readBVC() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readLOBD() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readIOV() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readRXH() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readRXD() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDCB() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSLG() throws IOException, SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTTIfun.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    void processError() throws SQLException {
        this.oer.processError();
    }

    final int getErrorCode() throws SQLException {
        return this.oer.retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIfun.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIfun.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIfun.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIfun"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

