/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CCharAccessor
extends CharAccessor {
    T4CMAREngine mare;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CCharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.calculateSizeTmpByteArray();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CCharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _oacmxl, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_oacmxl) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.calculateSizeTmpByteArray();
            this.oacmxl = _oacmxl;
            if (this.oacmxl == -1) {
                this.underlyingLong = true;
                this.oacmxl = 4000;
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var19_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_19 = null;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        byte[] bytesBuffer = this.statement.tmpByteArray;
        int tmpSpaceCharOffset = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (this.rowSpaceIndicator == null) {
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        if (this.statement.maxFieldSize > 0) {
            this.mare.unmarshalCLR(bytesBuffer, 0, this.meta, this.statement.maxFieldSize);
        } else {
            this.mare.unmarshalCLR(bytesBuffer, 0, this.meta);
        }
        this.tmp[0] = this.meta[0];
        int nbOfCharsConverted = 0;
        nbOfCharsConverted = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(bytesBuffer, 0, this.rowSpaceChar, tmpSpaceCharOffset + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(bytesBuffer, 0, this.rowSpaceChar, tmpSpaceCharOffset + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[tmpSpaceCharOffset] = (char)(nbOfCharsConverted * 2);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceCharOffset = this.columnIndex + this.lastRowProcessed * this.charLength;
        int tmpSpaceCharOffsetLastRow = this.columnIndex + lastRowOffset * this.charLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceChar, tmpSpaceCharOffsetLastRow, this.rowSpaceChar, tmpSpaceCharOffset, this.rowSpaceChar[tmpSpaceCharOffsetLastRow] / 2 + 1);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceCharOffset = this.columnIndex + (newPrefetchSize - 1) * this.charLength;
        int tmpSpaceCharOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.charLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceCharLastRow, tmpSpaceCharOffsetLastRow, this.rowSpaceChar, tmpSpaceCharOffset, rowSpaceCharLastRow[tmpSpaceCharOffsetLastRow] / 2 + 1);
        } else {
            this.rowSpaceChar[tmpSpaceCharOffset] = '\u0000';
        }
    }

    void calculateSizeTmpByteArray() {
        int maxNbBytes = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < maxNbBytes) {
            this.statement.sizeTmpByteArray = maxNbBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            string = ret;
            Object var7_9 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            T4CCharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return string;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    NUMBER getNUMBER(int currentRow) throws SQLException {
        NUMBER result = null;
        if (this.definedColumnType == 0) {
            result = super.getNUMBER(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                return T4CVarcharAccessor.StringToNUMBER(s2);
            }
        }
        return result;
    }

    DATE getDATE(int currentRow) throws SQLException {
        DATE result = null;
        if (this.definedColumnType == 0) {
            result = super.getDATE(currentRow);
        } else {
            Date d2 = this.getDate(currentRow);
            if (d2 != null) {
                result = new DATE(d2);
            }
        }
        return result;
    }

    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMP result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMP(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMP(ts);
            }
        }
        return result;
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        TIMESTAMPLTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPLTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPLTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RAW getRAW(int currentRow) throws SQLException {
        RAW result = null;
        if (this.definedColumnType == 0) {
            result = super.getRAW(currentRow);
        } else {
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CCharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                result = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(currentRow)) : new RAW(super.getBytes(currentRow));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(currentRow);
        }
        Datum result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(currentRow);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(currentRow);
                }
                case 91: {
                    return this.getDATE(currentRow);
                }
                case 92: {
                    return this.getDATE(currentRow);
                }
                case 93: {
                    return this.getTIMESTAMP(currentRow);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(currentRow);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(currentRow);
                }
                case -8: {
                    return this.getROWID(currentRow);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    byte[] getBytes(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getBytes(currentRow);
        }
        Datum datum = this.getOracleObject(currentRow);
        if (datum != null) {
            return datum.shareBytes();
        }
        return null;
    }

    boolean getBoolean(int currentRow) throws SQLException {
        boolean result = false;
        result = this.definedColumnType == 0 ? super.getBoolean(currentRow) : this.getNUMBER(currentRow).booleanValue();
        return result;
    }

    byte getByte(int currentRow) throws SQLException {
        byte result = 0;
        if (this.definedColumnType == 0) {
            result = super.getByte(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.byteValue();
            }
        }
        return result;
    }

    int getInt(int currentRow) throws SQLException {
        int result = 0;
        if (this.definedColumnType == 0) {
            result = super.getInt(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.intValue();
            }
        }
        return result;
    }

    short getShort(int currentRow) throws SQLException {
        short result = 0;
        if (this.definedColumnType == 0) {
            result = super.getShort(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.shortValue();
            }
        }
        return result;
    }

    long getLong(int currentRow) throws SQLException {
        long result = 0L;
        if (this.definedColumnType == 0) {
            result = super.getLong(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.longValue();
            }
        }
        return result;
    }

    float getFloat(int currentRow) throws SQLException {
        float result = 0.0f;
        if (this.definedColumnType == 0) {
            result = super.getFloat(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.floatValue();
            }
        }
        return result;
    }

    double getDouble(int currentRow) throws SQLException {
        double result = 0.0;
        if (this.definedColumnType == 0) {
            result = super.getDouble(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.doubleValue();
            }
        }
        return result;
    }

    Date getDate(int currentRow) throws SQLException {
        Date result = null;
        if (this.definedColumnType == 0) {
            result = super.getDate(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                result = new Date(T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nanos).getTimeInMillis());
            }
        }
        return result;
    }

    Timestamp getTimestamp(int currentRow) throws SQLException {
        Timestamp result = null;
        if (this.definedColumnType == 0) {
            result = super.getTimestamp(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                result = new Timestamp(cal.getTimeInMillis());
                result.setNanos(nanos[0]);
            }
        }
        return result;
    }

    Time getTime(int currentRow) throws SQLException {
        Time result = null;
        if (this.definedColumnType == 0) {
            result = super.getTime(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                result = new Time(cal.getTimeInMillis());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        Object result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(currentRow);
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(currentRow);
                }
                case 4: {
                    return this.getInt(currentRow);
                }
                case -6: {
                    return this.getByte(currentRow);
                }
                case 5: {
                    return this.getShort(currentRow);
                }
                case -7: 
                case 16: {
                    return this.getBoolean(currentRow);
                }
                case -5: {
                    return this.getLong(currentRow);
                }
                case 7: {
                    return Float.valueOf(this.getFloat(currentRow));
                }
                case 6: 
                case 8: {
                    return this.getDouble(currentRow);
                }
                case 91: {
                    return this.getDate(currentRow);
                }
                case 92: {
                    return this.getTime(currentRow);
                }
                case 93: {
                    return this.getTimestamp(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytesFromHexChars(currentRow);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CCharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CCharAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

