/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.sql.BLOB;

class T4CBlobAccessor
extends BlobAccessor {
    T4CMAREngine mare;
    final int[] meta = new int[1];
    ArrayList<LinkedList<BLOB>> registeredBLOBs = new ArrayList(10);
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CBlobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CBlobAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            int len = (int)this.mare.unmarshalUB4();
            if (len == 0) {
                this.meta[0] = -1;
                this.processIndicator(0);
                ++this.lastRowProcessed;
                return false;
            }
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int len = (int)this.mare.unmarshalUB4();
        if (len == 0) {
            this.meta[0] = -1;
            this.processIndicator(0);
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            return false;
        }
        if (this.lobPrefetchSizeForThisColumn != -1) {
            this.handlePrefetch();
        }
        this.mare.unmarshalCLR(this.rowSpaceByte, tmpSpaceByteOffset, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndex + lastRowOffset * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceByteOffset = this.columnIndex + (newPrefetchSize - 1) * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceByteLastRow, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
    }

    byte[][] checkAndAllocateLobPrefetchMemory(byte[][] existingBuffers, int statementPrefetchSize, int currentRowNumber, int bufferSizeAtCurrentRow) {
        Object retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new byte[Math.max(statementPrefetchSize, currentRowNumber + 1)][];
            retBuff[currentRowNumber] = new byte[bufferSizeAtCurrentRow];
        } else {
            if (((byte[][])retBuff).length < currentRowNumber + 1) {
                byte[][] retBuff2 = new byte[(currentRowNumber + 1) * 2][];
                System.arraycopy(retBuff, 0, retBuff2, 0, ((byte[][])retBuff).length);
                retBuff = retBuff2;
            }
            if (retBuff[currentRowNumber] == null || retBuff[currentRowNumber].length < bufferSizeAtCurrentRow) {
                retBuff[currentRowNumber] = new byte[bufferSizeAtCurrentRow];
            }
        }
        return retBuff;
    }

    char[][] checkAndAllocateLobPrefetchMemory(char[][] existingBuffers, int statementPrefetchSize, int currentRowNumber, int bufferSizeAtCurrentRow) {
        Object retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new char[Math.max(statementPrefetchSize, currentRowNumber + 1)][];
            retBuff[currentRowNumber] = new char[bufferSizeAtCurrentRow];
        } else {
            if (((char[][])retBuff).length < currentRowNumber + 1) {
                char[][] retBuff2 = new char[(currentRowNumber + 1) * 2][];
                System.arraycopy(retBuff, 0, retBuff2, 0, ((char[][])retBuff).length);
                retBuff = retBuff2;
            }
            if (retBuff[currentRowNumber] == null || retBuff[currentRowNumber].length < bufferSizeAtCurrentRow) {
                retBuff[currentRowNumber] = new char[bufferSizeAtCurrentRow];
            }
        }
        return retBuff;
    }

    long[] checkAndAllocateLobPrefetchMemory(long[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        long[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new long[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            long[] retBuff2 = new long[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    int[] checkAndAllocateLobPrefetchMemory(int[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        int[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new int[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            int[] retBuff2 = new int[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    short[] checkAndAllocateLobPrefetchMemory(short[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        short[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new short[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            short[] retBuff2 = new short[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    byte[] checkAndAllocateLobPrefetchMemory(byte[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        byte[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new byte[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            byte[] retBuff2 = new byte[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    boolean[] checkAndAllocateLobPrefetchMemory(boolean[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        boolean[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new boolean[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            boolean[] retBuff2 = new boolean[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(int currentRow) throws SQLException {
        block43: {
            BLOB blob;
            byte[] byArray;
            block46: {
                block44: {
                    block41: {
                        byte[] byArray2;
                        try {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                                    byArray = null;
                                }
                                catch (Throwable throwable) {
                                    Object var3_3 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) break block41;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                                    Object var5_10 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var5_11 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            byArray2 = null;
                            Object var17_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_18 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var19_29 = null;
                                }
                                catch (Throwable throwable2) {
                                    Object var19_30 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable2;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            throw throwable;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var19_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_20 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return byArray2;
                    }
                    if (this.lobPrefetchSizeForThisColumn == -1 || this.prefetchedLobSize == null) break block43;
                    if (this.prefetchedLobSize[currentRow] > Integer.MAX_VALUE) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CBlobAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 151);
                                Object var7_37 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_38 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (this.prefetchedLobData == null || (long)this.lobPrefetchSizeForThisColumn < this.prefetchedLobSize[currentRow]) break block44;
                    byte[] ret = new byte[(int)this.prefetchedLobSize[currentRow]];
                    System.arraycopy(this.prefetchedLobData[currentRow], 0, ret, 0, (int)this.prefetchedLobSize[currentRow]);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                            Object var9_40 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_41 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    byArray = ret;
                    Object var17_14 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var19_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_22 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return byArray;
                }
                blob = this.getBLOB(currentRow);
                if (blob != null) break block46;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var11_43 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_44 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byArray = null;
                Object var17_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return byArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + blob.getBytes(1L, (int)this.prefetchedLobSize[currentRow]));
                    Object var13_46 = null;
                }
                catch (Throwable throwable) {
                    Object var13_47 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = blob.getBytes(1L, (int)this.prefetchedLobSize[currentRow]);
            Object var17_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_25 = null;
                }
                catch (Throwable throwable) {
                    Object var19_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return byArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + super.getBytes(currentRow));
                Object var15_49 = null;
            }
            catch (Throwable throwable) {
                Object var15_50 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        byte[] byArray = super.getBytes(currentRow);
        Object var17_17 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_27 = null;
            }
            catch (Throwable throwable) {
                Object var19_28 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    void handlePrefetch() throws SQLException, IOException {
        this.prefetchedLobSize = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobSize, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
        this.prefetchedLobSize[this.lastRowProcessed] = this.mare.unmarshalSB8();
        this.prefetchedLobChunkSize = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobChunkSize, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
        this.prefetchedLobChunkSize[this.lastRowProcessed] = (int)this.mare.unmarshalUB4();
        if (this.lobPrefetchSizeForThisColumn > 0) {
            this.prefetchedLobDataL = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobDataL, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
            int nbOfBytes = this.lobPrefetchSizeForThisColumn;
            this.prefetchedLobData = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobData, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed, nbOfBytes);
            this.disablePrefetchBufferForPreviousBLOBs(this.lastRowProcessed);
            this.mare.unmarshalCLR(this.prefetchedLobData[this.lastRowProcessed], 0, this.meta);
            this.prefetchedLobDataL[this.lastRowProcessed] = this.meta[0];
        }
    }

    void initializeBlobForPrefetch(int currentRow, BLOB result) throws SQLException {
        if (currentRow >= 0) {
            this.saveBLOBReference(currentRow, result);
            result.setPrefetchedData(this.prefetchedLobData[currentRow], this.prefetchedLobDataL[currentRow]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBLOBReference(int rowPosition, BLOB blob) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            LinkedList<Object> blobsAtThisRow = null;
            if (this.registeredBLOBs.size() > rowPosition) {
                blobsAtThisRow = this.registeredBLOBs.get(rowPosition);
            } else {
                blobsAtThisRow = new LinkedList();
                while (this.registeredBLOBs.size() < rowPosition) {
                    this.registeredBLOBs.add(new LinkedList());
                }
                this.registeredBLOBs.add(rowPosition, blobsAtThisRow);
            }
            if (blobsAtThisRow == null) {
                blobsAtThisRow = new LinkedList();
            }
            blobsAtThisRow.add(blob);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void disablePrefetchBufferForPreviousBLOBs(int rowPosition) {
        try {
            LinkedList<BLOB> blobsAtThisRow;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.registeredBLOBs.size() > rowPosition && (blobsAtThisRow = this.registeredBLOBs.get(rowPosition)) != null && !blobsAtThisRow.isEmpty()) {
                ListIterator it = blobsAtThisRow.listIterator();
                while (it.hasNext()) {
                    ((BLOB)it.next()).setPrefetchedData(null);
                }
                blobsAtThisRow.clear();
            }
            Object var5_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CBlobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        Object result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case 2004: {
                    return this.getBLOB(currentRow);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBlobAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CBlobAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

