/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class RefTypeAccessor
extends TypeAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RefTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 111, 111, form, forBind);
            this.initForDataAccess(external_type, 0, typeName);
            Object var9_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable2) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName));
                    Object var12_11 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 111, 111, form, false);
            this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.initForDataAccess(0, max_len, typeName);
            Object var14_14 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_18 = null;
            }
            catch (Throwable throwable2) {
                Object var16_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(otype));
                    Object var13_12 = null;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 111, 111, form, false);
            this.describeOtype = otype;
            this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.internalOtype = otype;
            this.initForDataAccess(0, max_len, typeName);
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_17 = null;
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    OracleType otypeFromName(String typeName) throws SQLException {
        OracleNamedType oracleNamedType;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typeName));
                    oracleNamedType = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (!this.outBind) {
                OracleNamedType __result__ = TypeDescriptor.getTypeDescriptor(typeName, this.statement.connection).getPickler();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleNamedType = __result__;
                Object var9_10 = null;
                if (!TRACE) return oracleNamedType;
                if (!OracleLog.recursiveEnter()) return oracleNamedType;
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    return oracleNamedType;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleTypeADT __result__ = StructDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeADT();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_22 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            oracleNamedType = __result__;
            Object var9_11 = null;
            if (!TRACE) return oracleNamedType;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return oracleNamedType;
        try {}
        catch (Throwable throwable) {
            Object var11_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var11_15 = null;
        OracleLog.recursiveExit();
        return oracleNamedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            super.initForDataAccess(external_type, max_len, typeName);
            this.byteLength = this.statement.connection.refTypeAccessorByteLen;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    REF getREF(int currentRow) throws SQLException {
        REF rEF;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    rEF = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            REF result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RefTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                byte[] data = this.pickledBytes(currentRow);
                OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
                result = new REF(otype.getFullName(), (Connection)this.statement.connection, data);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rEF = result;
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    Object getObject(int currentRow) throws SQLException {
        REF rEF;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    rEF = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            REF __result__ = this.getREF(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rEF = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        REF rEF;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    rEF = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            REF __result__ = this.getREF(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rEF = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow, Map map) throws SQLException {
        REF rEF;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                    rEF = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            REF __result__ = this.getREF(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rEF = __result__;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RefTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rEF;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.RefTypeAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

