/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobReader
extends Reader {
    CLOB clob;
    DBConversion dbConversion;
    long lobOffset;
    long markedChar;
    char[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition = Long.MAX_VALUE;
    boolean isClosed;
    boolean endOfStream;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobReader(CLOB clob) throws SQLException {
        this(clob, ((PhysicalConnection)clob.getInternalConnection()).getDefaultStreamChunkSize() / 3);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleClobReader(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize) + ", " + OracleLog.argument(beginOffset));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (clob == null || bufferSize <= 0 || clob.getInternalConnection() == null || beginOffset < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException();
            }
            this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
            this.clob = clob;
            this.lobOffset = beginOffset;
            this.markedChar = -1L;
            this.resizableBuffer = null;
            this.initialBufferSize = bufferSize;
            this.currentBufferSize = 0;
            this.count = 0;
            this.pos = 0;
            this.isClosed = false;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset, long length) throws SQLException {
        this(clob, bufferSize, beginOffset);
        this.maxPosition = beginOffset + length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n2;
        int end;
        int start;
        block20: {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cbuf) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(len));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            start = off;
            end = start + Math.min(len, cbuf.length - off);
            if (this.needChars(end - start)) break block20;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = -1;
            Object var11_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n3;
        }
        try {
            start += this.writeChars(cbuf, start, end - start);
            while (start < end && this.needChars(end - start)) {
                start += this.writeChars(cbuf, start, end - start);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (start - off));
                    Object var9_26 = null;
                }
                catch (Throwable throwable) {
                    Object var9_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = start - off;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean needChars(int howMany) throws IOException {
        boolean bl;
        try {
            PhysicalConnection physicalConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    physicalConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block32: {
                    if (!this.endOfStream) {
                        boolean bl2;
                        try {
                            if (howMany > this.currentBufferSize) {
                                PhysicalConnection pConnection;
                                this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                                physicalConnection = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                                // MONITORENTER : physicalConnection
                                this.resizableBuffer = pConnection.getCharBuffer(this.currentBufferSize);
                                // MONITOREXIT : physicalConnection
                            }
                            int size = this.currentBufferSize;
                            if (this.maxPosition - this.lobOffset < (long)this.currentBufferSize) {
                                size = (int)(this.maxPosition - this.lobOffset);
                            }
                            this.count = this.clob.getChars(this.lobOffset, size, this.resizableBuffer);
                            if (this.count < this.currentBufferSize) {
                                this.endOfStream = true;
                            }
                            if (this.count <= 0) break block32;
                            this.pos = 0;
                            this.lobOffset += (long)this.count;
                            if (this.lobOffset >= this.maxPosition) {
                                this.endOfStream = true;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    Object var6_10 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var6_11 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            bl2 = true;
                        }
                        catch (SQLException e2) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                                    Object var8_29 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var8_30 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            IOException __ex__ = DatabaseError.createIOException(e2);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        Object var14_13 = null;
                        if (!TRACE) return bl2;
                        if (!OracleLog.recursiveEnter()) return bl2;
                        try {
                            OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var16_17 = null;
                            OracleLog.recursiveExit();
                            return bl2;
                        }
                        catch (Throwable throwable) {
                            Object var16_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var10_32 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_33 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl3 = false;
                Object var14_14 = null;
                if (!TRACE) return bl3;
                if (!OracleLog.recursiveEnter()) return bl3;
                try {}
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_19 = null;
                OracleLog.recursiveExit();
                return bl3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var12_35 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var12_36 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = true;
            Object var14_15 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var16_24 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var16_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var16_21 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeChars(char[] destbuf, int offset, int length) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(destbuf) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int availableLength = Math.min(length, this.count - this.pos);
            System.arraycopy(this.resizableBuffer, this.pos, destbuf, offset, availableLength);
            this.pos += availableLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + availableLength);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = availableLength;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.pos < this.count));
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.pos < this.count;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() throws IOException {
        block21: {
            if (OracleClobReader.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    var2_1 = null;
                }
                catch (Throwable var1_3) {
                    var2_2 = null;
                    OracleLog.recursiveExit();
                    throw var1_3;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.isClosed) break block22;
            var7_6 = null;
            if (!OracleClobReader.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl-1000
            try {
                OracleClobReader.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var9_9 = null;
            }
            catch (Throwable var8_15) {
                var9_10 = null;
                OracleLog.recursiveExit();
                throw var8_15;
            }
            OracleLog.recursiveExit();
            {
            }
lbl-1000:
            // 2 sources

            {
                block22: {
                    return;
                }
                try {
                    this.isClosed = true;
                    var2_1 = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                    synchronized (var2_1) {
                        if (this.resizableBuffer != null) {
                            pConnection.cacheBuffer(this.resizableBuffer);
                            this.resizableBuffer = null;
                        }
                    }
                }
                catch (SQLException ea) {
                    if (OracleClobReader.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + ea);
                            var5_19 = null;
                        }
                        catch (Throwable var4_21) {
                            var5_20 = null;
                            OracleLog.recursiveExit();
                            throw var4_21;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__ = DatabaseError.createIOException(ea);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            var7_7 = null;
            if (OracleClobReader.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var9_11 = null;
                }
                catch (Throwable var8_16) {
                    var9_12 = null;
                    OracleLog.recursiveExit();
                    throw var8_16;
                }
                OracleLog.recursiveExit();
                {
                    break block21;
                }
            }
            break block21;
            catch (Throwable var6_22) {
                var7_8 = null;
                if (OracleClobReader.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        var9_13 = null;
                    }
                    catch (Throwable var8_17) {
                        var9_14 = null;
                        OracleLog.recursiveExit();
                        throw var8_17;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw var6_22;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        try {
            block18: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (!this.isClosed) break block18;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = true;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(readAheadLimit));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (readAheadLimit < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + DatabaseError.findMessage(195, null));
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException(DatabaseError.findMessage(195, null));
            }
            this.markedChar = this.lobOffset - (long)this.count + (long)this.pos;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.markedChar < 0L) {
                if (!TRACE || !OracleLog.recursiveEnter()) throw new IOException(DatabaseError.findMessage(195, null));
                try {
                    OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + DatabaseError.findMessage(195, null));
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                    throw new IOException(DatabaseError.findMessage(195, null));
                }
            }
            this.lobOffset = this.markedChar;
            this.pos = this.count;
            this.endOfStream = false;
            Object var6_7 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable2) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n2) throws IOException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            long start = 0L;
            if ((long)(this.count - this.pos) >= n2) {
                this.pos = (int)((long)this.pos + n2);
                start += n2;
            } else {
                start += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long remainLen = this.clob.length() - this.lobOffset + 1L;
                    if (remainLen >= n2 - start) {
                        this.lobOffset += n2 - start;
                        start += n2 - start;
                    } else {
                        this.lobOffset += remainLen;
                        start += remainLen;
                    }
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + start);
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = start;
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            OracleConnection oracleConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    oracleConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                OracleConnection __result__ = this.clob.getInternalConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = __result__;
            }
            catch (Exception exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var6_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = null;
                Object var8_10 = null;
                if (!TRACE) return oracleConnection;
                if (!OracleLog.recursiveEnter()) return oracleConnection;
                try {}
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            Object var8_9 = null;
            if (!TRACE) return oracleConnection;
            if (!OracleLog.recursiveEnter()) return oracleConnection;
            try {
                OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

