/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected CLOB clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB clob) throws SQLException {
        this(clob, ((PhysicalConnection)clob.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB clob, int chunkSize) throws SQLException {
        this(clob, chunkSize, 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB clob, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(beginOffset));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (clob == null || chunkSize <= 0 || beginOffset < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException();
            }
            this.lobOffset = beginOffset;
            this.clob = clob;
            this.markedByte = -1L;
            this.endOfStream = false;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean needBytes(int howMany) throws IOException {
        boolean bl;
        try {
            PhysicalConnection physicalConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    physicalConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block31: {
                    if (!this.endOfStream) {
                        int i2;
                        try {
                            if (howMany > this.currentBufferSize) {
                                PhysicalConnection pConnection;
                                this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                                physicalConnection = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                                // MONITORENTER : physicalConnection
                                this.resizableBuffer = pConnection.getByteBuffer(this.currentBufferSize);
                                this.charBuf = pConnection.getCharBuffer(this.currentBufferSize);
                                // MONITOREXIT : physicalConnection
                            }
                            this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                            for (i2 = 0; i2 < this.count; i2 += 1) {
                                this.resizableBuffer[i2] = (byte)this.charBuf[i2];
                            }
                            if (this.count < this.currentBufferSize) {
                                this.endOfStream = true;
                            }
                            if (this.count <= 0) break block31;
                            this.pos = 0;
                            this.lobOffset += (long)this.count;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    Object var6_9 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var6_10 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            i2 = 1;
                        }
                        catch (SQLException e2) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                                    Object var8_28 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var8_29 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            IOException __ex__ = DatabaseError.createIOException(e2);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        Object var14_12 = null;
                        if (!TRACE) return i2 != 0;
                        if (!OracleLog.recursiveEnter()) return i2 != 0;
                        try {
                            OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var16_16 = null;
                            OracleLog.recursiveExit();
                            return i2 != 0;
                        }
                        catch (Throwable throwable) {
                            Object var16_17 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var10_31 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_32 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = false;
                Object var14_13 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {}
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_18 = null;
                OracleLog.recursiveExit();
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var12_34 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var12_35 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = true;
            Object var14_14 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var16_23 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var16_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var16_20 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureOpen() throws IOException {
        try {
            block18: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (!this.closed) break block18;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = true;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(readLimit));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (readLimit < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + DatabaseError.findMessage(196, null));
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public void markInternal(int readLimit) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + DatabaseError.findMessage(195, null));
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IOException(DatabaseError.findMessage(195, null));
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n2) throws IOException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            long start = 0L;
            if ((long)(this.count - this.pos) >= n2) {
                this.pos = (int)((long)this.pos + n2);
                start += n2;
            } else {
                start += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long remainLen = 0L;
                    remainLen = this.clob.length() - this.lobOffset + 1L;
                    if (remainLen >= n2 - start) {
                        this.lobOffset += n2 - start;
                        start += n2 - start;
                    } else {
                        this.lobOffset += remainLen;
                        start += remainLen;
                    }
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + start);
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = start;
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            block28: {
                if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        var2_1 = null;
                    }
                    catch (Throwable var1_3) {
                        var2_2 = null;
                        OracleLog.recursiveExit();
                        throw var1_3;
                    }
                    OracleLog.recursiveExit();
                }
                if (!this.closed) break block28;
                var11_4 = null;
                if (OracleClobInputStream.TRACE == false) return;
                ** GOTO lbl101
            }
            try {
                super.close();
                var4_16 = null;
            }
            catch (Throwable var3_32) {
                var4_17 = null;
                try {
                    var6_24 = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                    synchronized (var6_24) {
                        if (this.charBuf != null) {
                            pConnection.cacheBuffer(this.charBuf);
                            this.charBuf = null;
                        }
                        if (this.resizableBuffer != null) {
                            pConnection.cacheBuffer(this.resizableBuffer);
                            this.resizableBuffer = null;
                        }
                        this.currentBufferSize = 0;
                        throw var3_32;
                    }
                }
                catch (SQLException ea) {
                    if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + ea);
                            var9_28 = null;
                        }
                        catch (Throwable var8_31) {
                            var9_29 = null;
                            OracleLog.recursiveExit();
                            throw var8_31;
                        }
                        OracleLog.recursiveExit();
                    }
                    __ex__ = DatabaseError.createIOException(ea);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            try {}
            catch (SQLException ea) {
                block29: {
                    if (!OracleClobInputStream.TRACE || !OracleLog.recursiveEnter()) break block29;
                    try {}
                    catch (Throwable var8_30) {
                        var9_27 = null;
                        OracleLog.recursiveExit();
                        throw var8_30;
                    }
                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + ea);
                    var9_26 = null;
                    OracleLog.recursiveExit();
                }
                __ex__ = DatabaseError.createIOException(ea);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            var6_22 = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
            synchronized (var6_22) {
                if (this.charBuf != null) {
                    pConnection.cacheBuffer(this.charBuf);
                    this.charBuf = null;
                }
                if (this.resizableBuffer != null) {
                    pConnection.cacheBuffer(this.resizableBuffer);
                    this.resizableBuffer = null;
                }
                this.currentBufferSize = 0;
                ** GOTO lbl114
            }
        }
        catch (Throwable var10_33) {
            var11_6 = null;
            if (OracleClobInputStream.TRACE == false) throw var10_33;
            if (OracleLog.recursiveEnter() == false) throw var10_33;
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var13_11 = null;
            }
            catch (Throwable var12_15) {
                var13_12 = null;
                OracleLog.recursiveExit();
                throw var12_15;
            }
lbl101:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return;
            try {}
            catch (Throwable var12_13) {
                var13_8 = null;
                OracleLog.recursiveExit();
                throw var12_13;
            }
            OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var13_7 = null;
            OracleLog.recursiveExit();
            return;
lbl114:
            // 1 sources

            var11_5 = null;
            if (OracleClobInputStream.TRACE == false) return;
            if (OracleLog.recursiveEnter() == false) return;
            try {}
            catch (Throwable var12_14) {
                var13_10 = null;
                OracleLog.recursiveExit();
                throw var12_14;
            }
            OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var13_9 = null;
            OracleLog.recursiveExit();
            return;
            OracleLog.recursiveExit();
            throw var10_33;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            OracleConnection oracleConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    oracleConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                OracleConnection __result__ = this.clob.getInternalConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = __result__;
            }
            catch (Exception exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var6_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = null;
                Object var8_10 = null;
                if (!TRACE) return oracleConnection;
                if (!OracleLog.recursiveEnter()) return oracleConnection;
                try {}
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            Object var8_9 = null;
            if (!TRACE) return oracleConnection;
            if (!OracleLog.recursiveEnter()) return oracleConnection;
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

