/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.KeywordValueLong;

class KeywordValueLongI
extends KeywordValueLong {
    private int keyword;
    private String textValue;
    private byte[] textValueArr;
    private byte[] binaryValue;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    KeywordValueLongI(int _keyword, String _textValue, byte[] _binaryValue) {
        this.keyword = _keyword;
        this.textValue = _textValue;
        this.binaryValue = _binaryValue;
        this.textValueArr = null;
    }

    void doCharConversion(DBConversion conv) throws SQLException {
        this.textValueArr = (byte[])(this.textValue != null ? conv.StringToCharBytes(this.textValue) : null);
    }

    public byte[] getBinaryValue() throws SQLException {
        return this.binaryValue;
    }

    public String getTextValue() throws SQLException {
        return this.textValue;
    }

    public int getKeyword() throws SQLException {
        return this.keyword;
    }

    void marshal(T4CMAREngine mar) throws IOException {
        if (this.textValueArr != null) {
            mar.marshalUB4(this.textValueArr.length);
            mar.marshalCLR(this.textValueArr, this.textValueArr.length);
            mar.marshalUB4(0L);
        } else {
            mar.marshalUB4(0L);
            if (this.binaryValue != null) {
                mar.marshalUB4(this.binaryValue.length);
                mar.marshalCLR(this.binaryValue, this.binaryValue.length);
            } else {
                mar.marshalUB4(0L);
            }
        }
        mar.marshalUB2(this.keyword);
    }

    static KeywordValueLongI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        int kpdkvlbl;
        int[] intArr = new int[1];
        String kpdkvlcv = null;
        byte[] kpdkvlbv = null;
        int kpdkvlcl = (int)mar.unmarshalUB4();
        if (kpdkvlcl != 0) {
            byte[] textValueArr = new byte[kpdkvlcl];
            mar.unmarshalCLR(textValueArr, 0, intArr);
            kpdkvlcv = mar.conv.CharBytesToString(textValueArr, textValueArr.length);
        }
        if ((kpdkvlbl = (int)mar.unmarshalUB4()) != 0) {
            kpdkvlbv = new byte[kpdkvlbl];
            mar.unmarshalCLR(kpdkvlbv, 0, intArr);
        }
        int kpdkvlk = mar.unmarshalUB2();
        return new KeywordValueLongI(kpdkvlk, kpdkvlcv, kpdkvlbv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    KeywordValueLongI.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("keyword    : " + this.keyword + "\n");
            sb.append("text value : " + this.textValue + "\n");
            if (this.binaryValue == null) {
                sb.append("bin value  : null\n");
            } else {
                sb.append("bin value  : " + NTFAQEvent.byteBufferToHexString(this.binaryValue, 50) + "\n");
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    KeywordValueLongI.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    KeywordValueLongI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                KeywordValueLongI.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.KeywordValueLongI"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

